/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.utils;

import de.dsite.io.Transformer;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.VersionedProject;
import de.dsite.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FortranUtils {
    private static final File FORTRAN_SOURCES_DIRECTORY = new File(FileUtils.getInstallationDir(), "fortran/");
    private static final File CONTAM_CLG = new File(FileUtils.getInstallationDir(), "files/contam.clg");
    private static final File SOIL_CLG = new File(FileUtils.getInstallationDir(), "files/soil.clg");
    private static final File SURFACT_CLG = new File(FileUtils.getInstallationDir(), "files/surfact.clg");
    private static final String NAME_OF_FORTRAN_INPUT_FILE = "smart.inp";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS = "Smart_windows32bit.exe";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_LINUX = "Smart_linux";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_MAC_OS = "smart2012.4";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS_64 = "Smart_windows64bit.exe";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_LINUX_64 = "Smart_linux";
    private static final String NAME_OF_FORTRAN_EXECUTABLE_FILE_MAC_OS_64 = "smart2012.4";

    public static void prepareDirectoryForFortranCalculation(File file) {
        boolean bl;
        if (!FileUtils.directoryExists(file)) {
            file.mkdir();
        }
        if (!FileUtils.directoryExists(FORTRAN_SOURCES_DIRECTORY)) {
            throw new IllegalArgumentException("'FORTRAN_SOURCES_DIRECTORY' (/fortran) does not exist!");
        }
        if (!FileUtils.fileExists(CONTAM_CLG)) {
            throw new IllegalArgumentException("'CONTAM_CLG' (/files/contam.clg) does not exist!");
        }
        if (!FileUtils.fileExists(SOIL_CLG)) {
            throw new IllegalArgumentException("'SOIL_CLG' (/files/soil.clg) does not exist!");
        }
        if (!FileUtils.fileExists(SURFACT_CLG)) {
            throw new IllegalArgumentException("'SURFACT_CLG' (/files/surfact.clg) does not exist!");
        }
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch");
        boolean bl2 = string.indexOf("windows") != -1;
        boolean bl3 = string.indexOf("linux") != -1;
        boolean bl4 = bl = string.indexOf("mac os x") != -1;
        if (!(bl2 || bl3 || bl)) {
            System.err.println("Unknown OS: don't know how to invoke shell");
            return;
        }
        File file2 = bl2 ? (string2.contains("64") ? new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS_64) : new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS)) : (bl3 ? (string2.contains("64") ? new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), "Smart_linux") : new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), "Smart_linux")) : (string2.contains("64") ? new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), "smart2012.4") : new File(FORTRAN_SOURCES_DIRECTORY.getAbsolutePath(), "smart2012.4")));
        try {
            FileUtils.copyFileToDirectory(file2, file);
            FileUtils.copyFileToDirectory(CONTAM_CLG, file);
            FileUtils.copyFileToDirectory(SOIL_CLG, file);
            FileUtils.copyFileToDirectory(SURFACT_CLG, file);
            file.setExecutable(true);
        }
        catch (Exception exception) {
            System.err.println("Copying file(s) to destiantion not possible!");
        }
    }

    public static String checkTimeStepRangesForProject(VersionedProject versionedProject) {
        double d;
        String string = "";
        double d2 = 0.0;
        double d3 = 0.0;
        for (SecondaryLayer secondaryLayer : versionedProject.getLeaves()) {
            d = secondaryLayer.getXUK() - secondaryLayer.getXOK();
            d3 += d;
            d2 += d / secondaryLayer.getHydraulic().getValues()[0];
        }
        d2 = d3 / d2;
        double d4 = versionedProject.getBcFlowValueTop();
        d = versionedProject.getBcFlowValueBottom();
        double d5 = 0.0;
        if (versionedProject.isZustrom()) {
            d5 = versionedProject.getBcFlowValueTop();
            d4 = 0.0;
        } else if (versionedProject.isAbstrom()) {
            d5 = versionedProject.getBcFlowValueTop();
            d = versionedProject.getBcFlowValueBottom();
        }
        if (versionedProject.isZustrom()) {
            d4 = d5 * d3 / versionedProject.getCrossSection() / d2 + d;
        } else if (versionedProject.isAbstrom()) {
            d = d4 - d5 * d3 / versionedProject.getCrossSection() / d2;
        } else {
            d5 = versionedProject.getCrossSection() * d2 * (d4 - d) / d3;
        }
        double d6 = d5 / versionedProject.getCrossSection();
        double[] dArray = new double[versionedProject.getLeaves().size()];
        int n = 0;
        for (SecondaryLayer secondaryLayer : versionedProject.getLeaves()) {
            dArray[n] = d6 / secondaryLayer.getHydraulic().getValues()[2];
            ++n;
        }
        double d7 = 1.0E30;
        if (versionedProject.getMode() == VersionedProject.SimulationMode.NORMAL) {
            n = 0;
            for (SecondaryLayer secondaryLayer : versionedProject.getLeaves()) {
                double d8 = secondaryLayer.getXUK() - secondaryLayer.getXOK();
                double d9 = d8 / dArray[n] / (double)secondaryLayer.getNumModellzellen();
                if (!(d7 > d9)) continue;
                d7 = d9;
            }
        } else {
            n = 0;
            for (SecondaryLayer secondaryLayer : versionedProject.getLeaves()) {
                double d10;
                if (secondaryLayer.isResidenceCalculationFromFile()) {
                    File file = new File(secondaryLayer.getResidenceFile());
                    d10 = FileUtils.minimumDistanceFromResidenceDataFile(file);
                } else {
                    double d11 = secondaryLayer.getXUK() - secondaryLayer.getXOK();
                    double d12 = 10.0 / Math.sqrt(d11 / secondaryLayer.getResidenceAlpha());
                    double d13 = d12 * (double)((int)(d11 / dArray[n]));
                    d10 = d13 / (double)secondaryLayer.getResidenceNumOfCells();
                }
                if (d10 < d7) {
                    d7 = d10;
                }
                ++n;
            }
        }
        for (n = 0; n < versionedProject.getTimesteps().numberOfTimesteps(); ++n) {
            int n2 = (int)versionedProject.getTimesteps().getTimeStepLengthForTimestepAtIndexInSeconds(n);
            if (!((double)n2 > d7)) continue;
            int n3 = versionedProject.getTimesteps().getTimeStepCountForTimestepAtIndex(n);
            long l = (long)n2 * (long)n3;
            versionedProject.getTimesteps().setTimeStepLengthForTimestepAtIndexInSeconds(n, (int)d7);
            versionedProject.getTimesteps().setTimeStepCountForTimestepAtIndex(n, (int)(l / (long)((int)d7)));
            string = string.concat("\nChanged length of timestep period " + n + " from " + n2 + " to " + (int)d7);
        }
        return string == "" ? null : string;
    }

    public static void generateFortranInputFileWithProjectData(VersionedProject versionedProject, File file) throws IOException, FileNotFoundException {
        if (!FileUtils.directoryExists(file)) {
            throw new IllegalArgumentException("Directory 'directoryForInputFile' does not exist!");
        }
        File file2 = new File(file.getAbsolutePath(), NAME_OF_FORTRAN_INPUT_FILE);
        Transformer transformer = new Transformer(versionedProject, file2);
        transformer.gererateInputFile();
    }

    public static ProcessBuilder buildProcess() {
        boolean bl;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch");
        boolean bl2 = string.indexOf("windows") != -1;
        boolean bl3 = string.indexOf("linux") != -1;
        boolean bl4 = bl = string.indexOf("mac os x") != -1;
        if (!(bl2 || bl3 || bl)) {
            System.err.println("Unknown OS: don't know how to invoke shell");
            return null;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl2) {
            string3 = string3.concat("cmd");
            string4 = string4.concat("/c");
            string5 = string2.contains("64") ? string5.concat(NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS_64) : string5.concat(NAME_OF_FORTRAN_EXECUTABLE_FILE_WINDOWS);
        } else if (bl3) {
            string3 = string3.concat("bash");
            string4 = string4.concat("-c");
            string5 = string2.contains("64") ? string5.concat("./Smart_linux") : string5.concat("./Smart_linux");
        } else {
            string3 = string3.concat("bash");
            string4 = string4.concat("-c");
            string5 = string2.contains("64") ? string5.concat("./smart2012.4") : string5.concat("./smart2012.4");
        }
        return new ProcessBuilder(string3, string4, string5);
    }
}

