/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.utils;

import de.dsite.data.GrainSize;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.main.RunSmart;
import de.dsite.project.VersionedProject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class FileUtils {
    private static final String NAME_OF_PROJECT_DIRECTORY = "project/";
    private static final String NAME_OF_EXAMPLES_DIRECTORY = "examples/";
    private static final String NAME_OF_DATA_DIRECTORY = "data/";
    private static final String NAME_OF_MATERIAL_DIRECTORY = "files/";
    private static final String NAME_OF_CATALOGFILE_DIRECTORY = "files/";
    private static final String NAME_OF_PROPERTIES_DIRECTORY = "properties/";

    public static boolean directoryExists(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isFile();
    }

    private static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileChannel fileChannel = fileInputStream.getChannel();
        FileChannel fileChannel2 = fileOutputStream.getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            fileChannel.close();
            fileChannel2.close();
            fileInputStream.close();
            fileChannel2.close();
            fileOutputStream.close();
            file2.setExecutable(true);
        }
    }

    public static void copyFileToDirectory(File file, File file2) {
        if (!FileUtils.fileExists(file)) {
            throw new IllegalArgumentException("File " + file.getName() + " does not exist!");
        }
        if (!FileUtils.directoryExists(file2)) {
            throw new IllegalArgumentException("Directory " + file2.getName() + " does not exist!");
        }
        File file3 = new File(file2.getAbsolutePath().concat("/" + file.getName()));
        if (!file3.exists()) {
            try {
                FileUtils.copyFile(file, file3);
            }
            catch (Exception exception) {
                System.err.println("Copying file to destiantion not possible!");
            }
        }
    }

    public static void deleteDirectoryContents(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                FileUtils.deleteDirectoryContents(file2);
            }
            file2.delete();
        }
    }

    public static File getCatalogFilePollutant() {
        File file = new File(FileUtils.getInstallationDir(), "files/".concat("contam.clg"));
        if (!FileUtils.fileExists(file)) {
            return null;
        }
        return file;
    }

    public static File getCatalogFilePollutantInDirectory(File file) {
        File file2 = new File(file.getAbsolutePath(), "contam.clg");
        if (!FileUtils.fileExists(file2)) {
            return null;
        }
        return file2;
    }

    public static File getCatalogFileSurfactant() {
        File file = new File(FileUtils.getInstallationDir(), "files/".concat("surfact.clg"));
        if (!FileUtils.fileExists(file)) {
            return null;
        }
        return file;
    }

    public static File getCatalogFileSurfactantInDirectory(File file) {
        File file2 = new File(file.getAbsolutePath(), "surfact.clg");
        if (!FileUtils.fileExists(file2)) {
            return null;
        }
        return file2;
    }

    public static File getCatalogFileSoil() {
        File file = new File(FileUtils.getInstallationDir(), "files/".concat("soil.clg"));
        if (!FileUtils.fileExists(file)) {
            return null;
        }
        return file;
    }

    public static File getCatalogFileSoilInDirectory(File file) {
        File file2 = new File(file.getAbsolutePath(), "soil.clg");
        if (!FileUtils.fileExists(file2)) {
            return null;
        }
        return file2;
    }

    public static ArrayList<CatalogObject> convertCatalogFileToPollutants(File file) {
        ArrayList<CatalogObject> arrayList = new ArrayList<CatalogObject>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (Pattern.matches("^\\s*[0-9]+\\s.*", string) && bl) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    String string2 = stringArray[1];
                    double[] dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = Double.parseDouble(stringArray[i].replace("d", "e"));
                    }
                    Pollutant pollutant = new Pollutant(string2);
                    pollutant.setValues(dArray);
                    arrayList.add(pollutant);
                }
                if (Pattern.matches("^__DATA.*", string)) {
                    bl = true;
                }
                Collections.sort(arrayList);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static ArrayList<CatalogObject> convertCatalogFileToAquifermaterial(File file) {
        ArrayList<CatalogObject> arrayList = new ArrayList<CatalogObject>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (Pattern.matches("^\\s*[0-9]+\\s.*", string) && bl) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    String string2 = stringArray[1];
                    double[] dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = Double.parseDouble(stringArray[i].replace("d", "e"));
                    }
                    AquiferMaterial aquiferMaterial = new AquiferMaterial(string2);
                    aquiferMaterial.setValues(dArray);
                    arrayList.add(aquiferMaterial);
                }
                if (Pattern.matches("^__DATA.*", string)) {
                    bl = true;
                }
                Collections.sort(arrayList);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static ArrayList<CatalogObject> convertCatalogFileToSurfactants(File file) {
        ArrayList<CatalogObject> arrayList = new ArrayList<CatalogObject>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (Pattern.matches("^\\s*[0-9]+\\s.*", string) && bl) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    String string2 = stringArray[1];
                    double[] dArray = new double[stringArray.length - 2];
                    for (int i = 2; i < stringArray.length; ++i) {
                        dArray[i - 2] = Double.parseDouble(stringArray[i].replace("d", "e"));
                    }
                    Surfactant surfactant = new Surfactant(string2, dArray[0]);
                    arrayList.add(surfactant);
                }
                if (Pattern.matches("^__DATA.*", string)) {
                    bl = true;
                }
                Collections.sort(arrayList);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static void pollutantsToFile(ArrayList<Pollutant> arrayList, File file) {
        HashSet<CatalogObject> hashSet = new HashSet<CatalogObject>();
        hashSet.addAll(arrayList);
        ArrayList<CatalogObject> arrayList2 = FileUtils.convertCatalogFileToPollutants(file);
        for (CatalogObject catalogObject : arrayList2) {
            hashSet.add((Pollutant)catalogObject);
        }
        FileUtils.objectsToFile(hashSet, file);
    }

    public static void surfactantsToFile(ArrayList<Surfactant> arrayList, File file) {
        HashSet<CatalogObject> hashSet = new HashSet<CatalogObject>();
        hashSet.addAll(arrayList);
        ArrayList<CatalogObject> arrayList2 = FileUtils.convertCatalogFileToSurfactants(file);
        for (CatalogObject catalogObject : arrayList2) {
            hashSet.add((Surfactant)catalogObject);
        }
        FileUtils.objectsToFile(hashSet, file);
    }

    public static void aquiferMaterialsToFile(ArrayList<AquiferMaterial> arrayList, File file) {
        HashSet<CatalogObject> hashSet = new HashSet<CatalogObject>();
        hashSet.addAll(arrayList);
        ArrayList<CatalogObject> arrayList2 = FileUtils.convertCatalogFileToAquifermaterial(file);
        for (CatalogObject catalogObject : arrayList2) {
            hashSet.add((AquiferMaterial)catalogObject);
        }
        FileUtils.objectsToFile(hashSet, file);
    }

    private static void objectsToFile(Set<CatalogObject> set, File file) {
        String string = new String("__DATA\n");
        if (set != null && set.size() > 0) {
            for (CatalogObject catalogObject : set) {
                string = string.concat(catalogObject.getId() + " " + catalogObject.getBezeichnung() + " " + catalogObject.valuesToString() + "\n");
            }
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static ArrayList<double[]> compositionFromMaterialFile(File file) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl && !Pattern.matches("^$", string) && !Pattern.matches("^__.*", string)) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    double[] dArray = new double[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        dArray[i] = Double.parseDouble(stringArray[i].replace("d", "e"));
                    }
                    arrayList.add(dArray);
                }
                if (Pattern.matches("^__COMPOSITION.*", string)) {
                    bl = true;
                    continue;
                }
                if (!Pattern.matches("^__.*", string)) continue;
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static String nameFromMaterialFile(File file) {
        String string = "";
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = null;
            boolean bl = false;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (bl && !Pattern.matches("^$", string2) && !Pattern.matches("^__.*", string2)) {
                    string = string2;
                    bufferedReader.close();
                    return string;
                }
                if (Pattern.matches("^__NAME.*", string2)) {
                    bl = true;
                    continue;
                }
                if (!Pattern.matches("^__.*", string2)) continue;
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static ArrayList<GrainSize> grainsizesFromMaterialFile(File file) {
        ArrayList<GrainSize> arrayList = new ArrayList<GrainSize>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl && !Pattern.matches("^$", string) && !Pattern.matches("^__.*", string)) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    double d = Double.parseDouble(stringArray[2].replace("d", "e"));
                    GrainSize grainSize = new GrainSize(string2, string3, d);
                    arrayList.add(grainSize);
                }
                if (Pattern.matches("^__GRAINSIZES.*", string)) {
                    bl = true;
                    continue;
                }
                if (!Pattern.matches("^__.*", string)) continue;
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static ArrayList<CatalogObject> componentsFromMaterialFile(File file) {
        ArrayList<CatalogObject> arrayList = new ArrayList<CatalogObject>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (bl && !Pattern.matches("^$", string) && !Pattern.matches("^__.*", string)) {
                    string = string.trim();
                    String[] stringArray = string.split("\\s+", 0);
                    String string2 = stringArray[0];
                    double[] dArray = new double[stringArray.length - 1];
                    for (int i = 1; i < stringArray.length; ++i) {
                        dArray[i - 1] = Double.parseDouble(stringArray[i].replace("d", "e"));
                    }
                    AquiferMaterial aquiferMaterial = new AquiferMaterial(string2);
                    aquiferMaterial.setValues(dArray);
                    arrayList.add(aquiferMaterial);
                }
                if (Pattern.matches("^__COMPONENTS.*", string)) {
                    bl = true;
                    continue;
                }
                if (!Pattern.matches("^__.*", string)) continue;
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object openProject(File file) {
        if (FileUtils.fileExists(file)) {
            FileInputStream fileInputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                Object object2 = object;
                return object2;
            }
            catch (Exception exception) {
                System.err.println("Generating Project from File '" + file.getAbsolutePath() + "' was not possible!");
                exception.printStackTrace();
                Object var4_6 = null;
                return var4_6;
            }
        }
        return null;
    }

    public static boolean projectSubfolderExists(String string) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Passed String 'nameOfScenario' must not be null/empty!");
        }
        File file = new File(FileUtils.getInstallationDir(), NAME_OF_PROJECT_DIRECTORY.concat(string));
        return FileUtils.directoryExists(file);
    }

    public static File getProjectSubfolder(String string) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Passed String 'subFolderName' must not be null/empty!");
        }
        return new File(FileUtils.getInstallationDir(), NAME_OF_PROJECT_DIRECTORY.concat(string));
    }

    public static File dataSubfolderExists(String string) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Passed String 'subFolderName' must not be null/empty!");
        }
        File file = new File(FileUtils.getInstallationDir(), NAME_OF_DATA_DIRECTORY.concat(string));
        if (FileUtils.fileExists(file)) {
            return file;
        }
        return null;
    }

    public static File getDataFolder_old() {
        return new File(NAME_OF_DATA_DIRECTORY);
    }

    public static File getDataFolder() {
        return new File(FileUtils.getInstallationDir(), NAME_OF_DATA_DIRECTORY);
    }

    public static File getMaterialFolder_old() {
        return new File("files/");
    }

    public static File getMaterialFolder() {
        return new File(FileUtils.getInstallationDir(), "files/");
    }

    public static File getExapmlesFolder_old() {
        return new File(NAME_OF_EXAMPLES_DIRECTORY);
    }

    public static File getExapmlesFolder() {
        return new File(FileUtils.getInstallationDir(), NAME_OF_EXAMPLES_DIRECTORY);
    }

    public static File getPropertiesFolder() {
        return new File(FileUtils.getInstallationDir(), NAME_OF_PROPERTIES_DIRECTORY);
    }

    public static String getInstallationDir() {
        String string = null;
        try {
            File file = new File(RunSmart.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            string = file.getParent();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return string;
    }

    public static File createProjectSubFolder(String string) {
        File file = FileUtils.getProjectSubfolder(string);
        file.mkdir();
        return file;
    }

    public static File createProjectSubFolder(String string, boolean bl) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Passed String 'subFolderName' must not be null/empty!");
        }
        File file = new File(FileUtils.getInstallationDir(), NAME_OF_PROJECT_DIRECTORY.concat(string));
        if (FileUtils.directoryExists(file) && bl) {
            FileUtils.deleteDirectoryContents(file);
        } else if (FileUtils.directoryExists(file) && !bl) {
            for (File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    FileUtils.deleteDirectoryContents(file2);
                    continue;
                }
                if (file2.getName().contains(".meas.")) continue;
                file2.delete();
            }
            return file;
        }
        file.mkdir();
        return file;
    }

    public static File createProjectSubFolder_old(String string, boolean bl) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("Passed String 'subFolderName' must not be null/empty!");
        }
        File file = new File(FileUtils.getInstallationDir(), NAME_OF_PROJECT_DIRECTORY.concat(string));
        if (!FileUtils.directoryExists(file) || !bl) {
            return null;
        }
        FileUtils.deleteDirectoryContents(file);
        file.mkdir();
        return file;
    }

    public static boolean directoryForScenarioExists_old(String string) {
        return FileUtils.directoryExists(new File(NAME_OF_PROJECT_DIRECTORY.concat(string)));
    }

    public static File directoryForScenarioExists(String string) {
        return new File(FileUtils.getInstallationDir(), NAME_OF_EXAMPLES_DIRECTORY.concat(string));
    }

    public static boolean saveProject(File file, VersionedProject versionedProject) {
        if (file == null || file.getName() == "") {
            throw new IllegalArgumentException("Passed file must not be null/filename must not be empty!");
        }
        if (versionedProject == null) {
            throw new IllegalArgumentException("Passed project must not be null!");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(versionedProject);
            objectOutputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFileExtension(File file) {
        String string = "";
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static File getInitialProjectFile() {
        return new File(new File(FileUtils.getInstallationDir(), NAME_OF_EXAMPLES_DIRECTORY), "initProject");
    }

    public static File getInitialProjectFile_old() {
        return new File(NAME_OF_PROJECT_DIRECTORY, "initProject");
    }

    public static double minimumDistanceFromResidenceDataFile(File file) {
        if (!FileUtils.fileExists(file)) {
            throw new IllegalArgumentException("File " + file.getName() + " does not exist!");
        }
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                String[] stringArray = string.split("\\s+", 0);
                double d4 = Double.parseDouble(stringArray[0].replace("d", "e"));
                if (n > 1) {
                    d = d4 - d2;
                    if (d < d3) {
                        d3 = d;
                    }
                    d2 = d4;
                } else if (n == 1) {
                    d2 = d3 = d4;
                }
                ++n;
            }
            bufferedReader.close();
            return d3;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }
}

