/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.controller.MainWindowController;
import de.dsite.data.GrainSize;
import de.dsite.data.Layer;
import de.dsite.data.ObservedProject;
import de.dsite.data.Pair;
import de.dsite.data.Project;
import de.dsite.data.Series;
import de.dsite.data.SorptionMatrix;
import de.dsite.data.Timesteps;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.ProjectListener;
import de.dsite.project.BioDegradationTableMap;
import de.dsite.project.BioDegradationValue;
import de.dsite.project.BoundaryCondition;
import de.dsite.project.Hydraulic;
import de.dsite.project.InitialBoundaryCondition;
import de.dsite.project.Material;
import de.dsite.project.MaterialReadOnly;
import de.dsite.project.ModelParameter;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.SorptionTableMap;
import de.dsite.project.SorptionValue;
import de.dsite.project.TableMap;
import de.dsite.utils.ResourceBundleUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class VersionedProject
implements Serializable,
ObservedProject {
    private static final long serialVersionUID = 1L;
    private transient ArrayList<ProjectListener> observer = new ArrayList();
    private String scenarioName;
    private String scenarioNote;
    private SimulationMode mode = SimulationMode.NORMAL;
    private ArrayList<Layer> layers;
    private ArrayList<SecondaryLayer> leaves;
    private double crossSection;
    private Timesteps timeSteps;
    private final Set<Material> materialSet = new HashSet<Material>();
    private final Set<Hydraulic> hydraulicSet = new HashSet<Hydraulic>();
    private final Set<Pollutant> pollutantSet = new HashSet<Pollutant>();
    private final Set<Surfactant> surfactantSet = new HashSet<Surfactant>();
    private final Set<AquiferMaterial> aquiferMaterialSet = new HashSet<AquiferMaterial>();
    private double bcFlowValueTop;
    private double bcFlowValueBottom;
    boolean zustrom = true;
    boolean abstrom = true;
    private TableMap<Pollutant, SecondaryLayer, BioDegradationValue> bioDegradationValues = new BioDegradationTableMap();
    private TableMap<Pollutant, AquiferMaterial, SorptionValue> sorptionValues = new SorptionTableMap();
    private BoundaryCondition pollutantUpperBoundary = new BoundaryCondition();
    private BoundaryCondition surfactantUpperBoundary = new BoundaryCondition();
    private InitialBoundaryCondition pollutantInitialBoundary = new InitialBoundaryCondition();
    private InitialBoundaryCondition surfactantInitialBoundary = new InitialBoundaryCondition();
    private HashMap<Pollutant, SorptionMatrix> sorptionMap;
    private double[] btcValues;
    private double[] profileValues;
    private ModelParameter furtherModelParameters = new ModelParameter();
    private boolean calculationFocKoc = false;
    private boolean calculationKd = true;
    private boolean calculationDaq = false;
    private boolean sorpModeFocKoc = false;
    private Set<ConcentrationValue> concentrationPollutant = new HashSet<ConcentrationValue>();
    private Set<ConcentrationValue> concentrationAquiferMaterial = new HashSet<ConcentrationValue>();
    private Map<Pair, double[]> solubilizationValues;
    private Map<Pair, double[]> adsolubilizationValues;
    private Map<Pair, double[]> monomereLayerValues;
    private Series.Unit unit;

    /*
     * WARNING - void declaration
     */
    public VersionedProject(Project project) {
        void var6_34;
        void var6_32;
        void var6_29;
        void var6_27;
        this.timeSteps = new Timesteps();
        int[][] nArray = project.getZeitschritte();
        for (int i = 0; i < nArray.length; ++i) {
            this.timeSteps.addTimestep(nArray[i][1], nArray[i][2]);
        }
        this.concentrationPollutant.add(ConcentrationValue.DISS);
        this.scenarioName = project.getSzenarioBezeichnung();
        this.mode = project.getSimulationsModus() == 1 ? SimulationMode.SMART : SimulationMode.NORMAL;
        this.scenarioNote = project.getBemerkungen();
        this.crossSection = project.getCrossSection();
        this.leaves = new ArrayList();
        for (de.dsite.data.SecondaryLayer object5 : project.getLeaves()) {
            de.dsite.data.Material material = object5.getMaterial();
            Material material2 = new Material(material.getName(), material.getIndex());
            de.dsite.data.Hydraulic hydraulic = object5.getHydraulic();
            Hydraulic hydraulic2 = new Hydraulic(hydraulic.getValues(), hydraulic.getColor(), hydraulic.getId() - 1);
            for (CatalogObject catalogObject : material.getMfm().getComponents()) {
                material2.addAquiferMaterial((AquiferMaterial)catalogObject);
            }
            for (GrainSize grainSize : material.getMfm().getFractions()) {
                material2.addGrainSize(grainSize);
                material2.setTotalFractionForGrainSize(grainSize, material.getMfm().getPercentageOfFraction(grainSize));
            }
            for (CatalogObject catalogObject : material.getMfm().getComponents()) {
                for (GrainSize grainSize : material.getMfm().getFractions()) {
                    material2.setMassFractionValue((AquiferMaterial)catalogObject, grainSize, material.getMfm().getValue(catalogObject, grainSize));
                }
            }
            SecondaryLayer secondaryLayer = new SecondaryLayer(object5.getName(), object5.getXOK(), object5.getXUK(), object5.getNumModellzellen(), hydraulic2, material2);
            secondaryLayer.setResidenceAlpha(object5.getResidenceAlpha());
            secondaryLayer.setResidenceNumOfCells(object5.getResidenceNumOfCells());
            secondaryLayer.setResidenceCalculationFromFile(object5.isResidenceCalculationFromFile());
            secondaryLayer.setResidenceFile(object5.getResidenceFile());
            this.materialSet.add(material2);
            this.hydraulicSet.add(hydraulic2);
            this.getBioDegradationValues().addColumnElement(secondaryLayer);
            this.leaves.add(secondaryLayer);
        }
        this.layers = new ArrayList();
        int n3 = 0;
        for (Layer layer : project.getLayers()) {
            if (layer instanceof de.dsite.data.SecondaryLayer) {
                this.layers.add(this.leaves.get(n3));
                ++n3;
                continue;
            }
            if (!(layer instanceof Layer)) continue;
            this.layers.add(layer);
        }
        this.bcFlowValueTop = project.getBcFlowValueTop();
        this.bcFlowValueBottom = project.getBcFlowValueBottom();
        this.zustrom = project.isZustrom();
        this.abstrom = project.isAbstrom();
        if (project.isConcentrationFixTop()) {
            // empty if block
        }
        if (project.isStageCompact()) {
            this.getPollutantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.SOLID);
        } else {
            this.getPollutantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.AQUEOUS);
        }
        if (project.isSteadyStage()) {
            this.getPollutantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.EQUILIBRIUM);
        } else {
            this.getPollutantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.NON_EQUILIBRIUM);
        }
        if (project.isStageCompactSur()) {
            this.getSurfactantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.SOLID);
        } else {
            this.getSurfactantInitialBoundary().setSystemPhase(InitialBoundaryCondition.Phase.AQUEOUS);
        }
        if (project.isSteadyStageSur()) {
            this.getSurfactantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.EQUILIBRIUM);
        } else {
            this.getSurfactantInitialBoundary().setSystemState(InitialBoundaryCondition.Equilibrium.NON_EQUILIBRIUM);
        }
        boolean bl = false;
        for (CatalogObject catalogObject : project.getPolSelected()) {
            int n;
            this.getBioDegradationValues().addRowElement((Pollutant)catalogObject);
            for (de.dsite.data.SecondaryLayer secondaryLayer : project.getLeaves()) {
                double[] dArray = project.getBioMatrix().getBioReductionValuesForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer);
                if (dArray != null) {
                    Object object = dArray[0] == 0.0 ? BioDegradationValue.DegradationMode.NO_DEGRADATION : (dArray[0] == 1.0 ? BioDegradationValue.DegradationMode.DEGRADATION_OF_NTH_ORDER : (dArray[0] == 2.0 ? BioDegradationValue.DegradationMode.LH_KINETICS : BioDegradationValue.DegradationMode.NO_DEGRADATION));
                    BioDegradationValue bioDegradationValue = new BioDegradationValue((BioDegradationValue.DegradationMode)((Object)object), dArray[1], (int)dArray[2], dArray[3]);
                    this.getBioDegradationValues().putValue((Pollutant)catalogObject, this.leaves.get(n), bioDegradationValue);
                } else {
                    this.getBioDegradationValues().putValue((Pollutant)catalogObject, this.leaves.get(n), BioDegradationValue.defaultBioDegradationValue());
                }
                ++n;
            }
            n = 0;
        }
        for (CatalogObject catalogObject : project.getPolSelected()) {
            this.getSorptionValues().addRowElement((Pollutant)catalogObject);
            SorptionMatrix sorptionMatrix = project.getSorptionMap().get((Pollutant)catalogObject);
            for (CatalogObject catalogObject2 : project.getAmatSelected()) {
                void var10_85;
                this.getSorptionValues().addColumnElement((AquiferMaterial)catalogObject2);
                int n = sorptionMatrix.getAquiferMat().indexOf((AquiferMaterial)catalogObject2);
                if (n >= 0) {
                    double d = sorptionMatrix.getFeq()[n];
                    int n2 = sorptionMatrix.getType()[n];
                    double[] dArray = sorptionMatrix.getParams()[n];
                    SorptionValue.IsothermType isothermType = n2 == 1 ? SorptionValue.IsothermType.HENRY : (n2 == 2 ? SorptionValue.IsothermType.FREUNDLICH : (n2 == 3 ? SorptionValue.IsothermType.LANGMUIR : (n2 == 4 ? SorptionValue.IsothermType.BET : SorptionValue.IsothermType.HENRY)));
                    SorptionValue sorptionValue = SorptionValue.defaultSorptionValue(isothermType);
                    sorptionValue.setEquilibriumFraction(d);
                    sorptionValue.setParameter1(dArray[0]);
                    sorptionValue.setParameter2(dArray[1]);
                    sorptionValue.setParameter3(dArray[2]);
                } else {
                    SorptionValue sorptionValue = SorptionValue.defaultSorptionValue(SorptionValue.IsothermType.HENRY);
                }
                this.getSorptionValues().putValue((Pollutant)catalogObject, (AquiferMaterial)catalogObject2, (SorptionValue)var10_85);
            }
        }
        if (project.isModInterpol()) {
            this.pollutantUpperBoundary.setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
        } else if (project.isModEV()) {
            this.pollutantUpperBoundary.setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
        } else if (project.isModNV()) {
            this.pollutantUpperBoundary.setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
        }
        if (project.isModInterpolAB()) {
            this.pollutantInitialBoundary.setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
        } else if (project.isModEVAB()) {
            this.pollutantInitialBoundary.setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
        } else if (project.isModNVAB()) {
            this.pollutantInitialBoundary.setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
        }
        if (project.isModInterpolSur()) {
            this.surfactantUpperBoundary.setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
        } else if (project.isModEVSur()) {
            this.surfactantUpperBoundary.setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
        } else if (project.isModNVSur()) {
            this.surfactantUpperBoundary.setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
        }
        if (project.isModInterpolABSur()) {
            this.surfactantInitialBoundary.setMode(BoundaryCondition.CalculationMode.INTERPOLATION);
        } else if (project.isModEVABSur()) {
            this.surfactantInitialBoundary.setMode(BoundaryCondition.CalculationMode.EARLIER_VALUE);
        } else if (project.isModNVABSur()) {
            this.surfactantInitialBoundary.setMode(BoundaryCondition.CalculationMode.NEXT_VALUE);
        }
        this.sorptionMap = project.getSorptionMap();
        this.btcValues = project.getBtcValues();
        this.profileValues = project.getProfileValues();
        this.getFurtherModelParameters().setTransportModel(project.getDimTransportmodell());
        this.getFurtherModelParameters().setConcentrationEquilibrium(project.getDimKonzentrationsgleichgewicht());
        this.getFurtherModelParameters().setCalculationProcessSteps(project.getDimProzessschritte());
        this.getFurtherModelParameters().setCalculationIPDiffusion(project.getDimIntrapartikeldiffusion());
        this.getFurtherModelParameters().setCalculationIPAnalytical(project.getDimIntrapartikeldiffusion_analyitsch());
        this.getFurtherModelParameters().setCalculationIPNumerical(project.getDimIp_diffusion());
        this.getFurtherModelParameters().setCalculationBioDegradation(project.getDimBioabbau());
        this.getFurtherModelParameters().setFurtherParameters(project.getDimWeitere_parameter());
        if (project.isModeAnalytic()) {
            this.getFurtherModelParameters().setIpCalculationMode(ModelParameter.CalculationMode.ANALYTICAL);
        } else if (project.isModeNumeric()) {
            this.getFurtherModelParameters().setIpCalculationMode(ModelParameter.CalculationMode.NUMERICAL);
        }
        this.calculationFocKoc = project.isCalculationFocKoc();
        this.calculationKd = project.isCalculationKd();
        this.calculationDaq = project.isCalculationDaq();
        this.sorpModeFocKoc = project.isSorpModeFocKoc();
        this.getFurtherModelParameters().setOutputControlMode(project.getOutputControlMode());
        this.getFurtherModelParameters().setTimestepRange(project.getTimestepRange());
        Project.FileFormat fileFormat = project.getFormatBTCAndProfileOutput();
        switch (fileFormat) {
            case CSV: {
                this.getFurtherModelParameters().setFormatBTCAndProfileOutput(ModelParameter.FileFormat.CSV);
                break;
            }
            case ASCII: {
                this.getFurtherModelParameters().setFormatBTCAndProfileOutput(ModelParameter.FileFormat.ASCII);
                break;
            }
            case MATLAB: {
                this.getFurtherModelParameters().setFormatBTCAndProfileOutput(ModelParameter.FileFormat.MATLAB);
                break;
            }
            case TECPLOT: {
                this.getFurtherModelParameters().setFormatBTCAndProfileOutput(ModelParameter.FileFormat.TECPLOT);
                break;
            }
            default: {
                this.getFurtherModelParameters().setFormatBTCAndProfileOutput(ModelParameter.FileFormat.CSV);
            }
        }
        block33: for (Project.ConcentrationValue concentrationValue : project.getConcentrationPollutant()) {
            switch (concentrationValue) {
                case DIFF: {
                    this.concentrationPollutant.add(ConcentrationValue.DIFF);
                    continue block33;
                }
                case DISS: {
                    this.concentrationPollutant.add(ConcentrationValue.DISS);
                    continue block33;
                }
                case MIC: {
                    this.concentrationPollutant.add(ConcentrationValue.MIC);
                    continue block33;
                }
                case MONO: {
                    this.concentrationPollutant.add(ConcentrationValue.MONO);
                    continue block33;
                }
                case RED: {
                    this.concentrationPollutant.add(ConcentrationValue.RED);
                    continue block33;
                }
                case SORB: {
                    this.concentrationPollutant.add(ConcentrationValue.SORB);
                    continue block33;
                }
            }
            this.concentrationPollutant.add(ConcentrationValue.DIFF);
        }
        block34: for (Project.ConcentrationValue concentrationValue : project.getConcentrationAquiferMaterial()) {
            switch (concentrationValue) {
                case DIFF: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.DIFF);
                    continue block34;
                }
                case DISS: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.DISS);
                    continue block34;
                }
                case MIC: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.MIC);
                    continue block34;
                }
                case MONO: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.MONO);
                    continue block34;
                }
                case RED: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.RED);
                    continue block34;
                }
                case SORB: {
                    this.concentrationAquiferMaterial.add(ConcentrationValue.SORB);
                    continue block34;
                }
            }
            this.concentrationAquiferMaterial.add(ConcentrationValue.DIFF);
        }
        this.solubilizationValues = project.getSolubilizationValues();
        this.adsolubilizationValues = project.getAdsolubilizationValues();
        this.monomereLayerValues = project.getMonomereLayerValues();
        this.unit = project.getUnit();
        for (CatalogObject catalogObject : project.getPolSelected()) {
            this.addPollutant((Pollutant)catalogObject);
        }
        for (CatalogObject catalogObject : project.getSurSelected()) {
            this.addSurfactant((Surfactant)catalogObject);
        }
        for (CatalogObject catalogObject : project.getAmatSelected()) {
            this.addAquiferMaterial((AquiferMaterial)catalogObject);
        }
        boolean bl2 = false;
        while (var6_27 < project.getTimes().length) {
            this.pollutantUpperBoundary.appendInterval();
            this.pollutantUpperBoundary.setDateValueForInterval(project.getTimes()[var6_27], (int)var6_27);
            ++var6_27;
        }
        boolean bl3 = false;
        while (var6_29 < project.getXvalues().length) {
            this.pollutantInitialBoundary.appendInterval();
            this.pollutantInitialBoundary.setDateValueForInterval(project.getXvalues()[var6_29], (int)var6_29);
            ++var6_29;
        }
        for (Pollutant pollutant : this.allPollutants()) {
            int n;
            if (project.getConcentrations().containsKey(pollutant)) {
                double[] dArray = project.getConcentrations().get(pollutant);
                for (n = 0; n < dArray.length; ++n) {
                    this.pollutantUpperBoundary.setValueForIntervalAndCatalogObject(dArray[n], n, pollutant);
                }
            }
            if (!project.getInitialConcentrations().containsKey(pollutant)) continue;
            double[] dArray = project.getInitialConcentrations().get(pollutant);
            for (n = 0; n < dArray.length; ++n) {
                this.pollutantInitialBoundary.setValueForIntervalAndCatalogObject(dArray[n], n, pollutant);
            }
        }
        boolean bl4 = false;
        while (var6_32 < project.getTimesSur().length) {
            this.surfactantUpperBoundary.appendInterval();
            this.surfactantUpperBoundary.setDateValueForInterval(project.getTimesSur()[var6_32], (int)var6_32);
            ++var6_32;
        }
        boolean bl5 = false;
        while (var6_34 < project.getXvaluesSur().length) {
            this.surfactantInitialBoundary.appendInterval();
            this.surfactantInitialBoundary.setDateValueForInterval(project.getXvaluesSur()[var6_34], (int)var6_34);
            ++var6_34;
        }
        for (Surfactant surfactant : this.allSurfactants()) {
            int n;
            if (project.getConcentrationsSur().containsKey(surfactant)) {
                double[] dArray = project.getConcentrationsSur().get(surfactant);
                for (n = 0; n < dArray.length; ++n) {
                    this.surfactantUpperBoundary.setValueForIntervalAndCatalogObject(dArray[n], n, surfactant);
                }
            }
            if (!project.getInitialConcentrationsSur().containsKey(surfactant)) continue;
            double[] dArray = project.getInitialConcentrations().get(surfactant);
            for (n = 0; n < dArray.length; ++n) {
                this.surfactantInitialBoundary.setValueForIntervalAndCatalogObject(dArray[n], n, surfactant);
            }
        }
        this.notifyListener();
    }

    public VersionedProject() {
        this.scenarioName = "";
        this.scenarioNote = "";
        Layer layer = new Layer(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_mainlayer) + ".1", 0.0, 1.0);
        SecondaryLayer secondaryLayer = new SecondaryLayer(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + ".1.1", 0.0, 1.0, 1);
        this.crossSection = 1.0;
        this.layers = new ArrayList();
        this.layers.add(layer);
        this.layers.add(secondaryLayer);
        this.leaves = new ArrayList();
        this.addLeave(secondaryLayer);
        this.timeSteps = new Timesteps();
        this.timeSteps.addTimestep();
        this.sorptionMap = new HashMap();
        this.concentrationPollutant.add(ConcentrationValue.DISS);
    }

    public void setSzenarioName(String string) {
        this.scenarioName = string;
    }

    public String getSzenarioName() {
        return this.scenarioName;
    }

    public void setScenarioNote(String string) {
        this.scenarioNote = string;
    }

    public String getScenarioNote() {
        return this.scenarioNote;
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
    }

    public boolean addLayerAtPosition(Layer layer, int n) {
        if (n >= 0 && n < this.layers.size()) {
            this.layers.add(n, layer);
            return true;
        }
        return false;
    }

    public boolean removeLayerAtPosition(int n) {
        if (n >= 0 && n < this.layers.size()) {
            this.layers.remove(n);
            return true;
        }
        return false;
    }

    public boolean isLayersvalid() {
        if (this.layers == null) {
            return false;
        }
        Layer layer = this.layers.get(0);
        ListIterator<Layer> listIterator = this.layers.listIterator(this.layers.size());
        while (listIterator.hasNext()) {
            Layer layer2 = listIterator.next();
            if (layer.getXOK() == layer2.getXOK() && layer.getXUK() == layer2.getXUK() || layer.getXUK() == layer2.getXOK()) {
                layer = layer2;
                continue;
            }
            return false;
        }
        return true;
    }

    public void setLeaves(ArrayList<SecondaryLayer> arrayList) {
        this.leaves = arrayList;
        this.notifyListener();
    }

    public List<SecondaryLayer> getLeaves() {
        return Collections.unmodifiableList(this.leaves);
    }

    public void addLeave(SecondaryLayer secondaryLayer) {
        this.leaves.add(secondaryLayer);
        this.getBioDegradationValues().addColumnElement(secondaryLayer);
        this.notifyListener();
    }

    public void removeLeave(int n) {
        if (n >= 0 && n < this.leaves.size()) {
            SecondaryLayer secondaryLayer = this.leaves.get(n);
            this.getBioDegradationValues().removeColumnElement(secondaryLayer);
            this.leaves.remove(n);
            this.notifyListener();
        }
    }

    public HashSet<GrainSize> allGrainSizes() {
        if (this.getMaterialSet().size() == 0) {
            return null;
        }
        HashSet<GrainSize> hashSet = new HashSet<GrainSize>();
        for (MaterialReadOnly materialReadOnly : this.getMaterialSet()) {
            for (GrainSize grainSize : materialReadOnly.getGrainSizes()) {
                hashSet.add(grainSize);
            }
        }
        return hashSet;
    }

    public HashSet<GrainSize> usedGrainSizes() {
        if (this.getUsedMaterialSet().size() == 0) {
            return null;
        }
        HashSet<GrainSize> hashSet = new HashSet<GrainSize>();
        for (MaterialReadOnly materialReadOnly : this.getUsedMaterialSet()) {
            for (GrainSize grainSize : materialReadOnly.getGrainSizes()) {
                hashSet.add(grainSize);
            }
        }
        return hashSet;
    }

    public void setBcFlowValueTop(double d) {
        this.bcFlowValueTop = d;
    }

    public double getBcFlowValueTop() {
        return this.bcFlowValueTop;
    }

    public void setBcFlowValueBottom(double d) {
        this.bcFlowValueBottom = d;
    }

    public double getBcFlowValueBottom() {
        return this.bcFlowValueBottom;
    }

    public void setZustrom(boolean bl) {
        this.zustrom = bl;
    }

    public boolean isZustrom() {
        return this.zustrom;
    }

    public void setAbstrom(boolean bl) {
        this.abstrom = bl;
    }

    public boolean isAbstrom() {
        return this.abstrom;
    }

    public void setSorptionMap(HashMap<Pollutant, SorptionMatrix> hashMap) {
        this.sorptionMap = hashMap;
    }

    public HashMap<Pollutant, SorptionMatrix> getSorptionMap() {
        return this.sorptionMap;
    }

    public void setCrossSection(double d) {
        this.crossSection = d;
    }

    public double getCrossSection() {
        return this.crossSection;
    }

    public double[] getBtcValues() {
        return this.btcValues;
    }

    public void setBtcValues(double[] dArray) {
        this.btcValues = dArray;
    }

    public double[] getProfileValues() {
        return this.profileValues;
    }

    public void setProfileValues(double[] dArray) {
        this.profileValues = dArray;
    }

    public boolean isCalculationFocKoc() {
        return this.calculationFocKoc;
    }

    public void setCalculationFocKoc(boolean bl) {
        this.calculationFocKoc = bl;
    }

    public boolean isCalculationKd() {
        return this.calculationKd;
    }

    public void setCalculationKd(boolean bl) {
        this.calculationKd = bl;
    }

    public boolean isCalculationDaq() {
        return this.calculationDaq;
    }

    public void setCalculationDaq(boolean bl) {
        this.calculationDaq = bl;
    }

    public Set<ConcentrationValue> getConcentrationPollutant() {
        return this.concentrationPollutant;
    }

    public void setConcentrationPollutant(Set<ConcentrationValue> set) {
        this.concentrationPollutant = set;
    }

    public Set<ConcentrationValue> getConcentrationAquiferMaterial() {
        return this.concentrationAquiferMaterial;
    }

    public void setConcentrationAquiferMaterial(Set<ConcentrationValue> set) {
        this.concentrationAquiferMaterial = set;
    }

    public boolean isSorpModeFocKoc() {
        return this.sorpModeFocKoc;
    }

    public void setSorpModeFocKoc(boolean bl) {
        this.sorpModeFocKoc = bl;
    }

    public void setSolubilizationValuesForPollutantAndSurfactant(Pollutant pollutant, Surfactant surfactant, double[] dArray) {
        this.getSolubilizationValues().put(new Pair(pollutant, surfactant), dArray);
    }

    public double[] getSolubilizationValuesForPolutantAndSurfactant(Pollutant pollutant, Surfactant surfactant) {
        if (this.getSolubilizationValues().get(new Pair(pollutant, surfactant)) == null) {
            return new double[]{1.0, 6.0, 0.0, 0.0, 0.0};
        }
        return this.getSolubilizationValues().get(new Pair(pollutant, surfactant));
    }

    private Map<Pair, double[]> getSolubilizationValues() {
        if (this.solubilizationValues == null) {
            this.solubilizationValues = new HashMap<Pair, double[]>();
        }
        return this.solubilizationValues;
    }

    public void setAdsolubilizationValuesForPollutantAndSurfactant(Pollutant pollutant, Surfactant surfactant, double[] dArray) {
        this.getAdsolubilizationValues().put(new Pair(pollutant, surfactant), dArray);
    }

    public double[] getAdsolubilizationValuesForPolutantAndSurfactant(Pollutant pollutant, Surfactant surfactant) {
        if (this.getAdsolubilizationValues().get(new Pair(pollutant, surfactant)) == null) {
            return new double[]{1.0, 6.0, 0.0, 0.0, 0.0};
        }
        return this.getAdsolubilizationValues().get(new Pair(pollutant, surfactant));
    }

    private Map<Pair, double[]> getAdsolubilizationValues() {
        if (this.adsolubilizationValues == null) {
            this.adsolubilizationValues = new HashMap<Pair, double[]>();
        }
        return this.adsolubilizationValues;
    }

    public void setMonomereLayerValuesForSurfactantAndAquiferMaterial(Surfactant surfactant, AquiferMaterial aquiferMaterial, double[] dArray) {
        this.getMonomereLayerValues().put(new Pair(surfactant, aquiferMaterial), dArray);
    }

    public double[] getMonomereLayerValuesForSurfactantAndAquiferMaterial(Surfactant surfactant, AquiferMaterial aquiferMaterial) {
        if (this.getMonomereLayerValues().get(new Pair(surfactant, aquiferMaterial)) == null) {
            return new double[]{1.0, 1.0, 0.0, 0.0, 0.0};
        }
        return this.getMonomereLayerValues().get(new Pair(surfactant, aquiferMaterial));
    }

    private Map<Pair, double[]> getMonomereLayerValues() {
        if (this.monomereLayerValues == null) {
            this.monomereLayerValues = new HashMap<Pair, double[]>();
        }
        return this.monomereLayerValues;
    }

    @Override
    public void addListener(ProjectListener projectListener) {
        this.getObserver().add(projectListener);
    }

    @Override
    public void removeListener(ProjectListener projectListener) {
        int n = this.getObserver().indexOf(projectListener);
        if (n >= 0) {
            this.getObserver().remove(n);
        }
    }

    @Override
    public void notifyListener() {
        for (ProjectListener projectListener : this.getObserver()) {
            projectListener.updateWithData(this.leaves);
        }
    }

    public ArrayList<ProjectListener> getObserver() {
        return this.observer;
    }

    public void setObserver(ArrayList<ProjectListener> arrayList) {
        this.observer = arrayList;
    }

    public Series.Unit getUnit() {
        if (this.unit == null) {
            this.unit = Series.Unit.SEC;
        }
        return this.unit;
    }

    public void setUnit(Series.Unit unit) {
        this.unit = unit;
    }

    public Timesteps getTimesteps() {
        return this.timeSteps;
    }

    public void setTimesteps(Timesteps timesteps) {
        this.timeSteps = timesteps;
    }

    public Set<Pollutant> getPollutantSet() {
        return Collections.unmodifiableSet(this.pollutantSet);
    }

    public ArrayList<Pollutant> allPollutants() {
        ArrayList<Pollutant> arrayList = new ArrayList<Pollutant>();
        if (this.pollutantSet.size() > 0) {
            arrayList.addAll(this.pollutantSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public boolean addPollutant(Pollutant pollutant) {
        boolean bl = this.pollutantSet.add(pollutant);
        if (bl) {
            this.getBioDegradationValues().addRowElement(pollutant);
            this.getSorptionValues().addRowElement(pollutant);
            this.getPollutantUpperBoundary().addCatalogObject(pollutant);
            this.getPollutantInitialBoundary().addCatalogObject(pollutant);
            return true;
        }
        return false;
    }

    public boolean deletePollutant(Pollutant pollutant) {
        boolean bl = this.pollutantSet.remove(pollutant);
        if (bl) {
            this.getBioDegradationValues().removeRowElement(pollutant);
            this.getSorptionValues().removeRowElement(pollutant);
            this.getPollutantUpperBoundary().deleteCatalogObject(pollutant);
            this.getPollutantInitialBoundary().deleteCatalogObject(pollutant);
            return true;
        }
        return false;
    }

    public boolean renamePollutant(Pollutant pollutant, String string) {
        if (pollutant == null || string == null || string == "") {
            return false;
        }
        for (Pollutant pollutant2 : this.allPollutants()) {
            if (!pollutant2.getBezeichnung().equals(string)) continue;
            return false;
        }
        this.deletePollutant(pollutant);
        pollutant.setBezeichnung(string);
        this.addPollutant(pollutant);
        return true;
    }

    public Set<Surfactant> getSurfactantSet() {
        return Collections.unmodifiableSet(this.surfactantSet);
    }

    public ArrayList<Surfactant> allSurfactants() {
        ArrayList<Surfactant> arrayList = new ArrayList<Surfactant>();
        if (this.surfactantSet.size() > 0) {
            arrayList.addAll(this.surfactantSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public boolean addSurfactant(Surfactant surfactant) {
        boolean bl = this.surfactantSet.add(surfactant);
        if (bl) {
            this.getSurfactantUpperBoundary().addCatalogObject(surfactant);
            this.getSurfactantInitialBoundary().addCatalogObject(surfactant);
            return true;
        }
        return false;
    }

    public boolean deleteSurfactant(Surfactant surfactant) {
        boolean bl = this.surfactantSet.remove(surfactant);
        if (bl) {
            this.getSurfactantUpperBoundary().deleteCatalogObject(surfactant);
            this.getSurfactantInitialBoundary().deleteCatalogObject(surfactant);
            return true;
        }
        return false;
    }

    public boolean renameSurfactant(Surfactant surfactant, String string) {
        if (surfactant == null || string == null || string == "") {
            return false;
        }
        for (Surfactant surfactant2 : this.allSurfactants()) {
            if (!surfactant2.getBezeichnung().equals(string)) continue;
            return false;
        }
        this.deleteSurfactant(surfactant);
        surfactant.setBezeichnung(string);
        this.addSurfactant(surfactant);
        return true;
    }

    public ArrayList<AquiferMaterial> allAquiferMaterials() {
        HashSet<AquiferMaterial> hashSet = new HashSet<AquiferMaterial>();
        for (Material material : this.allMaterials()) {
            for (AquiferMaterial aquiferMaterial : material.getAquiferMaterials()) {
                hashSet.add(aquiferMaterial);
            }
        }
        ArrayList arrayList = new ArrayList();
        if (hashSet.size() > 0) {
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public ArrayList<AquiferMaterial> usedAquiferMaterials() {
        HashSet<AquiferMaterial> hashSet = new HashSet<AquiferMaterial>();
        for (Material material : this.usedMaterials()) {
            for (AquiferMaterial aquiferMaterial : material.getAquiferMaterials()) {
                hashSet.add(aquiferMaterial);
            }
        }
        ArrayList arrayList = new ArrayList();
        if (hashSet.size() > 0) {
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public boolean addAquiferMaterial(AquiferMaterial aquiferMaterial) {
        boolean bl = this.aquiferMaterialSet.add(aquiferMaterial);
        if (bl) {
            this.getSorptionValues().addColumnElement(aquiferMaterial);
            return true;
        }
        return false;
    }

    public boolean deleteAquiferMaterial(AquiferMaterial aquiferMaterial) {
        boolean bl = this.aquiferMaterialSet.remove(aquiferMaterial);
        if (bl) {
            this.getSorptionValues().removeColumnElement(aquiferMaterial);
            return true;
        }
        return false;
    }

    public boolean renameAquiferMaterial(AquiferMaterial aquiferMaterial, String string) {
        Object object;
        if (aquiferMaterial == null || string == null || string == "") {
            return false;
        }
        for (AquiferMaterial object2 : this.allAquiferMaterials()) {
            if (!object2.getBezeichnung().equals(string)) continue;
            return false;
        }
        ArrayList arrayList = new ArrayList();
        for (Material bl2 : this.allMaterials()) {
            if (!bl2.getAquiferMaterials().contains(aquiferMaterial)) continue;
            arrayList.add(bl2);
        }
        boolean bl = this.deleteAquiferMaterial(aquiferMaterial);
        if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Material)iterator.next();
                if (!((Material)object).getAquiferMaterials().contains(aquiferMaterial)) continue;
                ((Material)object).deleteAquiferMaterial(aquiferMaterial);
            }
        }
        aquiferMaterial.setBezeichnung(string);
        boolean bl2 = this.addAquiferMaterial(aquiferMaterial);
        if (bl2) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                Material material = (Material)object.next();
                material.addAquiferMaterial(aquiferMaterial);
            }
        }
        return true;
    }

    public Set<Material> getMaterialSet() {
        return this.materialSet;
    }

    public Set<Material> getUsedMaterialSet() {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (SecondaryLayer secondaryLayer : this.leaves) {
            hashSet.add(secondaryLayer.getMaterial());
        }
        return hashSet;
    }

    public ArrayList<Material> allMaterials() {
        ArrayList<Material> arrayList = new ArrayList<Material>();
        if (this.materialSet.size() > 0) {
            arrayList.addAll(this.materialSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public ArrayList<Material> usedMaterials() {
        HashSet<Material> hashSet = new HashSet<Material>();
        for (SecondaryLayer secondaryLayer : this.leaves) {
            hashSet.add(secondaryLayer.getMaterial());
        }
        ArrayList arrayList = new ArrayList();
        if (hashSet.size() > 0) {
            arrayList.addAll(hashSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public boolean addMaterial(Material material) {
        boolean bl = this.materialSet.add(material);
        return bl;
    }

    public void addMaterialWithNameAndIndex(String string, int n) {
        this.materialSet.add(new Material(string, n));
    }

    public boolean renameMaterial(Material material, String string) {
        if (material == null || string == null || string == "") {
            return false;
        }
        for (Material material2 : this.materialSet) {
            if (!material2.getName().equals(string)) continue;
            return false;
        }
        this.materialSet.remove(material);
        material.setName(string);
        this.materialSet.add(material);
        return true;
    }

    public boolean deleteMaterial(Material material) {
        if (!this.materialSet.contains(material)) {
            return false;
        }
        boolean bl = this.materialSet.remove(material);
        if (bl) {
            for (SecondaryLayer secondaryLayer : this.leaves) {
                if (!material.equals(secondaryLayer.getMaterial())) continue;
                secondaryLayer.setMaterial(null);
                this.notifyListener();
            }
            return true;
        }
        return false;
    }

    public boolean setMaterialForLayer(SecondaryLayer secondaryLayer, Material material) {
        if (secondaryLayer != null && material != null && this.materialSet.contains(material) && this.leaves.contains(secondaryLayer)) {
            secondaryLayer.setMaterial(material);
            this.notifyListener();
            return true;
        }
        return false;
    }

    public ArrayList<Hydraulic> allHydraulics() {
        ArrayList<Hydraulic> arrayList = new ArrayList<Hydraulic>();
        if (this.hydraulicSet.size() > 0) {
            arrayList.addAll(this.hydraulicSet);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public Hydraulic addHydraulicWithValues(double d, double d2, double d3, double d4) {
        Hydraulic hydraulic = Hydraulic.defaultHydraulicWithIndex(this.allHydraulics().size());
        if (hydraulic != null) {
            hydraulic.setValues(new double[]{d, d2, d3, d4});
            this.hydraulicSet.add(hydraulic);
        }
        return hydraulic;
    }

    public boolean addHydraulic() {
        Hydraulic hydraulic = Hydraulic.defaultHydraulicWithIndex(this.allHydraulics().size());
        return hydraulic == null ? false : this.hydraulicSet.add(hydraulic);
    }

    public boolean deleteHydraulicsWithIndices(int[] nArray) {
        if (this.allHydraulics().size() < nArray.length) {
            return false;
        }
        HashSet<Hydraulic> hashSet = new HashSet<Hydraulic>();
        for (int i = 0; i < nArray.length; ++i) {
            hashSet.add(this.allHydraulics().get(nArray[i]));
        }
        this.hydraulicSet.removeAll(hashSet);
        for (Hydraulic object : hashSet) {
            for (SecondaryLayer secondaryLayer : this.leaves) {
                if (!object.equals(secondaryLayer.getHydraulic())) continue;
                secondaryLayer.setHydraulic(null);
                this.notifyListener();
            }
        }
        int n = 0;
        for (Hydraulic hydraulic : this.allHydraulics()) {
            if (!hydraulic.isNameIndexCompliant(n)) {
                this.hydraulicSet.remove(hydraulic);
                hydraulic.setIndex(n);
                this.hydraulicSet.add(hydraulic);
            }
            ++n;
        }
        return true;
    }

    public boolean setHydraulicForLayer(SecondaryLayer secondaryLayer, Hydraulic hydraulic) {
        if (secondaryLayer != null && hydraulic != null && this.hydraulicSet.contains(hydraulic) && this.leaves.contains(secondaryLayer)) {
            secondaryLayer.setHydraulic(hydraulic);
            this.notifyListener();
            return true;
        }
        return false;
    }

    public BioDegradationValue getBioDegredationValueForPollutantAndLayer(Pollutant pollutant, SecondaryLayer secondaryLayer) {
        return this.bioDegradationValues.getValue(pollutant, secondaryLayer);
    }

    private TableMap<Pollutant, SecondaryLayer, BioDegradationValue> getBioDegradationValues() {
        return this.bioDegradationValues;
    }

    public SorptionValue getSorptionValueForPollutantAndAquiferMaterial(Pollutant pollutant, AquiferMaterial aquiferMaterial) {
        return this.sorptionValues.getValue(pollutant, aquiferMaterial);
    }

    private TableMap<Pollutant, AquiferMaterial, SorptionValue> getSorptionValues() {
        return this.sorptionValues;
    }

    public SimulationMode getMode() {
        return this.mode;
    }

    public void setMode(SimulationMode simulationMode) {
        this.mode = simulationMode;
    }

    public BoundaryCondition getPollutantUpperBoundary() {
        return this.pollutantUpperBoundary;
    }

    public void setPollutantUpperBoundary(BoundaryCondition boundaryCondition) {
        this.pollutantUpperBoundary = boundaryCondition;
    }

    public BoundaryCondition getSurfactantUpperBoundary() {
        return this.surfactantUpperBoundary;
    }

    public void setSurfactantUpperBoundary(BoundaryCondition boundaryCondition) {
        this.surfactantUpperBoundary = boundaryCondition;
    }

    public InitialBoundaryCondition getPollutantInitialBoundary() {
        return this.pollutantInitialBoundary;
    }

    public void setPollutantInitialBoundary(InitialBoundaryCondition initialBoundaryCondition) {
        this.pollutantInitialBoundary = initialBoundaryCondition;
    }

    public InitialBoundaryCondition getSurfactantInitialBoundary() {
        return this.surfactantInitialBoundary;
    }

    public void setSurfactantInitialBoundary(InitialBoundaryCondition initialBoundaryCondition) {
        this.surfactantInitialBoundary = initialBoundaryCondition;
    }

    public ModelParameter getFurtherModelParameters() {
        return this.furtherModelParameters;
    }

    public void setFurtherModelParameters(ModelParameter modelParameter) {
        this.furtherModelParameters = modelParameter;
    }

    public static enum ConcentrationValue {
        DISS(0, "diss"),
        MIC(1, "mic"),
        SORB(2, "sorb"),
        MONO(3, "mono"),
        DIFF(4, "diff"),
        RED(5, "red");

        private final int index;
        private final String name;

        private ConcentrationValue(int n2, String string2) {
            this.index = n2;
            this.name = string2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SimulationMode {
        SMART,
        NORMAL;

    }
}

