/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.GrainSize;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class TotalFractionsMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<GrainSize, Double> grainSizeToTotalFraction = new HashMap<GrainSize, Double>();
    private double sum = 0.0;

    public void put(GrainSize grainSize) {
        if (this.grainSizeToTotalFraction.size() == 0) {
            this.put(grainSize, new Double(100.0));
        } else {
            this.put(grainSize, new Double(0.0));
        }
    }

    public void put(GrainSize grainSize, double d) {
        if (d >= 0.0 && d <= 100.0) {
            Double d2 = this.grainSizeToTotalFraction.put(grainSize, d);
            this.sum = d2 != null ? this.sum + d - d2 : (this.sum += d);
        }
    }

    public Double get(GrainSize grainSize) {
        return this.grainSizeToTotalFraction.get(grainSize);
    }

    public void remove(GrainSize grainSize) {
        Double d = this.grainSizeToTotalFraction.remove(grainSize);
        if (d != null) {
            this.sum -= d.doubleValue();
        }
    }

    public void clear() {
        this.grainSizeToTotalFraction.clear();
    }
}

