/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.Pair;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TableMap<K1, K2, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Set<K1> rowElements = new HashSet<K1>();
    protected final Set<K2> columnElements = new HashSet<K2>();
    protected final Map<Pair, V> table = new HashMap<Pair, V>();

    public void addRowElement(K1 K1) {
        TableMap.assertObjectNotNull(K1);
        boolean bl = this.rowElements.add(K1);
        if (bl && this.columnElements.size() > 0) {
            for (K2 K2 : this.columnElements) {
                this.table.put(new Pair(K1, K2), null);
            }
        }
    }

    public void addColumnElement(K2 K2) {
        TableMap.assertObjectNotNull(K2);
        boolean bl = this.columnElements.add(K2);
        if (bl && this.columnElements.size() > 0) {
            for (K1 K1 : this.rowElements) {
                this.table.put(new Pair(K1, K2), null);
            }
        }
    }

    public void removeRowElement(K1 K1) {
        TableMap.assertObjectNotNull(K1);
        boolean bl = this.rowElements.remove(K1);
        if (bl && this.columnElements.size() > 0) {
            for (K2 K2 : this.columnElements) {
                this.table.remove(new Pair(K1, K2));
            }
        }
    }

    public void removeColumnElement(K2 K2) {
        TableMap.assertObjectNotNull(K2);
        boolean bl = this.columnElements.remove(K2);
        if (bl && this.rowElements.size() > 0) {
            for (K1 K1 : this.rowElements) {
                this.table.remove(new Pair(K1, K2));
            }
        }
    }

    public V getValue(K1 K1, K2 K2) {
        TableMap.assertObjectNotNull(K1);
        TableMap.assertObjectNotNull(K2);
        if (this.rowElements.contains(K1) && this.columnElements.contains(K2)) {
            return this.table.get(new Pair(K1, K2));
        }
        return null;
    }

    public void putValue(K1 K1, K2 K2, V v) {
        TableMap.assertObjectNotNull(K1);
        TableMap.assertObjectNotNull(K2);
        if (this.rowElements.contains(K1) && this.columnElements.contains(K2)) {
            this.table.put(new Pair(K1, K2), v);
        }
    }

    public void clear() {
        this.rowElements.clear();
        this.columnElements.clear();
        this.table.clear();
    }

    static void assertObjectNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("parameter 'object' must not be null");
        }
    }
}

