/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import java.io.Serializable;

public class SorptionValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double equilibriumFraction = 0.0;
    private IsothermType isothermType;
    private double sorptionCoefficient;
    private double freundlichCoefficient;
    private double freundlichExponent;
    private double sorptionConstant;
    private double maxSorbedConcentration;
    private double saturationConcentration;

    public SorptionValue(IsothermType isothermType) {
        this.isothermType = isothermType;
    }

    public static SorptionValue defaultSorptionValue(IsothermType isothermType) {
        SorptionValue sorptionValue = new SorptionValue(isothermType);
        switch (isothermType) {
            case HENRY: {
                sorptionValue.sorptionCoefficient = 0.0;
                break;
            }
            case FREUNDLICH: {
                sorptionValue.freundlichCoefficient = 0.0;
                sorptionValue.freundlichExponent = 0.0;
                break;
            }
            case LANGMUIR: {
                sorptionValue.sorptionConstant = 0.0;
                sorptionValue.maxSorbedConcentration = 0.0;
                break;
            }
            case BET: {
                sorptionValue.sorptionConstant = 0.0;
                sorptionValue.maxSorbedConcentration = 0.0;
                sorptionValue.saturationConcentration = 0.0;
                break;
            }
            default: {
                sorptionValue.sorptionCoefficient = 0.0;
            }
        }
        return sorptionValue;
    }

    public void setParameter1(double d) {
        switch (this.isothermType) {
            case HENRY: {
                this.sorptionCoefficient = d;
                break;
            }
            case FREUNDLICH: {
                this.freundlichCoefficient = d;
                break;
            }
            case LANGMUIR: 
            case BET: {
                this.sorptionConstant = d;
            }
        }
    }

    public double getParameter1() {
        switch (this.isothermType) {
            case HENRY: {
                return this.sorptionCoefficient;
            }
            case FREUNDLICH: {
                return this.freundlichCoefficient;
            }
            case LANGMUIR: 
            case BET: {
                return this.sorptionConstant;
            }
        }
        return 0.0;
    }

    public void setParameter2(double d) {
        switch (this.isothermType) {
            case HENRY: {
                break;
            }
            case FREUNDLICH: {
                this.freundlichExponent = d;
                break;
            }
            case LANGMUIR: 
            case BET: {
                this.maxSorbedConcentration = d;
            }
        }
    }

    public double getParameter2() {
        switch (this.isothermType) {
            case FREUNDLICH: {
                return this.freundlichExponent;
            }
            case LANGMUIR: 
            case BET: {
                return this.maxSorbedConcentration;
            }
        }
        return 0.0;
    }

    public void setParameter3(double d) {
        switch (this.isothermType) {
            case BET: {
                this.saturationConcentration = d;
                break;
            }
        }
    }

    public double getParameter3() {
        switch (this.isothermType) {
            case BET: {
                return this.saturationConcentration;
            }
        }
        return 0.0;
    }

    public void setIsothermType(IsothermType isothermType) {
        if (isothermType != this.isothermType) {
            this.isothermType = isothermType;
            switch (this.isothermType) {
                case HENRY: {
                    this.freundlichCoefficient = 0.0;
                    this.freundlichExponent = 0.0;
                    this.sorptionConstant = 0.0;
                    this.maxSorbedConcentration = 0.0;
                    this.saturationConcentration = 0.0;
                    break;
                }
                case FREUNDLICH: {
                    this.sorptionCoefficient = 0.0;
                    this.sorptionConstant = 0.0;
                    this.maxSorbedConcentration = 0.0;
                    this.saturationConcentration = 0.0;
                    break;
                }
                case LANGMUIR: {
                    this.sorptionCoefficient = 0.0;
                    this.freundlichCoefficient = 0.0;
                    this.freundlichExponent = 0.0;
                    this.saturationConcentration = 0.0;
                    break;
                }
                case BET: {
                    this.sorptionCoefficient = 0.0;
                    this.freundlichCoefficient = 0.0;
                    this.freundlichExponent = 0.0;
                }
            }
        }
    }

    public IsothermType getIsothermType() {
        return this.isothermType;
    }

    public double getEquilibriumFraction() {
        return this.equilibriumFraction;
    }

    public void setEquilibriumFraction(double d) {
        this.equilibriumFraction = d;
    }

    public String toString() {
        return new String("SorptionValue with IsothermType: " + this.isothermType.toString() + "\n\tEquilibriumFraction: " + this.getEquilibriumFraction() + "\n\tParam1: " + this.getParameter1() + "\n\tParam2: " + this.getParameter2() + "\n\tParam3: " + this.getParameter3());
    }

    public static enum IsothermType {
        HENRY(0),
        FREUNDLICH(1),
        LANGMUIR(2),
        BET(3);

        private final int index;

        private IsothermType(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index + 1;
        }
    }
}

