/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.Pair;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.Pollutant;
import de.dsite.project.SorptionValue;
import de.dsite.project.TableMap;
import java.io.Serializable;

public class SorptionTableMap
extends TableMap<Pollutant, AquiferMaterial, SorptionValue>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public void addRowElement(Pollutant pollutant) {
        SorptionTableMap.assertObjectNotNull(pollutant);
        boolean bl = this.rowElements.add(pollutant);
        if (bl && this.columnElements.size() > 0) {
            for (AquiferMaterial aquiferMaterial : this.columnElements) {
                this.table.put(new Pair(pollutant, aquiferMaterial), SorptionValue.defaultSorptionValue(SorptionValue.IsothermType.HENRY));
            }
        }
    }

    @Override
    public void addColumnElement(AquiferMaterial aquiferMaterial) {
        SorptionTableMap.assertObjectNotNull(aquiferMaterial);
        boolean bl = this.columnElements.add(aquiferMaterial);
        if (bl && this.columnElements.size() > 0) {
            for (Pollutant pollutant : this.rowElements) {
                this.table.put(new Pair(pollutant, aquiferMaterial), SorptionValue.defaultSorptionValue(SorptionValue.IsothermType.HENRY));
            }
        }
    }
}

