/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.Layer;
import de.dsite.project.Hydraulic;
import de.dsite.project.Material;
import de.dsite.project.MaterialReadOnly;
import java.io.File;
import java.io.Serializable;

public class SecondaryLayer
extends Layer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Hydraulic hydraulic;
    private Material material;
    private int numModellzellen = 1;
    private double residenceAlpha = 0.01;
    private int residenceNumOfCells = 100;
    private String residenceFile;
    private boolean residenceCalculationFromFile = false;

    public SecondaryLayer(String string, double d, double d2) {
        super(string, d, d2);
        File file = new File("");
        this.residenceFile = file.getAbsolutePath();
    }

    public SecondaryLayer(String string, double d, double d2, int n) {
        this(string, d, d2);
        SecondaryLayer.assertNumOfCellsGreaterNull(n);
        this.setNumModellzellen(n);
    }

    SecondaryLayer(String string, double d, double d2, int n, Hydraulic hydraulic, Material material) {
        this(string, d, d2, n);
        SecondaryLayer.assertHydraulicNotNull(hydraulic);
        SecondaryLayer.assertMaterialNotNull(material);
        this.hydraulic = hydraulic;
        this.material = material;
    }

    public void setNumModellzellen(int n) {
        SecondaryLayer.assertNumOfCellsGreaterNull(n);
        this.numModellzellen = n;
    }

    public int getNumModellzellen() {
        return this.numModellzellen;
    }

    public Hydraulic getHydraulic() {
        return this.hydraulic;
    }

    public Material getMaterial() {
        return this.material;
    }

    void setMaterial(Material material) {
        this.material = material;
    }

    void setHydraulic(Hydraulic hydraulic) {
        this.hydraulic = hydraulic;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SecondaryLayer secondaryLayer = (SecondaryLayer)object;
        return this.getName().equals(secondaryLayer.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    private static void assertNumOfCellsGreaterNull(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("parameter 'numOfCells' must be > 0");
        }
    }

    private static void assertHydraulicNotNull(Hydraulic hydraulic) {
        if (hydraulic == null) {
            throw new IllegalArgumentException("parameter 'hydraulic' must not be null");
        }
    }

    private static void assertMaterialNotNull(MaterialReadOnly materialReadOnly) {
        if (materialReadOnly == null) {
            throw new IllegalArgumentException("parameter 'material' must not be null");
        }
    }

    public double getResidenceAlpha() {
        return this.residenceAlpha;
    }

    public void setResidenceAlpha(double d) {
        if (d <= 1.0 && d > 0.0) {
            this.residenceAlpha = d;
        }
    }

    public int getResidenceNumOfCells() {
        return this.residenceNumOfCells;
    }

    public void setResidenceNumOfCells(int n) {
        if (n >= 0) {
            this.residenceNumOfCells = n;
        }
    }

    public String getResidenceFile() {
        return this.residenceFile;
    }

    public void setResidenceFile(String string) {
        this.residenceFile = string;
    }

    public boolean isResidenceCalculationFromFile() {
        return this.residenceCalculationFromFile;
    }

    public void setResidenceCalculationFromFile(boolean bl) {
        this.residenceCalculationFromFile = bl;
    }
}

