/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import java.io.Serializable;

public class ModelParameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CalculationMode ipCalculationMode = CalculationMode.NUMERICAL;
    private double[] transportModel;
    private double[] concentrationEquilibrium;
    private double[] calculationProcessSteps;
    private double calculationIPDiffusion = 0.01;
    private double[] calculationIPAnalytical;
    private double[] calculationIPNumerical;
    private double[] calculationBioDegradation;
    private double[] furtherParameters;
    private int outputControlMode = 0;
    private int[] timestepRange = new int[]{0, 0};
    private FileFormat formatBTCAndProfileOutput = FileFormat.CSV;

    public double[] getTransportModel() {
        if (this.transportModel == null) {
            double[] dArray = new double[]{10000.0, 500.0, 2000.0, 500.0, 1.0E-12};
            this.transportModel = dArray;
        }
        return this.transportModel;
    }

    public void setTransportModel(double[] dArray) {
        this.transportModel = dArray;
    }

    public double[] getConcentrationEquilibrium() {
        if (this.concentrationEquilibrium == null) {
            double[] dArray = new double[]{5000.0, 1.0E-10};
            this.concentrationEquilibrium = dArray;
        }
        return this.concentrationEquilibrium;
    }

    public void setConcentrationEquilibrium(double[] dArray) {
        this.concentrationEquilibrium = dArray;
    }

    public double[] getCalculationProcessSteps() {
        if (this.calculationProcessSteps == null) {
            double[] dArray = new double[]{0.4, 30.0};
            this.calculationProcessSteps = dArray;
        }
        return this.calculationProcessSteps;
    }

    public void setCalculationProcessSteps(double[] dArray) {
        this.calculationProcessSteps = dArray;
    }

    public double getCalculationIPDiffusion() {
        return this.calculationIPDiffusion;
    }

    public void setCalculationIPDiffusion(double d) {
        this.calculationIPDiffusion = d;
    }

    public double[] getCalculationIPAnalytical() {
        if (this.calculationIPAnalytical == null) {
            double[] dArray = new double[]{2000.0, 100.0, 1.0E-10, 1.0E-20};
            this.calculationIPAnalytical = dArray;
        }
        return this.calculationIPAnalytical;
    }

    public void setCalculationIPAnalytical(double[] dArray) {
        this.calculationIPAnalytical = dArray;
    }

    public double[] getCalculationIPNumerical() {
        if (this.calculationIPNumerical == null) {
            double[] dArray = new double[]{20.0, 100.0, 1.0, 1000000.0, 2.0, 0.4, 1.0E-12, 1.0E-20, 1.0E-20, 5.0};
            this.calculationIPNumerical = dArray;
        }
        return this.calculationIPNumerical;
    }

    public void setCalculationIPNumerical(double[] dArray) {
        this.calculationIPNumerical = dArray;
    }

    public double[] getCalculationBioDegradation() {
        if (this.calculationBioDegradation == null) {
            double[] dArray = new double[]{400.0, 1.0E-20};
            this.calculationBioDegradation = dArray;
        }
        return this.calculationBioDegradation;
    }

    public void setCalculationBioDegradation(double[] dArray) {
        this.calculationBioDegradation = dArray;
    }

    public double[] getFurtherParameters() {
        if (this.furtherParameters == null) {
            double[] dArray = new double[]{1.0E-10, 2.0, 0.995};
            this.furtherParameters = dArray;
        }
        return this.furtherParameters;
    }

    public void setFurtherParameters(double[] dArray) {
        this.furtherParameters = dArray;
    }

    public CalculationMode getIpCalculationMode() {
        return this.ipCalculationMode;
    }

    public void setIpCalculationMode(CalculationMode calculationMode) {
        this.ipCalculationMode = calculationMode;
    }

    public int getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(int n) {
        if (n < 0 || n >= 64) {
            throw new IllegalArgumentException("parameter 'outputControlMode' must be >= 0 and < 64");
        }
        this.outputControlMode = n;
    }

    public int[] getTimestepRange() {
        return this.timestepRange;
    }

    public void setTimestepRange(int[] nArray) {
        if (nArray.length != 2 || nArray[0] < 0 || nArray[1] < nArray[0]) {
            throw new IllegalArgumentException("parameter 'timestepRange' must be of type int[x1, x2], x1 < x2, x1 > 0'");
        }
        this.timestepRange = nArray;
    }

    public FileFormat getFormatBTCAndProfileOutput() {
        return this.formatBTCAndProfileOutput;
    }

    public void setFormatBTCAndProfileOutput(FileFormat fileFormat) {
        this.formatBTCAndProfileOutput = fileFormat;
    }

    public static enum FileFormat {
        CSV(0, "CSV"),
        TECPLOT(1, "TECPLOT"),
        ASCII(2, "ASCII"),
        MATLAB(3, "MATLAB");

        private final int index;
        private final String name;

        private FileFormat(int n2, String string2) {
            this.index = n2;
            this.name = string2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum CalculationMode {
        ANALYTICAL,
        NUMERICAL;

    }
}

