/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.GrainSize;
import de.dsite.data.Pair;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.project.MaterialReadOnly;
import de.dsite.project.TotalFractionsMap;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Material
implements Serializable,
Comparable<Material>,
MaterialReadOnly {
    private static final long serialVersionUID = 1L;
    private String name;
    private int index;
    private Color color;
    private static Color baseColor = new Color(175, 35, 5);
    private final Set<AquiferMaterial> aquiferMaterials = new HashSet<AquiferMaterial>();
    private final Set<GrainSize> grainSizes = new HashSet<GrainSize>();
    private final Map<Pair, Double> massFractionValues = new HashMap<Pair, Double>();
    private final TotalFractionsMap totalFractions = new TotalFractionsMap();

    public Material(String string, int n) {
        this.index = n;
        this.name = string;
        this.color = Material.lightUp(baseColor, n - 1);
    }

    public static Material defaultMaterialWithNameIndex(int n) {
        Material.assertIndexGreaterOrEqualZero(n);
        String string = n >= 9 ? "Mat " + (n + 1) : "Mat 0" + (n + 1);
        return new Material(string, n);
    }

    void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setIndex(int n) {
        Material.assertIndexGreaterZero(n);
        this.color = this.index > n ? Material.lightUp(this.color, this.index - n) : Material.lightDown(this.color, this.index - n);
        this.index = n;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public ArrayList<AquiferMaterial> getAquiferMaterials() {
        ArrayList<AquiferMaterial> arrayList = new ArrayList<AquiferMaterial>();
        if (this.aquiferMaterials.size() > 0) {
            arrayList.addAll(this.aquiferMaterials);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    @Override
    public ArrayList<GrainSize> getGrainSizes() {
        ArrayList<GrainSize> arrayList = new ArrayList<GrainSize>();
        if (this.grainSizes.size() > 0) {
            arrayList.addAll(this.grainSizes);
            Collections.sort(arrayList);
        }
        return arrayList;
    }

    public boolean addAquiferMaterial(AquiferMaterial aquiferMaterial) {
        Material.assertAquiferMaterialNotNull(aquiferMaterial);
        boolean bl = this.aquiferMaterials.add(aquiferMaterial);
        if (bl && this.grainSizes.size() > 0) {
            for (GrainSize grainSize : this.grainSizes) {
                this.massFractionValues.put(new Pair(aquiferMaterial, grainSize), new Double(0.0));
            }
        }
        return bl;
    }

    public void deleteAquiferMaterial(AquiferMaterial aquiferMaterial) {
        Material.assertAquiferMaterialNotNull(aquiferMaterial);
        boolean bl = this.aquiferMaterials.remove(aquiferMaterial);
        if (bl && this.grainSizes.size() > 0) {
            for (GrainSize grainSize : this.grainSizes) {
                this.massFractionValues.remove(new Pair(aquiferMaterial, grainSize));
            }
        }
    }

    public boolean addGrainSize(GrainSize grainSize) {
        Material.assertGrainSizeNotNull(grainSize);
        boolean bl = this.grainSizes.add(grainSize);
        if (bl) {
            this.totalFractions.put(grainSize);
        }
        if (bl && this.aquiferMaterials.size() > 0) {
            for (AquiferMaterial aquiferMaterial : this.aquiferMaterials) {
                this.massFractionValues.put(new Pair(aquiferMaterial, grainSize), new Double(0.0));
            }
        }
        return bl;
    }

    public void deleteGrainSize(GrainSize grainSize) {
        Material.assertGrainSizeNotNull(grainSize);
        boolean bl = this.grainSizes.remove(grainSize);
        if (bl) {
            this.totalFractions.remove(grainSize);
        }
        if (bl && this.aquiferMaterials.size() > 0) {
            for (AquiferMaterial aquiferMaterial : this.aquiferMaterials) {
                this.massFractionValues.remove(new Pair(aquiferMaterial, grainSize));
            }
        }
    }

    public void deleteAllGrainSizes() {
        for (GrainSize grainSize : this.getGrainSizes()) {
            this.totalFractions.remove(grainSize);
            if (this.aquiferMaterials.size() <= 0) continue;
            for (AquiferMaterial aquiferMaterial : this.aquiferMaterials) {
                this.massFractionValues.remove(new Pair(aquiferMaterial, grainSize));
            }
        }
        this.grainSizes.clear();
    }

    public boolean renameGrainSize(GrainSize grainSize, String string) {
        Material.assertStringNotNullAndStringNotEmpty(string);
        Material.assertGrainSizeNotNull(grainSize);
        ArrayList<GrainSize> arrayList = new ArrayList<GrainSize>();
        if (this.grainSizes.size() > 0) {
            arrayList.addAll(this.grainSizes);
        }
        for (GrainSize grainSize2 : arrayList) {
            if (!grainSize2.equals(grainSize)) continue;
            this.updateGrainSizeWithName(grainSize2, string);
            return true;
        }
        return false;
    }

    private void updateGrainSizeWithName(GrainSize grainSize, String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (AquiferMaterial aquiferMaterial : this.getAquiferMaterials()) {
            arrayList.add(this.getMassFractionValue(aquiferMaterial, grainSize));
        }
        Double d = this.getTotalFractionForGrainSize(grainSize);
        this.deleteGrainSize(grainSize);
        grainSize.setName(string);
        this.addGrainSize(grainSize);
        this.setTotalFractionForGrainSize(grainSize, d);
        int n = 0;
        for (AquiferMaterial aquiferMaterial : this.getAquiferMaterials()) {
            this.setMassFractionValue(aquiferMaterial, grainSize, (Double)arrayList.get(n));
            ++n;
        }
    }

    public void setTotalFractionForGrainSize(GrainSize grainSize, Double d) {
        if (this.grainSizes.contains(grainSize)) {
            this.totalFractions.put(grainSize, d);
        }
    }

    @Override
    public Double getTotalFractionForGrainSize(GrainSize grainSize) {
        if (!this.grainSizes.contains(grainSize)) {
            return null;
        }
        return this.totalFractions.get(grainSize);
    }

    @Override
    public Double getMassFractionValue(AquiferMaterial aquiferMaterial, GrainSize grainSize) {
        Material.assertAquiferMaterialNotNull(aquiferMaterial);
        Material.assertGrainSizeNotNull(grainSize);
        return this.massFractionValues.get(new Pair(aquiferMaterial, grainSize));
    }

    public void setMassFractionValue(AquiferMaterial aquiferMaterial, GrainSize grainSize, Double d) {
        Material.assertAquiferMaterialNotNull(aquiferMaterial);
        Material.assertGrainSizeNotNull(grainSize);
        Material.assertValueNonNegative(d);
        this.massFractionValues.put(new Pair(aquiferMaterial, grainSize), d);
    }

    public String toString() {
        String string = this.name;
        return string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Material material = (Material)object;
        return this.compareTo(material) == 0;
    }

    @Override
    public int compareTo(Material material) {
        return this.name.compareToIgnoreCase(material.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static Color lightUp(Color color, int n) {
        if (n == 0) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] + (float)n * 0.015f;
        fArray[2] = fArray[2] + (float)n * 0.02f;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    private static Color lightDown(Color color, int n) {
        if (n == 0) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] - (float)n * 0.015f;
        fArray[2] = fArray[2] - (float)n * 0.02f;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    private static void assertIndexGreaterOrEqualZero(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("parameter 'id' must be >= 0");
        }
    }

    private static void assertIndexGreaterZero(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("parameter 'index' = " + n + " must be > 0 ");
        }
    }

    private static void assertAquiferMaterialNotNull(AquiferMaterial aquiferMaterial) {
        if (aquiferMaterial == null) {
            throw new IllegalArgumentException("parameter 'comp' must not be null");
        }
    }

    private static void assertGrainSizeNotNull(GrainSize grainSize) {
        if (grainSize == null) {
            throw new IllegalArgumentException("parameter 'grainSize' must not be null");
        }
    }

    private static void assertStringNotNullAndStringNotEmpty(String string) {
        if (string == null || string == "") {
            throw new IllegalArgumentException("parameter 'string' must not be null");
        }
    }

    private static void assertValueNonNegative(Double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("parameter 'value' must be >= 0");
        }
    }
}

