/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.utils.ColorUtils;
import java.awt.Color;
import java.io.Serializable;

public class Hydraulic
implements Serializable,
Comparable<Hydraulic> {
    private static final long serialVersionUID = 1L;
    private String name;
    private double[] values;
    private Color color;
    private int index;

    public Hydraulic(double[] dArray, Color color, int n) {
        Hydraulic.assertIndexGreaterZero(n);
        this.name = new String("Hyd " + (n + 1));
        this.setValues(dArray);
        this.setColor(color);
        this.index = n;
    }

    public static Hydraulic defaultHydraulicWithIndex(int n) {
        Color color = ColorUtils.lightUp(ColorUtils.hydraulicBaseColor(), n);
        return new Hydraulic(new double[]{1.0E-4, 0.25, 0.25, 1.0}, color, n);
    }

    public boolean isNameIndexCompliant(int n) {
        int n2;
        try {
            n2 = Integer.parseInt(this.name.substring(4)) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("No valid name for Hydraulic " + this);
            return false;
        }
        return n2 == n;
    }

    public void setIndex(int n) {
        Hydraulic.assertIndexGreaterZero(n);
        this.index = n;
        this.name = new String("Hyd " + (n + 1));
        this.color = ColorUtils.lightUp(ColorUtils.hydraulicBaseColor(), n);
    }

    public String getName() {
        return this.name;
    }

    public void setValues(double[] dArray) {
        this.values = dArray;
    }

    public double[] getValues() {
        return this.values;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Hydraulic hydraulic = (Hydraulic)object;
        return this.compareTo(hydraulic) == 0;
    }

    @Override
    public int compareTo(Hydraulic hydraulic) {
        return this.index - hydraulic.index;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static void assertIndexGreaterZero(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("parameter 'id' must be >= 0");
        }
    }
}

