/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.catalog.CatalogObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BoundaryCondition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CalculationMode mode;
    private ArrayList<CatalogObject> catalogObjects = new ArrayList();
    private ArrayList<Double[]> catalogObjectValues = new ArrayList();
    private Double[] dateValues;

    public BoundaryCondition() {
        this.mode = CalculationMode.INTERPOLATION;
        this.dateValues = new Double[0];
    }

    public CalculationMode getMode() {
        return this.mode;
    }

    public void setMode(CalculationMode calculationMode) {
        this.mode = calculationMode;
    }

    public int getIntervalCount() {
        return this.dateValues == null ? 0 : this.dateValues.length;
    }

    public int getObjectCount() {
        return this.catalogObjects.size();
    }

    boolean addCatalogObject(CatalogObject catalogObject) {
        int n;
        if (catalogObject == null) {
            return false;
        }
        if (this.catalogObjects.contains(catalogObject)) {
            return false;
        }
        if (this.catalogObjects.size() > 0) {
            for (n = 0; n < this.catalogObjects.size() && this.catalogObjects.get(n).compareTo(catalogObject) < 0; ++n) {
            }
        }
        this.catalogObjects.add(n, catalogObject);
        this.catalogObjectValues.add(n, this.initialValues());
        return true;
    }

    boolean deleteCatalogObject(CatalogObject catalogObject) {
        if (catalogObject == null) {
            return false;
        }
        if (!this.catalogObjects.contains(catalogObject)) {
            return false;
        }
        int n = this.catalogObjects.indexOf(catalogObject);
        this.catalogObjects.remove(n);
        this.catalogObjectValues.remove(n);
        return true;
    }

    boolean addInterval(int n) {
        if (n < 0 || n > this.dateValues.length) {
            return false;
        }
        for (int i = 0; i < this.catalogObjectValues.size(); ++i) {
            Double[] doubleArray = new Double[this.dateValues.length + 1];
            Double[] doubleArray2 = this.catalogObjectValues.get(i);
            for (int j = 0; j < this.dateValues.length + 1; ++j) {
                doubleArray[j] = j < n ? doubleArray2[j] : (j == n ? Double.valueOf(0.0) : doubleArray2[j - 1]);
            }
            this.catalogObjectValues.set(i, doubleArray);
        }
        Double[] doubleArray = new Double[this.dateValues.length + 1];
        for (int i = 0; i < this.dateValues.length + 1; ++i) {
            doubleArray[i] = i < n ? this.dateValues[i] : (i == n ? Double.valueOf(0.0) : this.dateValues[i - 1]);
        }
        this.dateValues = doubleArray;
        return true;
    }

    public boolean removeInterval(int n) {
        if (n < 0 || n >= this.dateValues.length) {
            return false;
        }
        int n2 = 0;
        for (Double[] doubleArray : this.catalogObjectValues) {
            Double[] doubleArray2 = new Double[this.dateValues.length - 1];
            for (int i = 0; i < this.dateValues.length - 1; ++i) {
                doubleArray2[i] = i < n ? doubleArray[i] : doubleArray[i + 1];
            }
            this.catalogObjectValues.set(n2, doubleArray2);
            ++n2;
        }
        Double[] doubleArray = new Double[this.dateValues.length - 1];
        for (int i = 0; i < this.dateValues.length - 1; ++i) {
            doubleArray[i] = i < n ? this.dateValues[i] : this.dateValues[i + 1];
        }
        this.dateValues = doubleArray;
        return true;
    }

    public void appendInterval() {
        this.addInterval(this.dateValues.length);
    }

    public void removeLastInterval() {
        if (this.dateValues.length > 0) {
            this.removeInterval(this.dateValues.length - 1);
        }
    }

    public void setValueForIntervalAndCatalogObject(double d, int n, CatalogObject catalogObject) {
        if (this.catalogObjects.contains(catalogObject) && n >= 0 && n < this.dateValues.length) {
            this.catalogObjectValues.get((int)this.catalogObjects.indexOf((Object)catalogObject))[n] = d;
        }
    }

    public double getValueForIntervalAndCatalogObject(int n, CatalogObject catalogObject) {
        if (this.catalogObjects.contains(catalogObject) && n >= 0 && n < this.dateValues.length) {
            return this.catalogObjectValues.get(this.catalogObjects.indexOf(catalogObject))[n];
        }
        return 0.0;
    }

    double[] getAllValuesForCatalogObject(CatalogObject catalogObject) {
        if (this.catalogObjects.contains(catalogObject)) {
            return null;
        }
        Double[] doubleArray = this.catalogObjectValues.get(this.catalogObjects.indexOf(catalogObject));
        double[] dArray = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            dArray[i] = doubleArray[i];
        }
        return dArray;
    }

    public double[] getAllValuesForIndex(int n) {
        if (n < 0 || n >= this.dateValues.length) {
            return null;
        }
        double[] dArray = new double[this.catalogObjects.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getValueForIntervalAndCatalogObject(n, this.catalogObjects.get(i));
        }
        return dArray;
    }

    public double[] getAllDateValues() {
        double[] dArray = new double[this.dateValues.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.dateValues[i];
        }
        return dArray;
    }

    public boolean setValuesFromArray(ArrayList<double[]> arrayList) {
        this.assertDimensionsValid(arrayList);
        while (this.getIntervalCount() > 0) {
            this.removeLastInterval();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.appendInterval();
            this.setDateValueForInterval(arrayList.get(i)[0], i);
            for (int j = 0; j < arrayList.get(i).length - 1; ++j) {
                this.setValueForIntervalAndCatalogObject(arrayList.get(i)[j + 1], i, this.catalogObjects.get(j));
            }
        }
        return true;
    }

    public void setDateValueForInterval(double d, int n) {
        if (n >= 0 && n < this.dateValues.length && d >= 0.0) {
            this.dateValues[n] = d;
        }
    }

    public double getDateValueForInterval(int n) {
        if (n >= 0 && n < this.dateValues.length) {
            return this.dateValues[n];
        }
        return 0.0;
    }

    public double[] getAllValuesForTimestamp(double d) {
        int n;
        if (this.getIntervalCount() == 1) {
            return this.getAllValuesForIndex(0);
        }
        for (n = 0; n < this.dateValues.length - 1 && d > this.dateValues[n]; ++n) {
        }
        if (d < this.getAllDateValues()[n]) {
            switch (this.mode) {
                case NEXT_VALUE: {
                    return this.getAllValuesForIndex(n);
                }
                case EARLIER_VALUE: {
                    return n == 0 ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n - 1);
                }
                case INTERPOLATION: {
                    double[] dArray = new double[this.catalogObjects.size()];
                    int n2 = 0;
                    if (n > 0) {
                        for (CatalogObject catalogObject : this.catalogObjects) {
                            double d2 = this.dateValues[n] - this.dateValues[n - 1];
                            double d3 = this.getValueForIntervalAndCatalogObject(n, catalogObject) - this.getValueForIntervalAndCatalogObject(n - 1, catalogObject);
                            double d4 = d2 != 0.0 ? d3 / d2 : 0.0;
                            dArray[n2] = this.getValueForIntervalAndCatalogObject(n - 1, catalogObject) + (d - this.dateValues[n - 1]) * d4;
                            ++n2;
                        }
                        return dArray;
                    }
                    for (CatalogObject catalogObject : this.catalogObjects) {
                        dArray[n2] = this.getValueForIntervalAndCatalogObject(n, catalogObject) * d / this.dateValues[n];
                        ++n2;
                    }
                    return dArray;
                }
            }
            return new double[this.catalogObjects.size()];
        }
        if (d == this.getAllDateValues()[n]) {
            return this.getAllValuesForIndex(n);
        }
        return this.getMode() == CalculationMode.NEXT_VALUE ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n);
    }

    public double[] getAllValuesForTimestampDistanceToLastTimestamp(double d, double d2) {
        int n;
        if (this.getIntervalCount() == 1) {
            return this.getAllValuesForIndex(0);
        }
        for (n = 0; n < this.dateValues.length - 1 && d > this.dateValues[n]; ++n) {
        }
        if (d < this.getAllDateValues()[n]) {
            switch (this.mode) {
                case NEXT_VALUE: {
                    return this.getAllValuesForIndex(n);
                }
                case EARLIER_VALUE: {
                    return n == 0 ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n - 1);
                }
                case INTERPOLATION: {
                    double[] dArray = new double[this.catalogObjects.size()];
                    int n2 = 0;
                    if (n > 0) {
                        for (CatalogObject catalogObject : this.catalogObjects) {
                            double d3 = this.dateValues[n] - this.dateValues[n - 1];
                            double d4 = this.getValueForIntervalAndCatalogObject(n, catalogObject) - this.getValueForIntervalAndCatalogObject(n - 1, catalogObject);
                            double d5 = d3 != 0.0 ? d4 / d3 : 0.0;
                            dArray[n2] = this.getValueForIntervalAndCatalogObject(n - 1, catalogObject) + (d - d2 / 2.0 - this.dateValues[n - 1]) * d5;
                            ++n2;
                        }
                        return dArray;
                    }
                    for (CatalogObject catalogObject : this.catalogObjects) {
                        double d6 = this.dateValues[n];
                        double d7 = this.getValueForIntervalAndCatalogObject(n, catalogObject);
                        double d8 = d6 != 0.0 ? d7 / d6 : 0.0;
                        dArray[n2] = (d - d2 / 2.0) * d8;
                        ++n2;
                    }
                    return dArray;
                }
            }
            return new double[this.catalogObjects.size()];
        }
        if (d == this.getAllDateValues()[n]) {
            return this.getAllValuesForIndex(n);
        }
        return this.getMode() == CalculationMode.NEXT_VALUE ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n);
    }

    public double[] getAllValuesForTimestamp2c(double d) {
        int n;
        if (this.getIntervalCount() == 1) {
            return this.getAllValuesForIndex(0);
        }
        for (n = 0; n < this.dateValues.length - 1 && d > this.dateValues[n]; ++n) {
        }
        if (d < this.getAllDateValues()[n]) {
            switch (this.mode) {
                case NEXT_VALUE: {
                    return this.getAllValuesForIndex(n);
                }
                case EARLIER_VALUE: {
                    return n == 0 ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n - 1);
                }
                case INTERPOLATION: {
                    double[] dArray = new double[this.catalogObjects.size()];
                    int n2 = 0;
                    if (n > 0) {
                        for (CatalogObject catalogObject : this.catalogObjects) {
                            double d2 = this.dateValues[n] - this.dateValues[n - 1];
                            double d3 = this.getValueForIntervalAndCatalogObject(n, catalogObject) - this.getValueForIntervalAndCatalogObject(n - 1, catalogObject);
                            double d4 = d2 != 0.0 ? d3 / d2 : 0.0;
                            dArray[n2] = this.getValueForIntervalAndCatalogObject(n - 1, catalogObject) + (d - this.dateValues[n - 1]) * d4;
                            ++n2;
                        }
                        return dArray;
                    }
                    for (CatalogObject catalogObject : this.catalogObjects) {
                        double d5 = this.dateValues[n];
                        double d6 = this.getValueForIntervalAndCatalogObject(n, catalogObject);
                        double d7 = d5 != 0.0 ? d6 / d5 : 0.0;
                        dArray[n2] = d * d7;
                        ++n2;
                    }
                    return dArray;
                }
            }
            return new double[this.catalogObjects.size()];
        }
        if (d == this.getAllDateValues()[n]) {
            return this.getAllValuesForIndex(n);
        }
        return this.getMode() == CalculationMode.NEXT_VALUE ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(n);
    }

    public double[] getAllValuesForTimestamp2(double d) {
        int n;
        int n2;
        Object object;
        int[] nArray = new int[this.dateValues.length];
        if (this.dateValues.length > 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.dateValues.length);
            for (int i = 0; i < this.dateValues.length; ++i) {
                arrayList.add(i);
            }
            object = new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return Double.compare(BoundaryCondition.this.dateValues[n], BoundaryCondition.this.dateValues[n2]);
                }
            };
            Collections.sort(arrayList, object);
            for (n2 = 0; n2 < this.dateValues.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
        } else {
            nArray[0] = 0;
        }
        for (n = 0; n < this.dateValues.length - 1 && d > this.dateValues[nArray[n]]; ++n) {
        }
        if (d < this.getAllDateValues()[nArray[n]]) {
            switch (this.mode) {
                case NEXT_VALUE: {
                    return this.getAllValuesForIndex(nArray[n]);
                }
                case EARLIER_VALUE: {
                    return nArray[n] == 0 ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(nArray[n - 1]);
                }
                case INTERPOLATION: {
                    object = new double[this.catalogObjects.size()];
                    n2 = 0;
                    if (n > 0) {
                        for (CatalogObject catalogObject : this.catalogObjects) {
                            double d2 = this.dateValues[nArray[n]] - this.dateValues[nArray[n - 1]];
                            double d3 = this.getValueForIntervalAndCatalogObject(nArray[n], catalogObject) - this.getValueForIntervalAndCatalogObject(nArray[n - 1], catalogObject);
                            double d4 = d2 != 0.0 ? d3 / d2 : 0.0;
                            object[n2] = this.getValueForIntervalAndCatalogObject(nArray[n - 1], catalogObject) + (d - this.dateValues[nArray[n - 1]]) * d4;
                            ++n2;
                        }
                        return object;
                    }
                    for (CatalogObject catalogObject : this.catalogObjects) {
                        double d5 = this.dateValues[nArray[n]];
                        double d6 = this.getValueForIntervalAndCatalogObject(nArray[n], catalogObject);
                        double d7 = d5 != 0.0 ? d6 / d5 : 0.0;
                        object[n2] = d * d7;
                        ++n2;
                    }
                    return object;
                }
            }
            return new double[this.catalogObjects.size()];
        }
        if (d == this.getAllDateValues()[nArray[n]]) {
            return this.getAllValuesForIndex(nArray[n]);
        }
        return this.getMode() == CalculationMode.NEXT_VALUE ? new double[this.catalogObjects.size()] : this.getAllValuesForIndex(nArray[n]);
    }

    public void setMaximumValue(double d) {
    }

    public void sortDateValues() {
        int n;
        Double[] doubleArray;
        if (this.dateValues.length == 0) {
            return;
        }
        int[] nArray = new int[this.dateValues.length];
        if (this.dateValues.length > 1) {
            doubleArray = new ArrayList(this.dateValues.length);
            for (int i = 0; i < this.dateValues.length; ++i) {
                doubleArray.add(i);
            }
            Comparator<Integer> comparator = new Comparator<Integer>(){

                @Override
                public int compare(Integer n, Integer n2) {
                    return Double.compare(BoundaryCondition.this.dateValues[n], BoundaryCondition.this.dateValues[n2]);
                }
            };
            Collections.sort(doubleArray, comparator);
            for (int i = 0; i < this.dateValues.length; ++i) {
                nArray[i] = (Integer)doubleArray.get(i);
            }
        } else {
            nArray[0] = 0;
        }
        doubleArray = new Double[this.dateValues.length];
        for (n = 0; n < this.dateValues.length; ++n) {
            doubleArray[n] = this.dateValues[nArray[n]];
        }
        this.dateValues = doubleArray;
        n = 0;
        for (Double[] doubleArray2 : this.catalogObjectValues) {
            Double[] doubleArray3 = new Double[this.dateValues.length];
            for (int i = 0; i < this.dateValues.length; ++i) {
                doubleArray3[i] = doubleArray2[nArray[i]];
            }
            this.catalogObjectValues.set(n, doubleArray3);
            ++n;
        }
    }

    private Double[] initialValues() {
        Double[] doubleArray = new Double[this.dateValues.length];
        for (int i = 0; i < this.dateValues.length; ++i) {
            doubleArray[i] = 0.0;
        }
        return doubleArray;
    }

    private void assertDimensionsValid(ArrayList<double[]> arrayList) {
        if (arrayList.get(0).length - 1 != this.catalogObjects.size()) {
            throw new IllegalArgumentException("Dimension from input-array doesn't match Instance-Parameter:\n Number of value-arrays = " + (arrayList.get(0).length - 1) + ", number of pollutants/surfactants = " + this.catalogObjects.size());
        }
    }

    public static enum CalculationMode {
        INTERPOLATION,
        NEXT_VALUE,
        EARLIER_VALUE;

    }
}

