/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import java.io.Serializable;

public class BioDegradationValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DegradationMode mode = DegradationMode.NO_DEGRADATION;
    private double halfLifeTime = 86400.0;
    private int order = 1;
    private double referenceConcentration = 1.0;

    public BioDegradationValue(DegradationMode degradationMode) {
        this.setMode(degradationMode);
    }

    public BioDegradationValue(DegradationMode degradationMode, double d, int n, double d2) {
        BioDegradationValue.assertValueNonNegative(d);
        BioDegradationValue.assertValueNonNegative(n);
        BioDegradationValue.assertValueNonNegative(d2);
        this.setMode(degradationMode);
        this.setHalfLifeTime(d);
        this.setOrder(n);
        this.setReferenceConcentration(d2);
    }

    public static BioDegradationValue defaultBioDegradationValue() {
        return new BioDegradationValue(DegradationMode.NO_DEGRADATION, 86400.0, 1, 1.0);
    }

    private static void assertValueNonNegative(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Parameter  must not be non-negative");
        }
    }

    private static void assertValueNonNegative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Parameter  must not be non-negative");
        }
    }

    public DegradationMode getMode() {
        return this.mode;
    }

    public void setMode(DegradationMode degradationMode) {
        this.mode = degradationMode;
    }

    public double getHalfLifeTime() {
        return this.halfLifeTime;
    }

    public void setHalfLifeTime(double d) {
        BioDegradationValue.assertValueNonNegative(d);
        this.halfLifeTime = d;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        BioDegradationValue.assertValueNonNegative(n);
        this.order = n;
    }

    public double getReferenceConcentration() {
        return this.referenceConcentration;
    }

    public void setReferenceConcentration(double d) {
        BioDegradationValue.assertValueNonNegative(d);
        this.referenceConcentration = d;
    }

    public static enum DegradationMode {
        NO_DEGRADATION(0),
        DEGRADATION_OF_NTH_ORDER(1),
        LH_KINETICS(2);

        private final int index;

        private DegradationMode(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

