/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.project;

import de.dsite.data.Pair;
import de.dsite.data.catalog.Pollutant;
import de.dsite.project.BioDegradationValue;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.TableMap;
import java.io.Serializable;

public class BioDegradationTableMap
extends TableMap<Pollutant, SecondaryLayer, BioDegradationValue>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public void addRowElement(Pollutant pollutant) {
        BioDegradationTableMap.assertObjectNotNull(pollutant);
        boolean bl = this.rowElements.add(pollutant);
        if (bl && this.columnElements.size() > 0) {
            for (SecondaryLayer secondaryLayer : this.columnElements) {
                this.table.put(new Pair(pollutant, secondaryLayer), BioDegradationValue.defaultBioDegradationValue());
            }
        }
    }

    @Override
    public void addColumnElement(SecondaryLayer secondaryLayer) {
        BioDegradationTableMap.assertObjectNotNull(secondaryLayer);
        boolean bl = this.columnElements.add(secondaryLayer);
        if (bl && this.columnElements.size() > 0) {
            for (Pollutant pollutant : this.rowElements) {
                this.table.put(new Pair(pollutant, secondaryLayer), BioDegradationValue.defaultBioDegradationValue());
            }
        }
    }
}

