/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.main;

import de.dsite.controller.CatalogController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.Series;
import de.dsite.gui.MainWindow;
import de.dsite.gui.ResultPlotBuilder;
import de.dsite.gui.listcard.BoundaryConditionTransportCard;
import de.dsite.gui.listcard.ModelSettingsCard;
import de.dsite.utils.ResourceBundleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class ResourceManager {
    private static final String BUNDLE_PATH = "PDFEditor";
    private final Map<Locale, ResourceBundle> availableResourceBundles = new HashMap<Locale, ResourceBundle>();
    private ResourceBundle currentResourceBundle = null;
    private Locale currentLocale = null;

    private ResourceManager() {
    }

    public static ResourceManager createInstance() {
        ResourceManager resourceManager = new ResourceManager();
        resourceManager.init();
        resourceManager.activateLocale(Locale.GERMANY);
        return resourceManager;
    }

    private void init() {
        this.loadAndAddResourceBundle(Locale.GERMANY);
        this.loadAndAddResourceBundle(Locale.US);
    }

    private void loadAndAddResourceBundle(Locale locale) {
        try {
            ResourceBundle resourceBundle = PropertyResourceBundle.getBundle(BUNDLE_PATH, locale);
            this.addResourceBundle(locale, resourceBundle);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private void addResourceBundle(Locale locale, ResourceBundle resourceBundle) {
        this.availableResourceBundles.put(locale, resourceBundle);
    }

    public String getLangString(ResourceBundleUtils.ResourceKeys resourceKeys) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, resourceKeys);
    }

    public String getLangString(MainWindowController.InputCardValue inputCardValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, inputCardValue);
    }

    public String getLangString(MainWindowController.OutputCardValue outputCardValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, outputCardValue);
    }

    public String getLangString(CatalogController.CatalogValue catalogValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, catalogValue);
    }

    public String getLangString(ModelSettingsCard.CardValue cardValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, cardValue);
    }

    public String getLangString(BoundaryConditionTransportCard.TransportValue transportValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, transportValue);
    }

    public String getLangString(MainWindow.TabValue tabValue) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, tabValue);
    }

    public String getLangString(Series.Unit unit) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, unit);
    }

    public String getLangString(ResultPlotBuilder.AxisRelation axisRelation) {
        return ResourceBundleUtils.getLangString(this.currentResourceBundle, axisRelation);
    }

    public boolean activateLocale(Locale locale) {
        if (this.supportsLocale(locale)) {
            this.currentResourceBundle = this.availableResourceBundles.get(locale);
            this.currentLocale = locale;
            return true;
        }
        return false;
    }

    public boolean supportsLocale(Locale locale) {
        return this.availableResourceBundles.containsKey(locale);
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public List<Locale> getAvailableLocales() {
        return new ArrayList<Locale>(this.availableResourceBundles.keySet());
    }
}

