/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.controller.MaterialController;
import de.dsite.data.GrainSize;
import de.dsite.data.Layer;
import de.dsite.data.Timesteps;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.Pollutant;
import de.dsite.project.BioDegradationValue;
import de.dsite.project.BoundaryCondition;
import de.dsite.project.Hydraulic;
import de.dsite.project.InitialBoundaryCondition;
import de.dsite.project.Material;
import de.dsite.project.ModelParameter;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.SorptionValue;
import de.dsite.project.VersionedProject;
import de.dsite.utils.FileUtils;
import de.dsite.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final String XSD_FILE = "winSmart2.xsd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionedProject parseXMLFile(File file) {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("XMLParser: ParserConfigurationException was thrown!");
            parserConfigurationException.printStackTrace();
            return null;
        }
        catch (SAXException sAXException) {
            System.err.println("XMLParser: SAXException was thrown!");
            sAXException.printStackTrace();
            return null;
        }
        SAXHandler sAXHandler = new SAXHandler();
        if (!FileUtils.fileExists(file)) {
            System.err.println("XMLParser: File " + file.getAbsolutePath() + " does not exist! No Project was imported!");
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            sAXParser.parse((InputStream)fileInputStream, (DefaultHandler)sAXHandler);
        }
        catch (Exception exception) {
            System.err.println("XMLParser: Loading Project from XML File '" + file.getAbsolutePath() + "' was not possible!");
            exception.printStackTrace();
            VersionedProject versionedProject = null;
            return versionedProject;
        }
        finally {
            if (fileInputStream != null) {
                StreamUtils.safeClose(fileInputStream);
            }
        }
        return sAXHandler.project;
    }

    public static boolean validateXMLFileUsingSAX(String string) {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            SAXParser sAXParser = null;
            File file = new File(FileUtils.getMaterialFolder(), XSD_FILE);
            try {
                sAXParserFactory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource(file)}));
                sAXParser = sAXParserFactory.newSAXParser();
            }
            catch (SAXException sAXException) {
                System.err.println("XMLParser: ParserConfigurationException was thrown!");
                System.out.println("XMLParser: SAXException because of SCHEMA error: " + sAXException.getMessage() + " was thorwn");
                sAXException.printStackTrace();
                return false;
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.parse(new InputSource(string));
            return true;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("XMLParser: ParserConfigurationException was thrown!");
            parserConfigurationException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            System.err.println("XMLParser: IOException was thrown!");
            iOException.printStackTrace();
            return false;
        }
        catch (SAXException sAXException) {
            System.err.println("XMLParser: SAXException was thrown!");
            sAXException.printStackTrace();
            return false;
        }
    }

    static final class SAXHandler
    extends DefaultHandler {
        String content = null;
        VersionedProject project = new VersionedProject();
        Set<GrainSize> grainSizes = new HashSet<GrainSize>();
        Set<GrainSize> grainSizesDin = new HashSet<GrainSize>();
        Set<AquiferMaterial> aquiferMaterials = new HashSet<AquiferMaterial>();
        SecondaryLayer currentSubLayer = null;
        Material currentMaterial = null;
        GrainSize currentGrainSize = null;
        AquiferMaterial currentAquiferMaterial = null;
        int materialIndex = 1;
        double totalFraction = 0.0;
        Hydraulic currentHydraulic = null;
        Pollutant currentContaminant = null;
        Timesteps currentTimesteps = new Timesteps();
        ArrayList<Double> btcValues = new ArrayList();
        ArrayList<Double> profileValues = new ArrayList();
        int timestepRangeStart = 0;
        int timestepRangeEnd = 0;

        SAXHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("contaminant")) {
                double d;
                double d2;
                double d3;
                String string4 = attributes.getValue("name");
                try {
                    d3 = Double.parseDouble(attributes.getValue("daq"));
                    d2 = Double.parseDouble(attributes.getValue("logKow"));
                    d = Double.parseDouble(attributes.getValue("logKoc"));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.project.addPollutant(new Pollutant(string4, d3, d2, d));
                return;
            }
            if (string3.equals("lithoComponent")) {
                double d;
                double d4;
                double d5;
                double d6;
                String string5 = attributes.getValue("name");
                try {
                    d6 = Double.parseDouble(attributes.getValue("m"));
                    d5 = Double.parseDouble(attributes.getValue("foc"));
                    d4 = Double.parseDouble(attributes.getValue("lDens"));
                    d = Double.parseDouble(attributes.getValue("nip"));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.aquiferMaterials.add(new AquiferMaterial(string5, d6, d5, d4, d));
                return;
            }
            if (string3.equals("grainSize")) {
                double d;
                String string6 = attributes.getValue("name");
                String string7 = attributes.getValue("idf");
                try {
                    d = Double.parseDouble(attributes.getValue("diam"));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.grainSizes.add(new GrainSize(string6, string7, d));
                return;
            }
            if (string3.equals("grainSizeDin")) {
                String string8 = attributes.getValue("name");
                for (int i = 0; i < MaterialController.GrainFractionDINValue.values().length; ++i) {
                    if (!string8.equals(MaterialController.GrainFractionDINValue.values()[i].getName())) continue;
                    this.grainSizesDin.add(new GrainSize(string8, MaterialController.GrainFractionDINValue.values()[i].getAbbreviation(), MaterialController.GrainFractionDINValue.values()[i].getSize()));
                    return;
                }
                System.out.println("XML-Parser: startElement: Parse result of node 'grainSizeDin' is empty!");
                return;
            }
            if (string3.equals("material")) {
                String string9 = attributes.getValue("name");
                this.currentMaterial = new Material(string9, this.materialIndex);
                ++this.materialIndex;
            } else if (string3.equals("composition")) {
                try {
                    this.totalFraction = Double.parseDouble(attributes.getValue("totalFraction"));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                String string10 = attributes.getValue("grainSizeRef");
                for (GrainSize grainSize : this.grainSizes) {
                    if (!string10.equals(grainSize.getName())) continue;
                    this.currentGrainSize = grainSize;
                    this.currentMaterial.addGrainSize(grainSize);
                    return;
                }
                for (GrainSize grainSize : this.grainSizesDin) {
                    if (!string10.equals(grainSize.getName())) continue;
                    this.currentMaterial.addGrainSize(grainSize);
                    return;
                }
                System.out.println("XML-Parser: startElement: Parse result of node 'composition' is empty!");
            } else if (string3.equals("fraction")) {
                String string11 = attributes.getValue("lithoComponentRef");
                for (AquiferMaterial aquiferMaterial : this.aquiferMaterials) {
                    if (!string11.equals(aquiferMaterial.getBezeichnung())) continue;
                    this.currentAquiferMaterial = aquiferMaterial;
                    this.project.addAquiferMaterial(this.currentAquiferMaterial);
                    this.currentMaterial.addAquiferMaterial(this.currentAquiferMaterial);
                    return;
                }
                System.out.println("XML-Parser: startElement: Parse result of node 'fraction' is empty!");
            } else if (string3.equals("scenario")) {
                String string12 = attributes.getValue("name");
                String string13 = attributes.getValue("note");
                String string14 = attributes.getValue("mode");
                if (string12.equals("") || string13.equals("") || !string14.equals("NORMAL") && !string14.equals("SMART")) {
                    System.out.println("XML-Parser: Node 'scenario' omitted. Attribute(s) incorrect. ");
                    return;
                }
                VersionedProject.SimulationMode simulationMode = attributes.getValue("mode").equals("NORMAL") ? VersionedProject.SimulationMode.NORMAL : VersionedProject.SimulationMode.SMART;
                this.project.setSzenarioName(string12);
                this.project.setScenarioNote(string13);
                this.project.setMode(simulationMode);
            } else {
                if (string3.equals("geometry")) {
                    while (this.project.getLayers().size() > 0) {
                        this.project.removeLayerAtPosition(0);
                    }
                    while (this.project.getLeaves().size() > 0) {
                        this.project.removeLeave(0);
                    }
                    String string15 = attributes.getValue("crossSectionalArea");
                    if (string15.equals("")) {
                        System.out.println("XML-Parser: startElement: Parse result of node 'crossSectionalArea' is empty!");
                        return;
                    }
                    double d = -1.0;
                    try {
                        d = Double.parseDouble(string15);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node 'crossSectionalArea' omitted. Attribute(s) incorrect. ");
                    }
                    if (d > 0.0) {
                        this.project.setCrossSection(d);
                    }
                    return;
                }
                if (string3.equals("mainLayer")) {
                    double d;
                    double d7;
                    String string16 = attributes.getValue("name");
                    try {
                        d7 = Double.parseDouble(attributes.getValue("topEdge"));
                        d = Double.parseDouble(attributes.getValue("bottomEdge"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    Layer layer = new Layer(string16, d7, d);
                    this.project.addLayer(layer);
                } else if (string3.equals("subLayer")) {
                    int n;
                    double d;
                    double d8;
                    String string17 = attributes.getValue("name");
                    try {
                        d8 = Double.parseDouble(attributes.getValue("topEdge"));
                        d = Double.parseDouble(attributes.getValue("bottomEdge"));
                        n = Integer.parseInt(attributes.getValue("cellCount"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    this.currentSubLayer = new SecondaryLayer(string17, d8, d, n);
                    this.project.addLayer(this.currentSubLayer);
                    this.project.addLeave(this.currentSubLayer);
                } else if (string3.equals("hydraulic")) {
                    double d;
                    double d9;
                    double d10;
                    double d11;
                    try {
                        d11 = Double.parseDouble(attributes.getValue("k"));
                        d10 = Double.parseDouble(attributes.getValue("por"));
                        d9 = Double.parseDouble(attributes.getValue("porEff"));
                        d = Double.parseDouble(attributes.getValue("sat"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    this.currentHydraulic = this.project.addHydraulicWithValues(d11, d10, d9, d);
                } else if (string3.equals("travelTime")) {
                    String string18 = attributes.getValue("resAlpha");
                    String string19 = attributes.getValue("resCellCount");
                    String string20 = attributes.getValue("resFile");
                    if (!string20.equals("")) {
                        this.currentSubLayer.setResidenceFile(string20);
                        return;
                    }
                    if (!string18.equals("") && !string19.equals("")) {
                        int n;
                        double d;
                        try {
                            d = Double.parseDouble(attributes.getValue("resAlpha"));
                            n = Integer.parseInt(attributes.getValue("resCellCount"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                            return;
                        }
                        this.currentSubLayer.setResidenceAlpha(d);
                        this.currentSubLayer.setResidenceNumOfCells(n);
                        return;
                    }
                    System.out.println("XML-Parser: startElement: Parse result of node 'travelTime' is empty!");
                } else {
                    if (string3.equals("biodegradation")) {
                        Object object;
                        String string21 = attributes.getValue("contaminantRef");
                        Pollutant pollutant = null;
                        for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                            if (!string21.equals(this.project.allPollutants().get(i).getBezeichnung())) continue;
                            pollutant = this.project.allPollutants().get(i);
                            break;
                        }
                        if (pollutant == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'biodegradation' is empty!");
                            return;
                        }
                        String string22 = attributes.getValue("mode");
                        String string23 = attributes.getValue("halfLifeTime");
                        String string24 = attributes.getValue("order");
                        String string25 = attributes.getValue("concentration");
                        BioDegradationValue bioDegradationValue = null;
                        if (!(string22.equals("") || string23.equals("") || string24.equals("") || string25.equals(""))) {
                            double d;
                            int n;
                            double d12;
                            object = null;
                            if (string22.equals("NO_DEGRADATION")) {
                                object = BioDegradationValue.DegradationMode.NO_DEGRADATION;
                            }
                            if (string22.equals("DEGRADATION_OF_NTH_ORDER")) {
                                object = BioDegradationValue.DegradationMode.DEGRADATION_OF_NTH_ORDER;
                            }
                            if (string22.equals("LH_KINETICS")) {
                                object = BioDegradationValue.DegradationMode.LH_KINETICS;
                            }
                            if (object == null) {
                                System.out.println("XML-Parser: startElement: Parse result of node 'biodegradation' is empty!");
                                return;
                            }
                            try {
                                d12 = Double.parseDouble(string23);
                                n = Integer.parseInt(string24);
                                d = Double.parseDouble(string25);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            bioDegradationValue = new BioDegradationValue((BioDegradationValue.DegradationMode)((Object)object), d12, n, d);
                        }
                        if (bioDegradationValue == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'biodegradation' is empty!");
                            return;
                        }
                        object = this.project.getBioDegredationValueForPollutantAndLayer(pollutant, this.currentSubLayer);
                        object.setMode(bioDegradationValue.getMode());
                        object.setHalfLifeTime(bioDegradationValue.getHalfLifeTime());
                        object.setOrder(bioDegradationValue.getOrder());
                        object.setReferenceConcentration(bioDegradationValue.getReferenceConcentration());
                        return;
                    }
                    if (string3.equals("timestep")) {
                        String string26 = attributes.getValue("count");
                        String string27 = attributes.getValue("length");
                        if (!string26.equals("") && !string27.equals("")) {
                            double d;
                            int n;
                            try {
                                n = Integer.parseInt(string26);
                                d = Double.parseDouble(string27);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            this.currentTimesteps.addTimestep(n, d);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'timestep' is empty!");
                    } else if (string3.equals("upperFlowCondition")) {
                        String string28 = attributes.getValue("inflow");
                        String string29 = attributes.getValue("value");
                        if (!string28.equals("") && !string29.equals("")) {
                            double d;
                            boolean bl = string28.equals("true") || string28.equals("1");
                            try {
                                d = Double.parseDouble(string29);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            this.project.setBcFlowValueTop(d);
                            this.project.setZustrom(bl);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'upperFlowCondition' is empty!");
                    } else if (string3.equals("lowerFlowCondition")) {
                        String string30 = attributes.getValue("outflow");
                        String string31 = attributes.getValue("value");
                        if (!string30.equals("") && !string31.equals("")) {
                            double d;
                            boolean bl = string30.equals("true") || string30.equals("1");
                            try {
                                d = Double.parseDouble(string31);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            this.project.setBcFlowValueBottom(d);
                            this.project.setAbstrom(bl);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'lowerFlowCondition' is empty!");
                    } else if (string3.equals("upperTransportCondition")) {
                        String string32 = attributes.getValue("calcMode");
                        if (!string32.equals("")) {
                            BoundaryCondition.CalculationMode calculationMode = null;
                            if (string32.equals("EARLIER_VALUE")) {
                                calculationMode = BoundaryCondition.CalculationMode.EARLIER_VALUE;
                            } else if (string32.equals("NEXT_VALUE")) {
                                calculationMode = BoundaryCondition.CalculationMode.NEXT_VALUE;
                            } else if (string32.equals("INTERPOLATION")) {
                                calculationMode = BoundaryCondition.CalculationMode.INTERPOLATION;
                            }
                            if (calculationMode != null) {
                                this.project.getPollutantUpperBoundary().setMode(calculationMode);
                            }
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'upperTransportCondition' is empty!");
                    } else if (string3.equals("timeInterval")) {
                        String string33 = attributes.getValue("time");
                        if (!string33.equals("")) {
                            double d;
                            try {
                                d = Double.parseDouble(string33);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            this.project.getPollutantUpperBoundary().appendInterval();
                            int n = this.project.getPollutantUpperBoundary().getIntervalCount() - 1;
                            this.project.getPollutantUpperBoundary().setDateValueForInterval(d, n);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'upperTransportCondition' is empty!");
                    } else if (string3.equals("inflowConcInMgL")) {
                        String string34 = attributes.getValue("contaminantRef");
                        Pollutant pollutant = null;
                        for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                            if (!string34.equals(this.project.allPollutants().get(i).getBezeichnung())) continue;
                            pollutant = this.project.allPollutants().get(i);
                            break;
                        }
                        if (pollutant == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'inflowConcInMgL' is empty!");
                            return;
                        }
                        this.currentContaminant = pollutant;
                    } else if (string3.equals("initialTransportCondition")) {
                        String string35 = attributes.getValue("calcMode");
                        String string36 = attributes.getValue("equilibrium");
                        String string37 = attributes.getValue("phase");
                        if (!(string35.equals("") || string36.equals("") || string37.equals(""))) {
                            BoundaryCondition.CalculationMode calculationMode = null;
                            if (string35.equals("EARLIER_VALUE")) {
                                calculationMode = BoundaryCondition.CalculationMode.EARLIER_VALUE;
                            } else if (string35.equals("NEXT_VALUE")) {
                                calculationMode = BoundaryCondition.CalculationMode.NEXT_VALUE;
                            } else if (string35.equals("INTERPOLATION")) {
                                calculationMode = BoundaryCondition.CalculationMode.INTERPOLATION;
                            }
                            if (calculationMode != null) {
                                this.project.getPollutantInitialBoundary().setMode(calculationMode);
                            }
                            InitialBoundaryCondition.Equilibrium equilibrium = null;
                            if (string36.equals("EQUILIBRIUM")) {
                                equilibrium = InitialBoundaryCondition.Equilibrium.EQUILIBRIUM;
                            } else if (string36.equals("NON_EQUILIBRIUM")) {
                                equilibrium = InitialBoundaryCondition.Equilibrium.NON_EQUILIBRIUM;
                            }
                            if (equilibrium != null) {
                                this.project.getPollutantInitialBoundary().setSystemState(equilibrium);
                            }
                            InitialBoundaryCondition.Phase phase = null;
                            if (string37.equals("AQUEOUS")) {
                                phase = InitialBoundaryCondition.Phase.AQUEOUS;
                            } else if (string37.equals("SOLID")) {
                                phase = InitialBoundaryCondition.Phase.SOLID;
                            }
                            if (phase != null) {
                                this.project.getPollutantInitialBoundary().setSystemPhase(phase);
                            }
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'initialTransportCondition' is empty!");
                    } else if (string3.equals("depthInterval")) {
                        String string38 = attributes.getValue("depth");
                        if (!string38.equals("")) {
                            double d;
                            try {
                                d = Double.parseDouble(string38);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                                return;
                            }
                            this.project.getPollutantInitialBoundary().appendInterval();
                            int n = this.project.getPollutantInitialBoundary().getIntervalCount() - 1;
                            this.project.getPollutantInitialBoundary().setDateValueForInterval(d, n);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'depthInterval' is empty!");
                    } else if (string3.equals("initialConcInMgLOrMgKg")) {
                        String string39 = attributes.getValue("contaminantRef");
                        Pollutant pollutant = null;
                        for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                            if (!string39.equals(this.project.allPollutants().get(i).getBezeichnung())) continue;
                            pollutant = this.project.allPollutants().get(i);
                            break;
                        }
                        if (pollutant == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'initialConcInMgLOrMgKg' is empty!");
                            return;
                        }
                        this.currentContaminant = pollutant;
                    } else if (string3.equals("sorption")) {
                        String string40 = attributes.getValue("calcModeIsSorpEq");
                        String string41 = attributes.getValue("calcBasisDiffCoeffIsIsoParam");
                        String string42 = attributes.getValue("calcBasisSorpEqIsIsoParam");
                        if (!(string40.equals("") || string41.equals("") || string41.equals(""))) {
                            boolean bl = string40.equals("true") || string40.equals("1");
                            boolean bl2 = string41.equals("true") || string41.equals("1");
                            boolean bl3 = string42.equals("true") || string42.equals("1");
                            this.project.setCalculationDaq(!bl);
                            this.project.setCalculationFocKoc(!bl2);
                            this.project.setCalculationKd(bl2);
                            this.project.setSorpModeFocKoc(!bl3);
                            return;
                        }
                        System.out.println("XML-Parser: startElement: Parse result of node 'sorption' is empty!");
                    } else if (string3.equals("sorptionIsotherm")) {
                        String string43 = attributes.getValue("eqFraction");
                        String string44 = attributes.getValue("type");
                        String string45 = attributes.getValue("p1");
                        String string46 = attributes.getValue("p2");
                        String string47 = attributes.getValue("p3");
                        SorptionValue.IsothermType isothermType = null;
                        if (string44.equals("HENRY")) {
                            isothermType = SorptionValue.IsothermType.HENRY;
                        } else if (string44.equals("FREUNDLICH")) {
                            isothermType = SorptionValue.IsothermType.FREUNDLICH;
                        } else if (string44.equals("LANGMUIR")) {
                            isothermType = SorptionValue.IsothermType.LANGMUIR;
                        } else if (string44.equals("BET")) {
                            isothermType = SorptionValue.IsothermType.BET;
                        }
                        SorptionValue sorptionValue = null;
                        if (isothermType != null && !string43.equals("")) {
                            double d;
                            double d13;
                            double d14;
                            if (isothermType.equals((Object)SorptionValue.IsothermType.HENRY) && !string45.equals("")) {
                                try {
                                    d14 = Double.parseDouble(string43);
                                    d13 = Double.parseDouble(string45);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.out.println("XML-Parser: startElement: Parse result of node 'inflowConcInMgL' is empty!");
                                    return;
                                }
                                sorptionValue = new SorptionValue(isothermType);
                                sorptionValue.setParameter1(d13);
                                sorptionValue.setEquilibriumFraction(d14);
                            } else if ((isothermType.equals((Object)SorptionValue.IsothermType.FREUNDLICH) || isothermType.equals((Object)SorptionValue.IsothermType.LANGMUIR)) && !string45.equals("") && !string46.equals("")) {
                                try {
                                    d14 = Double.parseDouble(string43);
                                    d13 = Double.parseDouble(string45);
                                    d = Double.parseDouble(string46);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.out.println("XML-Parser: startElement: Parse result of node 'inflowConcInMgL' is empty!");
                                    return;
                                }
                                sorptionValue = new SorptionValue(isothermType);
                                sorptionValue.setParameter1(d13);
                                sorptionValue.setParameter2(d);
                                sorptionValue.setEquilibriumFraction(d14);
                            } else if (isothermType.equals((Object)SorptionValue.IsothermType.BET) && !string45.equals("") && !string46.equals("") && !string47.equals("")) {
                                double d15;
                                try {
                                    d14 = Double.parseDouble(string43);
                                    d13 = Double.parseDouble(string45);
                                    d = Double.parseDouble(string46);
                                    d15 = Double.parseDouble(string47);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.out.println("XML-Parser: startElement: Parse result of node 'inflowConcInMgL' is empty!");
                                    return;
                                }
                                sorptionValue = new SorptionValue(isothermType);
                                sorptionValue.setParameter1(d13);
                                sorptionValue.setParameter2(d);
                                sorptionValue.setParameter3(d15);
                                sorptionValue.setEquilibriumFraction(d14);
                            }
                        }
                        if (sorptionValue == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'sorptionIsotherm' is empty!");
                            return;
                        }
                        String string48 = attributes.getValue("contaminantRef");
                        Pollutant pollutant = null;
                        for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                            if (!string48.equals(this.project.allPollutants().get(i).getBezeichnung())) continue;
                            pollutant = this.project.allPollutants().get(i);
                            break;
                        }
                        if (pollutant == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'sorptionIsotherm' is empty!");
                            return;
                        }
                        String string49 = attributes.getValue("lithoComponentRef");
                        AquiferMaterial aquiferMaterial = null;
                        for (AquiferMaterial aquiferMaterial2 : this.aquiferMaterials) {
                            if (!string49.equals(aquiferMaterial2.getBezeichnung())) continue;
                            aquiferMaterial = aquiferMaterial2;
                            break;
                        }
                        if (aquiferMaterial == null) {
                            System.out.println("XML-Parser: startElement: Parse result of node 'sorptionIsotherm' is empty!");
                            return;
                        }
                        SorptionValue sorptionValue2 = this.project.getSorptionValueForPollutantAndAquiferMaterial(pollutant, aquiferMaterial);
                        sorptionValue2.setEquilibriumFraction(sorptionValue.getEquilibriumFraction());
                        sorptionValue2.setIsothermType(sorptionValue.getIsothermType());
                        sorptionValue2.setParameter1(sorptionValue.getParameter1());
                        if (sorptionValue.getIsothermType().equals((Object)SorptionValue.IsothermType.FREUNDLICH) || sorptionValue.getIsothermType().equals((Object)SorptionValue.IsothermType.LANGMUIR)) {
                            sorptionValue2.setParameter2(sorptionValue.getParameter2());
                        } else if (sorptionValue.getIsothermType().equals((Object)SorptionValue.IsothermType.BET)) {
                            sorptionValue2.setParameter2(sorptionValue.getParameter2());
                            sorptionValue2.setParameter3(sorptionValue.getParameter3());
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            double d;
            if (string3.equals("fraction")) {
                try {
                    d = Double.parseDouble(this.content);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.currentMaterial.setMassFractionValue(this.currentAquiferMaterial, this.currentGrainSize, d);
            }
            if (string3.equals("material")) {
                this.project.addMaterial(this.currentMaterial);
            } else if (string3.equals("materialRef")) {
                String string4 = this.content;
                for (int i = 0; i < this.project.allMaterials().size(); ++i) {
                    if (!string4.equals(this.project.allMaterials().get(i).getName())) continue;
                    this.project.setMaterialForLayer(this.currentSubLayer, this.project.allMaterials().get(i));
                    return;
                }
                System.out.println("XML-Parser: endElement: Parse result of node 'materialRef' is empty!");
            } else if (string3.equals("hydraulic")) {
                this.project.setHydraulicForLayer(this.currentSubLayer, this.currentHydraulic);
            } else if (string3.equals("composition")) {
                this.currentMaterial.setTotalFractionForGrainSize(this.currentGrainSize, this.totalFraction);
            } else if (string3.equals("simulationTime")) {
                this.project.setTimesteps(this.currentTimesteps);
            } else if (string3.equals("inflowConcInMgL")) {
                int n;
                try {
                    d = Double.parseDouble(this.content);
                    n = this.project.getPollutantUpperBoundary().getIntervalCount() - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.project.getPollutantUpperBoundary().setValueForIntervalAndCatalogObject(d, n, this.currentContaminant);
            } else if (string3.equals("initialConcInMgLOrMgKg")) {
                int n;
                try {
                    d = Double.parseDouble(this.content);
                    n = this.project.getPollutantInitialBoundary().getIntervalCount() - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.project.getPollutantInitialBoundary().setValueForIntervalAndCatalogObject(d, n, this.currentContaminant);
            } else if (string3.equals("btc")) {
                try {
                    d = Double.parseDouble(this.content);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.btcValues.add(d);
            } else if (string3.equals("profile")) {
                try {
                    d = Double.parseDouble(this.content);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                    return;
                }
                this.profileValues.add(d);
                System.out.println("added " + d);
            } else if (string3.equals("outputSpec")) {
                int n;
                double[] dArray;
                if (this.btcValues.size() > 0) {
                    int n2 = this.btcValues.size();
                    dArray = new double[n2];
                    for (n = 0; n < n2; ++n) {
                        dArray[n] = this.btcValues.get(n);
                    }
                    this.project.setBtcValues(dArray);
                }
                if (this.profileValues.size() > 0) {
                    int n3 = this.profileValues.size();
                    dArray = new double[n3];
                    for (n = 0; n < n3; ++n) {
                        dArray[n] = this.profileValues.get(n);
                    }
                    System.out.println(dArray.toString());
                    this.project.setProfileValues(dArray);
                }
            } else {
                if (string3.equals("mxv") || string3.equals("mxip") || string3.equals("mxpic") || string3.equals("mxitsub") || string3.equals("xeps")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getTransportModel();
                    if (string3.equals("mxv")) {
                        dArray[0] = d;
                    } else if (string3.equals("mxip")) {
                        dArray[1] = d;
                    } else if (string3.equals("mxpic")) {
                        dArray[2] = d;
                    } else if (string3.equals("mxitsub")) {
                        dArray[3] = d;
                    } else if (string3.equals("xeps")) {
                        dArray[4] = d;
                    }
                    return;
                }
                if (string3.equals("mxiter") || string3.equals("acc_val")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getConcentrationEquilibrium();
                    if (string3.equals("mxiter")) {
                        dArray[0] = d;
                    } else if (string3.equals("acc_val")) {
                        dArray[1] = d;
                    }
                    return;
                }
                if (string3.equals("relax") || string3.equals("mxitbc")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getCalculationProcessSteps();
                    if (string3.equals("relax")) {
                        dArray[0] = d;
                    } else if (string3.equals("mxitbc")) {
                        dArray[1] = d;
                    }
                    return;
                }
                if (string3.equals("mode")) {
                    String string5 = this.content;
                    ModelParameter.CalculationMode calculationMode = null;
                    if (string5.equals("ANALYTICAL")) {
                        calculationMode = ModelParameter.CalculationMode.ANALYTICAL;
                    } else if (string5.equals("NUMERICAL")) {
                        calculationMode = ModelParameter.CalculationMode.NUMERICAL;
                    }
                    if (calculationMode != null) {
                        this.project.getFurtherModelParameters().setIpCalculationMode(calculationMode);
                    }
                    return;
                }
                if (string3.equals("mxdelDiff")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    this.project.getFurtherModelParameters().setCalculationIPDiffusion(d);
                    return;
                }
                if (string3.equals("mxdefit") || string3.equals("nInf") || string3.equals("mxnegDiff") || string3.equals("minDissDiff")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getCalculationIPAnalytical();
                    if (string3.equals("mxdefit")) {
                        dArray[0] = d;
                    } else if (string3.equals("nInf")) {
                        dArray[1] = d;
                    } else if (string3.equals("mxnegDiff")) {
                        dArray[2] = d;
                    } else if (string3.equals("minDissDiff")) {
                        dArray[3] = d;
                    }
                    return;
                }
                if (string3.equals("nr") || string3.equals("itmax") || string3.equals("dtmin") || string3.equals("dtmax") || string3.equals("tfak") || string3.equals("lambda") || string3.equals("eps1") || string3.equals("eps2") || string3.equals("cmin") || string3.equals("scale")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getCalculationIPNumerical();
                    if (string3.equals("nr")) {
                        dArray[0] = d;
                    } else if (string3.equals("itmax")) {
                        dArray[1] = d;
                    } else if (string3.equals("dtmin")) {
                        dArray[2] = d;
                    } else if (string3.equals("dtmax")) {
                        dArray[3] = d;
                    } else if (string3.equals("tfak")) {
                        dArray[4] = d;
                    } else if (string3.equals("lambda")) {
                        dArray[5] = d;
                    } else if (string3.equals("eps1")) {
                        dArray[6] = d;
                    } else if (string3.equals("eps2")) {
                        dArray[7] = d;
                    } else if (string3.equals("cmin")) {
                        dArray[8] = d;
                    } else if (string3.equals("scale")) {
                        dArray[9] = d;
                    }
                    return;
                }
                if (string3.equals("mxlh") || string3.equals("accLh")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getCalculationBioDegradation();
                    if (string3.equals("mxlh")) {
                        dArray[0] = d;
                    } else if (string3.equals("accLh")) {
                        dArray[1] = d;
                    }
                    return;
                }
                if (string3.equals("outputControlMode")) {
                    int n;
                    try {
                        n = Integer.parseInt(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    if (n >= 0 && n < 64) {
                        this.project.getFurtherModelParameters().setOutputControlMode(n);
                    }
                    return;
                }
                if (string3.equals("timeStepRangeFrom") || string3.equals("timeStepRangeTo")) {
                    int n;
                    try {
                        n = Integer.parseInt(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    if (string3.equals("timeStepRangeFrom") && n >= 0) {
                        this.timestepRangeStart = n;
                    } else if (string3.equals("timeStepRangeTo") && n >= this.timestepRangeStart) {
                        this.timestepRangeEnd = n;
                    }
                    return;
                }
                if (string3.equals("outputData")) {
                    if (this.timestepRangeStart >= 0 && this.timestepRangeEnd >= this.timestepRangeStart) {
                        int[] nArray = new int[]{this.timestepRangeStart, this.timestepRangeEnd};
                        this.project.getFurtherModelParameters().setTimestepRange(nArray);
                    } else {
                        System.out.println("XML-Parser: Node 'timestepRange' omitted. Attribute(s) incorrect. ");
                    }
                    return;
                }
                if (string3.equals("formatBTCAndProfileOutput")) {
                    String string6 = this.content;
                    ModelParameter.FileFormat fileFormat = null;
                    if (string6.equals("ASCII")) {
                        fileFormat = ModelParameter.FileFormat.ASCII;
                    } else if (string6.equals("CSV")) {
                        fileFormat = ModelParameter.FileFormat.CSV;
                    } else if (string6.equals("MATLAB")) {
                        fileFormat = ModelParameter.FileFormat.MATLAB;
                    } else if (string6.equals("TECPLOT")) {
                        fileFormat = ModelParameter.FileFormat.TECPLOT;
                    }
                    if (fileFormat != null) {
                        this.project.getFurtherModelParameters().setFormatBTCAndProfileOutput(fileFormat);
                    }
                    return;
                }
                if (string3.equals("dataContam")) {
                    String string7 = this.content;
                    VersionedProject.ConcentrationValue concentrationValue = null;
                    if (string7.equals("DISS")) {
                        concentrationValue = VersionedProject.ConcentrationValue.DISS;
                    } else if (string7.equals("MIC")) {
                        concentrationValue = VersionedProject.ConcentrationValue.MIC;
                    } else if (string7.equals("SORB")) {
                        concentrationValue = VersionedProject.ConcentrationValue.SORB;
                    } else if (string7.equals("MONO")) {
                        concentrationValue = VersionedProject.ConcentrationValue.MONO;
                    } else if (string7.equals("DIFF")) {
                        concentrationValue = VersionedProject.ConcentrationValue.DIFF;
                    } else if (string7.equals("RED")) {
                        concentrationValue = VersionedProject.ConcentrationValue.RED;
                    }
                    if (concentrationValue != null) {
                        this.project.getConcentrationPollutant().add(concentrationValue);
                    }
                    return;
                }
                if (string3.equals("dataSurf")) {
                    String string8 = this.content;
                    VersionedProject.ConcentrationValue concentrationValue = null;
                    if (string8.equals("MONO")) {
                        concentrationValue = VersionedProject.ConcentrationValue.MONO;
                    } else if (string8.equals("MIC")) {
                        concentrationValue = VersionedProject.ConcentrationValue.MIC;
                    } else if (string8.equals("SORB")) {
                        concentrationValue = VersionedProject.ConcentrationValue.SORB;
                    }
                    if (concentrationValue != null) {
                        this.project.getConcentrationAquiferMaterial().add(concentrationValue);
                    }
                    return;
                }
                if (string3.equals("concEps") || string3.equals("mxp") || string3.equals("accuracy")) {
                    try {
                        d = Double.parseDouble(this.content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("XML-Parser: Node '" + string3 + "' omitted. Attribute(s) incorrect. ");
                        return;
                    }
                    double[] dArray = this.project.getFurtherModelParameters().getFurtherParameters();
                    if (string3.equals("concEps")) {
                        dArray[0] = d;
                    } else if (string3.equals("mxp")) {
                        dArray[1] = d;
                    } else if (string3.equals("accuracy")) {
                        dArray[2] = d;
                    }
                    return;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.content = String.copyValueOf(cArray, n, n2).trim();
        }
    }
}

