/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.data.GrainSize;
import de.dsite.data.Layer;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.project.BioDegradationValue;
import de.dsite.project.BoundaryCondition;
import de.dsite.project.InitialBoundaryCondition;
import de.dsite.project.ModelParameter;
import de.dsite.project.SecondaryLayer;
import de.dsite.project.SorptionValue;
import de.dsite.project.VersionedProject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class Transformer {
    private VersionedProject project;
    private File inputFile;
    private boolean debug = false;

    public Transformer(VersionedProject versionedProject, File file) {
        this.project = versionedProject;
        this.inputFile = file;
    }

    public Transformer(VersionedProject versionedProject, File file, boolean bl) {
        this(versionedProject, file);
        this.debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void gererateInputFile() throws IOException, FileNotFoundException {
        void var23_63;
        void var14_20;
        void var74_227;
        void var73_213;
        void var73_208;
        void var72_193;
        void var71_184;
        Object object;
        Object object2;
        int n;
        int n2;
        void var60_136;
        void var60_133;
        Object object3;
        void var55_107;
        int n3;
        int n4;
        void var23_60;
        void var23_57;
        void var23_54;
        void var23_51;
        void var23_48;
        void var23_45;
        void var23_42;
        void var23_39;
        void var23_36;
        int n5;
        int n6 = 0;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            n6 += secondaryLayer.getNumModellzellen();
        }
        int n7 = 0;
        if (this.project.getTimesteps() != null) {
            n7 = this.project.getTimesteps().sumOfTimestepCounts();
        }
        if (this.debug) {
            // empty if block
        }
        int n8 = 0;
        if (this.project.usedAquiferMaterials() != null) {
            n8 = this.project.usedAquiferMaterials().size();
        }
        int n9 = this.project.usedGrainSizes() == null ? 0 : this.project.usedGrainSizes().size();
        int n10 = 0;
        if (this.project.allPollutants() != null) {
            n10 = this.project.allPollutants().size();
        }
        int n11 = 0;
        if (this.project.allSurfactants() != null) {
            n11 = this.project.allSurfactants().size();
        }
        int n12 = 0;
        if (this.project.getBtcValues() != null) {
            n12 = this.project.getBtcValues().length;
        }
        int n13 = 0;
        if (this.project.getProfileValues() != null) {
            n13 = this.project.getProfileValues().length;
        }
        String string = "__VERSION\n";
        string = string.concat("201204\n");
        String string2 = "__TITEL\n";
        if (this.project.getScenarioNote() != null && this.project.getScenarioNote().length() > 0) {
            string2 = string2.concat("1\n");
            string2 = string2.concat(this.project.getScenarioNote() + "\n");
        } else {
            string2 = string2.concat("0\n");
        }
        String string3 = "__SIMULATION_MODE\n";
        string3 = this.project.getMode() == VersionedProject.SimulationMode.SMART ? string3.concat("5\n" + this.project.getLeaves().size() + "\n" + 2) : string3.concat("1\n1\n2");
        String string4 = "\n__TRAVEL_TIME_CELLS\n";
        for (SecondaryLayer object122 : this.project.getLeaves()) {
            string4 = string4.concat(object122.getResidenceNumOfCells() + " ");
        }
        Object object13 = "\n__DIMENSIONS\n";
        object13 = ((String)object13).concat(n6 + "\n" + n7 + "\n" + n8 + "\n" + n9 + "\n" + n10 + "\n" + n11 + "\n" + n12 + "\n" + n13 + "\n");
        String string5 = "__MASTER_FILENAME\n";
        if (this.project.getSzenarioName() != null && this.project.getSzenarioName().length() > 0) {
            String string6 = string5.concat(this.project.getSzenarioName() + "\n");
        } else {
            String string7 = string5.concat("smart\n");
        }
        String string8 = "__DATA_BASE_FILES\n";
        if (n10 > 0) {
            string8 = string8.concat("contam.clg\n");
        }
        if (n8 > 0) {
            string8 = string8.concat("soil.clg\n");
        }
        if (n11 > 0) {
            string8 = string8.concat("surfact.clg\n");
        }
        String string9 = "__SIMULATION_PARAMETER";
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getTransportModel().length; ++n5) {
            string9 = n5 < 4 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getTransportModel()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getTransportModel()[n5]);
        }
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getConcentrationEquilibrium().length; ++n5) {
            string9 = n5 == 0 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getConcentrationEquilibrium()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getConcentrationEquilibrium()[n5]);
        }
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getCalculationProcessSteps().length; ++n5) {
            string9 = n5 == 1 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getCalculationProcessSteps()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getCalculationProcessSteps()[n5]);
        }
        string9 = string9.concat("\n" + this.project.getFurtherModelParameters().getCalculationIPDiffusion());
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getCalculationIPAnalytical().length; ++n5) {
            string9 = n5 < 2 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getCalculationIPAnalytical()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getCalculationIPAnalytical()[n5]);
        }
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getCalculationIPNumerical().length; ++n5) {
            string9 = n5 < 2 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getCalculationIPNumerical()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getCalculationIPNumerical()[n5]);
        }
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getCalculationBioDegradation().length; ++n5) {
            string9 = n5 == 0 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getCalculationBioDegradation()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getCalculationBioDegradation()[n5]);
        }
        for (n5 = 0; n5 < this.project.getFurtherModelParameters().getFurtherParameters().length; ++n5) {
            string9 = n5 == 1 ? string9.concat("\n" + (int)this.project.getFurtherModelParameters().getFurtherParameters()[n5]) : string9.concat("\n" + this.project.getFurtherModelParameters().getFurtherParameters()[n5]);
        }
        String string10 = "__SIMULATION_PARAMETER_FILE\n";
        string10 = string10.concat("smart.dim\n");
        String string11 = "\n__FURTHER_INPUT_FILES\n";
        int n14 = 0;
        String string12 = "";
        int n15 = 150;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            if (!secondaryLayer.isResidenceCalculationFromFile()) continue;
            ++n14;
            File file = new File(secondaryLayer.getResidenceFile());
            string12 = string12.concat(n15++ + " " + file.getName() + "\n");
        }
        string11 = string11.concat(" " + n14 + "\n" + string12);
        Object object4 = "\n__PDF_DATA\n";
        n15 = 150;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            if (secondaryLayer.isResidenceCalculationFromFile()) {
                object4 = ((String)object4).concat("3\n" + n15++ + " 2\n");
                continue;
            }
            object4 = ((String)object4).concat("0\n1 " + secondaryLayer.getResidenceAlpha() + "\n");
        }
        String string13 = "__OUTPUT_CONTROL\n";
        if (this.project.getFurtherModelParameters().getOutputControlMode() == 0) {
            String string14 = string13.concat("-1 \n0 0\n");
        } else {
            String string16 = string13.concat("" + this.project.getFurtherModelParameters().getOutputControlMode() + "\n");
            string16 = string16.concat("" + this.project.getFurtherModelParameters().getTimestepRange()[0] + " " + this.project.getFurtherModelParameters().getTimestepRange()[1] + "\n");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.DISS)) {
            String string17 = var23_36.concat("1 ");
        } else {
            String string18 = var23_36.concat("0 ");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.MIC)) {
            String string19 = var23_39.concat("1 ");
        } else {
            String string20 = var23_39.concat("0 ");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.SORB)) {
            String string21 = var23_42.concat("1 ");
        } else {
            String string22 = var23_42.concat("0 ");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.MONO)) {
            String string23 = var23_45.concat("1 ");
        } else {
            String string24 = var23_45.concat("0 ");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.DIFF)) {
            String string25 = var23_48.concat("1 ");
        } else {
            String string26 = var23_48.concat("0 ");
        }
        if (this.project.getConcentrationPollutant().contains((Object)VersionedProject.ConcentrationValue.RED)) {
            String string27 = var23_51.concat("1\n");
        } else {
            String string28 = var23_51.concat("0\n");
        }
        if (this.project.getConcentrationAquiferMaterial().contains((Object)VersionedProject.ConcentrationValue.MONO)) {
            String string29 = var23_54.concat("1 ");
        } else {
            String string30 = var23_54.concat("0 ");
        }
        if (this.project.getConcentrationAquiferMaterial().contains((Object)VersionedProject.ConcentrationValue.MIC)) {
            String string31 = var23_57.concat("1 ");
        } else {
            String string32 = var23_57.concat("0 ");
        }
        if (this.project.getConcentrationAquiferMaterial().contains((Object)VersionedProject.ConcentrationValue.SORB)) {
            String string33 = var23_60.concat("1\n");
        } else {
            String string34 = var23_60.concat("0\n");
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        ArrayList<Double> arrayList6 = new ArrayList<Double>();
        int n16 = 0;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            for (int i = 0; i < secondaryLayer.getNumModellzellen(); ++i) {
                arrayList.add(n16);
                arrayList2.add((secondaryLayer.getXUK() - secondaryLayer.getXOK()) / (double)secondaryLayer.getNumModellzellen());
                arrayList3.add(secondaryLayer.getHydraulic().getValues()[0]);
                arrayList4.add(secondaryLayer.getHydraulic().getValues()[1]);
                arrayList5.add(secondaryLayer.getHydraulic().getValues()[2]);
                arrayList6.add(secondaryLayer.getHydraulic().getValues()[3]);
            }
            ++n16;
        }
        Object object5 = "__GEOMETRICAL_DATA\n";
        object5 = ((String)object5).concat(this.project.getCrossSection() + "\n11 1.e0\n");
        for (Double d : arrayList2) {
            object5 = ((String)object5).concat("" + d.toString() + "\n");
        }
        String string35 = "__LAYER_GEOMETRY";
        String string36 = "";
        String string37 = "";
        int n17 = 0;
        int n18 = 0;
        for (Layer layer : this.project.getLayers()) {
            if (layer instanceof SecondaryLayer) {
                string37 = string37.concat(" " + ((SecondaryLayer)layer).getNumModellzellen());
                ++n18;
                continue;
            }
            ++n17;
            if (n18 <= 0) continue;
            string36 = string36.concat("" + n18 + "\n" + string37 + "\n");
            n18 = 0;
        }
        string36 = string36.concat("" + n18 + "\n" + string37 + "\n");
        String string38 = string35.concat("\n" + n17 + "\n" + string36);
        Object object6 = "__BOUNDARY_CONDITIONS\n";
        int n19 = 1;
        double d = 0.0;
        double d2 = this.project.getBcFlowValueTop();
        double d3 = this.project.getBcFlowValueBottom();
        if (this.project.isZustrom()) {
            n19 = 2;
            d = this.project.getBcFlowValueTop();
            d2 = 0.0;
        } else if (this.project.isAbstrom()) {
            n19 = 3;
            d = this.project.getBcFlowValueTop();
            d3 = this.project.getBcFlowValueBottom();
        }
        object6 = ((String)object6).concat(n19 + " " + d2 + " " + d3 + " " + d + "\n");
        String string39 = "__HYDRAULIC_DATA\n 11 1.e0\n";
        for (Double d4 : arrayList3) {
            string39 = string39.concat(d4.toString() + " ");
        }
        string39 = string39.concat("\n11 1.e0\n");
        for (Double d4 : arrayList4) {
            string39 = string39.concat(d4.toString() + " ");
        }
        string39 = string39.concat("\n11 1.e0\n");
        for (Double d4 : arrayList5) {
            string39 = string39.concat(d4.toString() + " ");
        }
        string39 = string39.concat("\n11 1.e0\n");
        for (Double d4 : arrayList6) {
            string39 = string39.concat(d4.toString() + " ");
        }
        Object object7 = "\n__TIME_DATA\n2\n";
        int n20 = this.project.getTimesteps().numberOfTimesteps();
        int n21 = 1;
        for (int i = 0; i < n20; ++i) {
            n4 = this.project.getTimesteps().getTimeStepCountForTimestepAtIndex(i) + n21 - 1;
            n3 = (int)this.project.getTimesteps().getTimeStepLengthForTimestepAtIndexInSeconds(i);
            object7 = ((String)object7).concat("" + n21 + " " + n4 + " " + n3 + "\n");
            n21 = n4 + 1;
        }
        String string40 = "__CALCULATION_DATA\n";
        n4 = 0;
        if (this.project.isCalculationDaq() && this.project.isCalculationFocKoc()) {
            n4 = 1;
        } else if (this.project.isCalculationDaq() && this.project.isCalculationKd()) {
            n4 = 2;
        }
        n3 = 0;
        if (this.project.getFurtherModelParameters().getIpCalculationMode() == ModelParameter.CalculationMode.ANALYTICAL) {
            n3 = 1;
        }
        if (this.project.getFurtherModelParameters().getIpCalculationMode() == ModelParameter.CalculationMode.NUMERICAL) {
            n3 = 2;
        } else {
            n4 = 0;
            n3 = 0;
        }
        int n22 = 2;
        if (this.project.isSorpModeFocKoc()) {
            n22 = 1;
        }
        string40 = string40.concat(n4 + "\n" + n3 + "\n" + n22 + "\n");
        String string41 = "__LITHOCOMPONENTS\n";
        for (CatalogObject catalogObject : this.project.usedAquiferMaterials()) {
            string41 = string41.concat(" " + catalogObject.getId() + " " + catalogObject.getBezeichnung() + "\n");
        }
        Object object8 = "__GRAIN_SIZE_CLASSES\n";
        for (GrainSize grainSize : this.project.usedGrainSizes()) {
            object8 = ((String)object8).concat("" + grainSize.getDiam() / 2000.0 + "\n 11 1.e0\n");
            for (int i = 0; i < n6; ++i) {
                Double d5 = this.project.getLeaves().get((Integer)arrayList.get(i)).getMaterial().getTotalFractionForGrainSize(grainSize);
                if (d5 != null) {
                    Double d6 = d5 / 100.0;
                    object8 = ((String)object8).concat("" + d6 + "\n");
                    continue;
                }
                object8 = ((String)object8).concat("0.0\n");
            }
            for (CatalogObject catalogObject : this.project.usedAquiferMaterials()) {
                object8 = ((String)object8).concat(" 11 1.e0\n");
                for (int i = 0; i < n6; ++i) {
                    Double d7 = this.project.getLeaves().get((Integer)arrayList.get(i)).getMaterial().getMassFractionValue((AquiferMaterial)catalogObject, grainSize);
                    if (d7 != null) {
                        Double d8 = d7 / 100.0;
                        object8 = ((String)object8).concat(d8 + "\n");
                        continue;
                    }
                    object8 = ((String)object8).concat("0.0\n");
                }
            }
        }
        String string42 = "__SURFACTANTS";
        int n23 = 0;
        for (CatalogObject catalogObject : this.project.allSurfactants()) {
            String string43 = var55_107.concat("\n" + ++n23 + " " + catalogObject.getId() + " " + catalogObject.getBezeichnung() + "\n");
        }
        Object object9 = "\n__CONTAMINANTS\n";
        boolean bl = false;
        for (CatalogObject catalogObject : this.project.allPollutants()) {
            void var58_121;
            object9 = ((String)object9).concat("" + (int)(++var58_121) + " " + catalogObject.getId() + " " + catalogObject.getBezeichnung() + "\n");
        }
        Object object10 = "__EQUILIBRIUM_FRACTIONS";
        for (CatalogObject catalogObject : this.project.usedAquiferMaterials()) {
            object10 = ((String)object10).concat("\n 11 1.e0\n");
            for (CatalogObject catalogObject2 : this.project.allPollutants()) {
                double d9 = this.project.getSorptionValueForPollutantAndAquiferMaterial((Pollutant)catalogObject2, (AquiferMaterial)catalogObject).getEquilibriumFraction();
                object10 = ((String)object10).concat(d9 + " ");
            }
        }
        String string45 = "\n__INITIAL_CONCENTRATIONS\n";
        string45 = string45.concat("__SURFACTANTS\n");
        String string46 = "__SOLUTE_CONCENTRATION\n";
        if (this.project.allSurfactants() != null && this.project.allSurfactants().size() > 0) {
            void var61_142;
            void var63_149;
            object3 = this.initialToModelTimeForBoundaryCondition(this.project.getSurfactantInitialBoundary());
            boolean bl2 = false;
            while (var63_149 < this.project.allSurfactants().size()) {
                String string47 = var61_142.concat(" 11 1.e0\n");
                for (int i = 0; i < n6; ++i) {
                    void var61_144;
                    String string48 = var61_144.concat((double)Math.round((double)(object3[i][var63_149] * 100000.0)) / 100000.0 + "\n");
                }
                ++var63_149;
            }
            String string49 = string45.concat((String)var61_142 + "\n");
        }
        String string51 = var60_133.concat("__CONTAMINANTS\n");
        string51 = string51.concat("__MASS_PER_MASS_SOIL\n");
        object3 = this.initialToModelTimeForBoundaryCondition(this.project.getPollutantInitialBoundary());
        int n24 = this.project.getPollutantInitialBoundary().getSystemState() == InitialBoundaryCondition.Equilibrium.EQUILIBRIUM ? 1 : -1;
        for (int i = 0; i < this.project.allPollutants().size(); ++i) {
            String string52 = var60_136.concat(" 11 1.e0\n");
            for (int j = 0; j < n6; ++j) {
                void var60_138;
                String string53 = var60_138.concat((double)Math.round((double)n24 * object3[j][i] * 100000.0) / 100000.0 + "\n");
            }
        }
        String string54 = "__INFLOW_CONCENTRATIONS\n";
        string54 = string54.concat("__SURFACTANTS\n");
        if (this.project.allSurfactants() != null && this.project.allSurfactants().size() > 0) {
            double[][] dArray = this.inflowToModelTimeForBoundaryCondition(this.project.getSurfactantUpperBoundary());
            for (n2 = 0; n2 < this.project.allSurfactants().size(); ++n2) {
                string54 = string54.concat("" + n7 + "\n");
                for (n = 0; n < n7; ++n) {
                    string54 = string54.concat("" + (n + 1) + " " + (n + 1) + " " + dArray[n][n2] + "\n");
                }
            }
        }
        string54 = string54.concat("__CONTAMINANTS\n");
        double[][] dArray = this.inflowToModelTimeForBoundaryCondition(this.project.getPollutantUpperBoundary());
        for (n2 = 0; n2 < this.project.allPollutants().size(); ++n2) {
            string54 = string54.concat("" + n7 + "\n");
            for (n = 0; n < n7; ++n) {
                string54 = string54.concat("" + (n + 1) + " " + (n + 1) + " " + dArray[n][n2] + "\n");
            }
        }
        String string55 = "__BIO_REDUCTION\n";
        for (CatalogObject catalogObject : this.project.allPollutants()) {
            string55 = string55.concat("11 1 1. 1. 1.\n");
            String string56 = "";
            for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
                int n25;
                BioDegradationValue.DegradationMode degradationMode = this.project.getBioDegredationValueForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer).getMode();
                double[] dArray2 = new double[]{degradationMode == BioDegradationValue.DegradationMode.NO_DEGRADATION ? 0.0 : (degradationMode == BioDegradationValue.DegradationMode.DEGRADATION_OF_NTH_ORDER ? 1.0 : (degradationMode == BioDegradationValue.DegradationMode.LH_KINETICS ? 2.0 : 0.0)), this.project.getBioDegredationValueForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer).getHalfLifeTime(), this.project.getBioDegredationValueForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer).getOrder(), this.project.getBioDegredationValueForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer).getReferenceConcentration()};
                if (dArray2 != null) {
                    string56 = string56.concat(" " + (int)dArray2[0]);
                    for (n25 = 1; n25 < dArray2.length; ++n25) {
                        string56 = string56.concat(" " + dArray2[n25]);
                    }
                }
                for (n25 = 0; n25 < secondaryLayer.getNumModellzellen(); ++n25) {
                    string55 = string55.concat(string56 + "\n");
                }
                string56 = "";
            }
        }
        Object object11 = "__ISOTHERM_DEFINITIONS\n";
        object11 = ((String)object11).concat("__SORPTION_ONTO_MINERALSURFACES");
        boolean bl3 = false;
        int n26 = 0;
        for (CatalogObject catalogObject : this.project.usedAquiferMaterials()) {
            void var68_165;
            ++var68_165;
            for (CatalogObject catalogObject3 : this.project.allPollutants()) {
                SorptionValue sorptionValue = this.project.getSorptionValueForPollutantAndAquiferMaterial((Pollutant)catalogObject3, (AquiferMaterial)catalogObject);
                object11 = ((String)object11).concat("\n" + (int)var68_165 + " " + ++n26 + " " + sorptionValue.getIsothermType().getIndex() + "\n");
                object11 = ((String)object11).concat(sorptionValue.getParameter1() + " " + sorptionValue.getParameter2() + " " + sorptionValue.getParameter3());
            }
            n26 = 0;
        }
        Object object12 = "\n__SOLUTION_WITHIN_MICELLES";
        boolean bl4 = false;
        n26 = 0;
        for (CatalogObject catalogObject : this.project.allSurfactants()) {
            void var68_167;
            ++var68_167;
            for (CatalogObject catalogObject4 : this.project.allPollutants()) {
                object2 = this.project.getSolubilizationValuesForPolutantAndSurfactant((Pollutant)catalogObject4, (Surfactant)catalogObject);
                object12 = ((String)object12).concat("\n" + (int)var68_167 + " " + ++n26 + " " + Double.valueOf((double)object2[1]).intValue() + "\n" + (double)object2[2] + " " + (double)object2[3] + " " + (double)object2[4]);
            }
            n26 = 0;
        }
        String string57 = "\n__SORPTION_ONTO_MONOMERELAYERS";
        boolean bl5 = false;
        n26 = 0;
        for (CatalogObject catalogObject : this.project.allSurfactants()) {
            void var68_169;
            ++var68_169;
            Iterator<Pollutant> iterator = this.project.allPollutants().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = this.project.getAdsolubilizationValuesForPolutantAndSurfactant((Pollutant)object2, (Surfactant)catalogObject);
                String string58 = var71_184.concat("\n" + (int)var68_169 + " " + ++n26 + " " + Double.valueOf(object[1]).intValue() + "\n" + object[2] + " " + object[3] + " " + object[4]);
            }
            n26 = 0;
        }
        String string59 = "\n__MONOMERELAYER_FORMATION";
        boolean bl6 = false;
        n26 = 0;
        for (CatalogObject catalogObject : this.project.usedAquiferMaterials()) {
            void var68_171;
            ++var68_171;
            object2 = this.project.allSurfactants().iterator();
            while (object2.hasNext()) {
                object = (CatalogObject)object2.next();
                double[] dArray3 = this.project.getMonomereLayerValuesForSurfactantAndAquiferMaterial((Surfactant)object, (AquiferMaterial)catalogObject);
                String string60 = var72_193.concat("\n" + (int)var68_171 + " " + ++n26 + " " + Double.valueOf(dArray3[1]).intValue() + "\n" + dArray3[2] + " " + dArray3[3] + " " + dArray3[4]);
            }
            n26 = 0;
        }
        String string62 = "\n__OUTPUT_DEFINITIONS\n";
        string62 = string62.concat("__LOCATIONS_OF_BTCS\n");
        if (n12 == 0) {
            String string63 = string62.concat("0\n");
        } else {
            void var68_173;
            boolean bl7 = false;
            while (var68_173 < this.project.getBtcValues().length) {
                void var73_206;
                String string64 = var73_206.concat("" + this.project.getBtcValues()[var68_173] + "\n");
                ++var68_173;
            }
        }
        String string65 = var73_208.concat("__TIMES_OF_PROFILES\n");
        if (n13 == 0) {
            String string66 = string65.concat("0\n");
        } else {
            void var68_175;
            boolean bl8 = false;
            while (var68_175 < this.project.getProfileValues().length) {
                void var73_211;
                String string67 = var73_211.concat("" + this.project.getProfileValues()[var68_175] + "\n");
                ++var68_175;
            }
        }
        String string69 = var73_213.concat("__FORMAT_OF_OUTPUT\n");
        string69 = string69.concat(this.project.getFurtherModelParameters().getFormatBTCAndProfileOutput().toString() + "\n");
        String string73 = new String("");
        string73 = string73.concat(string);
        string73 = string73.concat(string2);
        string73 = string73.concat(string3);
        if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
            String string74 = string73.concat(string4);
        }
        String string100 = var74_227.concat((String)object13);
        string100 = string100.concat(string38);
        string100 = string100.concat((String)var14_20);
        string100 = string100.concat(string8);
        string100 = string100.concat(string9);
        string100 = string100.concat(string11);
        string100 = string100.concat((String)var23_63);
        string100 = string100.concat((String)object5);
        string100 = string100.concat((String)object6);
        string100 = string100.concat(string39);
        string100 = string100.concat((String)object7);
        string100 = string100.concat((String)object4);
        string100 = string100.concat(string40);
        string100 = string100.concat(string41);
        string100 = string100.concat((String)object8);
        string100 = string100.concat((String)var55_107);
        string100 = string100.concat((String)object9);
        string100 = string100.concat((String)object10);
        string100 = string100.concat((String)var60_136);
        string100 = string100.concat(string54);
        string100 = string100.concat(string55);
        string100 = string100.concat((String)object11);
        string100 = string100.concat((String)var71_184);
        string100 = string100.concat((String)object12);
        string100 = string100.concat((String)var72_193);
        string100 = string100.concat(string69);
        object2 = null;
        try {
            object2 = new BufferedWriter(new FileWriter(this.inputFile));
            ((Writer)object2).write(string100);
            ((BufferedWriter)object2).flush();
        }
        catch (IOException iOException) {
        }
        finally {
            Transformer.closeFileWriter((BufferedWriter)object2);
        }
    }

    private static void closeFileWriter(BufferedWriter bufferedWriter) {
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private double[][] inflowToModelTimeForBoundaryCondition(BoundaryCondition boundaryCondition) {
        int n;
        int n2 = this.project.getTimesteps().numberOfTimesteps();
        int n3 = this.project.getTimesteps().sumOfTimestepCounts();
        float[] fArray = new float[n3];
        int n4 = 0;
        float f = 0.0f;
        for (int i = 0; i < n2; ++i) {
            n = this.project.getTimesteps().getTimeStepCountForTimestepAtIndex(i);
            float f2 = (float)this.project.getTimesteps().getTimeStepLengthForTimestepAtIndexInSeconds(i);
            for (int j = 0; j < n; ++j) {
                fArray[n4] = (float)(j + 1) * f2 + f;
                ++n4;
            }
            f = fArray[n4 - 1];
        }
        double[][] dArray = new double[n3][boundaryCondition.getObjectCount()];
        for (n = 0; n < fArray.length; ++n) {
            double d = n == 0 ? (double)(fArray[n] / 2.0f) : (double)((fArray[n] - fArray[n - 1]) / 2.0f);
            dArray[n] = boundaryCondition.getAllValuesForTimestamp2((double)fArray[n] - d);
        }
        return dArray;
    }

    private double[][] initialToModelTimeForBoundaryCondition(BoundaryCondition boundaryCondition) {
        int n = 0;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            n += secondaryLayer.getNumModellzellen();
        }
        Object object = new double[n];
        int n2 = 0;
        Object object2 = 0.0;
        for (SecondaryLayer secondaryLayer : this.project.getLeaves()) {
            int n3 = secondaryLayer.getNumModellzellen();
            double d = secondaryLayer.getXUK() - secondaryLayer.getXOK();
            double d2 = d / (double)n3;
            for (int i = 0; i < n3; ++i) {
                object[n2] = (double)Math.round(((double)(i + 1) * d2 + object2) * 100000.0) / 100000.0;
                ++n2;
            }
            object2 = object[n2 - 1];
        }
        Object object3 = new double[((Object)object).length][boundaryCondition.getObjectCount()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            reference var9_11 = i == 0 ? object[i] / 2.0 : (object[i] - object[i - 1]) / 2.0;
            reference var11_15 = object[i] - var9_11;
            object3[i] = boundaryCondition.getAllValuesForTimestamp2((double)var11_15);
        }
        return object3;
    }
}

