/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.data.GrainSize;
import de.dsite.data.Series;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.project.Material;
import de.dsite.project.VersionedProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.jfree.data.xy.XYSeries;

public class SeriesCollector {
    private Set<Series> setOfSeries = new TreeSet<Series>();

    public Set<Series> getBTCSeriesForPollutant(Pollutant pollutant, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCMeasForPollutant(Pollutant pollutant, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCSeriesForSurfactant(Surfactant surfactant, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypeSurfactant() || (Surfactant)series.getCatalogObject() != surfactant || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCMeasForSurfactant(Surfactant surfactant, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypeSurfactant() || (Surfactant)series.getCatalogObject() != surfactant || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCPollutantsSeriesForObservationValue(double d, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCPollutantsMeasForObservationValue(double d, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCSurfactantsSeriesForObservationValue(double d, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || series.getObservationValue() != d || !series.isCatalogObjectOfTypeSurfactant() || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getBTCSurfactantsMeasForObservationValue(double d, Series.Unit unit) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeBTC() || series.getObservationValue() != d || !series.isCatalogObjectOfTypeSurfactant() || !series.getUnit().equals((Object)unit) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXSeriesForPollutantAndProfile(Pollutant pollutant, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXMeasForPollutantAndProfile(Pollutant pollutant, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXSeriesForSurfactantAndProfile(Surfactant surfactant, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypeSurfactant() || (Surfactant)series.getCatalogObject() != surfactant || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXSeriesForPollutantAndAllProfiles(Pollutant pollutant) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        Iterator<Series> iterator = this.setOfSeries.iterator();
        if (this.containsSurfactant()) {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || series.getProfileType().equals((Object)Series.ProfileType.NONE) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
                treeSet.add(series);
            }
        } else {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && !series.getProfileType().equals((Object)Series.ProfileType.SORB) && (!series.getProfileType().equals((Object)Series.ProfileType.DIFF) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN))) continue;
                treeSet.add(series);
            }
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXMeasForPollutantAndAllProfiles(Pollutant pollutant) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        Iterator<Series> iterator = this.setOfSeries.iterator();
        if (this.containsSurfactant()) {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || series.getProfileType().equals((Object)Series.ProfileType.NONE) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
                treeSet.add(series);
            }
        } else {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || (Pollutant)series.getCatalogObject() != pollutant || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && !series.getProfileType().equals((Object)Series.ProfileType.SORB) && (!series.getProfileType().equals((Object)Series.ProfileType.DIFF) || !series.getOrigin().equals((Object)Series.OriginType.MEAS))) continue;
                treeSet.add(series);
            }
        }
        return treeSet;
    }

    public Set<Series> getProfileXXXSeriesForSurfactantAndAllProfiles(Surfactant surfactant) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypeSurfactant() || (Surfactant)series.getCatalogObject() != surfactant || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && (!series.getProfileType().equals((Object)Series.ProfileType.SORB) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN))) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfilePollutantsXXXSeriesForValueAndAllProfiles(double d) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        Iterator<Series> iterator = this.setOfSeries.iterator();
        if (this.containsSurfactant()) {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || series.getProfileType().equals((Object)Series.ProfileType.NONE) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
                treeSet.add(series);
            }
        } else {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && !series.getProfileType().equals((Object)Series.ProfileType.SORB) && (!series.getProfileType().equals((Object)Series.ProfileType.DIFF) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN))) continue;
                treeSet.add(series);
            }
        }
        return treeSet;
    }

    public Set<Series> getProfilePollutantsXXXMeasForValueAndAllProfiles(double d) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        Iterator<Series> iterator = this.setOfSeries.iterator();
        if (this.containsSurfactant()) {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || series.getProfileType().equals((Object)Series.ProfileType.NONE) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
                treeSet.add(series);
            }
        } else {
            while (iterator.hasNext()) {
                Series series = iterator.next();
                if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && !series.getProfileType().equals((Object)Series.ProfileType.SORB) && (!series.getProfileType().equals((Object)Series.ProfileType.DIFF) || !series.getOrigin().equals((Object)Series.OriginType.MEAS))) continue;
                treeSet.add(series);
            }
        }
        return treeSet;
    }

    public Set<Series> getProfileSurfactantsXXXSeriesForValueAndAllProfiles(double d) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypeSurfactant() || !series.getProfileType().equals((Object)Series.ProfileType.DISS) && (!series.getProfileType().equals((Object)Series.ProfileType.SORB) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN))) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfilePollutantsXXXSeriesForValueAndProfile(double d, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfilePollutantsXXXMeasForValueAndProfile(double d, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypePollutant() || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public Set<Series> getProfileSurfactantsXXXSeriesForValueAndProfile(double d, Series.ProfileType profileType) {
        TreeSet<Series> treeSet = new TreeSet<Series>();
        for (Series series : this.setOfSeries) {
            if (!series.isFileTypeProfile() || series.getObservationValue() != d || !series.isCatalogObjectOfTypeSurfactant() || !series.getProfileType().equals((Object)profileType) || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) continue;
            treeSet.add(series);
        }
        return treeSet;
    }

    public double getMaximumValueForPollutantBTCSeries() {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypePollutant() || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    public double getMaximumValueForSurfactantBTCSeries() {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeBTC() || !series.isCatalogObjectOfTypeSurfactant() || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    public double getMaximumValueForPollutantProfileSeries() {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    public double getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType profileType) {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypePollutant() || series.getProfileType() != profileType || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    public double getMaximumValueForSurfactantProfileSeries() {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypeSurfactant() || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    public double getMaximumValueForSurfactantProfileSeriesOfProfileType(Series.ProfileType profileType) {
        Iterator<Series> iterator = this.setOfSeries.iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Series series = iterator.next();
            if (!series.isFileTypeProfile() || !series.isCatalogObjectOfTypeSurfactant() || series.getProfileType() != profileType || !series.getOrigin().equals((Object)Series.OriginType.FORTRAN) || !(series.getXYSeries().getMaxY() > d)) continue;
            d = series.getXYSeries().getMaxY();
        }
        return d;
    }

    private Object[] parmetersForBTCSeries(int n, ArrayList<CatalogObject> arrayList, double d) {
        if (n > arrayList.size()) {
            return null;
        }
        CatalogObject catalogObject = arrayList.get(n - 1);
        String string = Character.toUpperCase(catalogObject.getBezeichnung().charAt(0)) + catalogObject.getBezeichnung().substring(1, catalogObject.getBezeichnung().length());
        String string2 = new String(string + " x = " + d);
        return new Object[]{string2, catalogObject};
    }

    private Object[] parmetersForPROFILESeries(int n, ArrayList<CatalogObject> arrayList, double d, int n2, int n3) {
        CatalogObject catalogObject;
        if (n > n2 * 5 + n3 * 2) {
            return null;
        }
        String string = "";
        Series.ProfileType profileType = Series.ProfileType.NONE;
        if (n <= n2 * 5) {
            int n4 = (int)Math.ceil((n - 1) / 5);
            catalogObject = arrayList.get(n4);
            String string2 = Character.toUpperCase(catalogObject.getBezeichnung().charAt(0)) + catalogObject.getBezeichnung().substring(1, catalogObject.getBezeichnung().length());
            string = new String(string2 + " t = " + d);
            if (n % 5 == 1) {
                profileType = Series.ProfileType.DISS;
            } else if (n % 5 == 2) {
                profileType = Series.ProfileType.MIC;
            } else if (n % 5 == 3) {
                profileType = Series.ProfileType.SORB;
            } else if (n % 5 == 4) {
                profileType = Series.ProfileType.DIFF;
            } else if (n % 5 == 0) {
                profileType = Series.ProfileType.MONO;
            }
        } else {
            int n5 = n - 5 * n2;
            int n6 = (int)Math.ceil((double)n5 / 2.0);
            catalogObject = arrayList.get(n2 + n6 - 1);
            String string3 = Character.toUpperCase(catalogObject.getBezeichnung().charAt(0)) + catalogObject.getBezeichnung().substring(1, catalogObject.getBezeichnung().length());
            string = new String(string3 + " t = " + d);
            if (n5 % 2 == 1) {
                profileType = Series.ProfileType.DISS;
            } else if (n5 % 2 == 0) {
                profileType = Series.ProfileType.SORB;
            }
        }
        return new Object[]{string, catalogObject, profileType};
    }

    public void parseFile(File file, ArrayList<CatalogObject> arrayList, double d, Series.FileType fileType) {
        Object object;
        Object[] objectArray;
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            objectArray = null;
            while ((objectArray = bufferedReader.readLine()) != null) {
                objectArray = objectArray.trim();
                object = objectArray.split("\\s+", 0);
                arrayList2.add((String[])object);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Verarbeitung der Fortran Ausgabedatei " + file.getName() + " fehlgeschlagen!", "Fehler", 0);
            return;
        }
        if (arrayList2.size() > 0) {
            int n = ((String[])arrayList2.get(0)).length - 1;
            switch (fileType) {
                case BTC: {
                    for (int i = 1; i <= n; ++i) {
                        Object object22;
                        objectArray = this.parmetersForBTCSeries(i, arrayList, d);
                        if (objectArray == null) continue;
                        object = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        XYSeries xYSeries4 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        XYSeries xYSeries5 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                        int n2 = 3600;
                        int n3 = n2 * 24;
                        int n4 = n3 * 30;
                        int n5 = n4 * 12;
                        for (Object object22 : arrayList2) {
                            ((XYSeries)object).add(Double.parseDouble(object22[0]), Double.parseDouble(object22[i]));
                            xYSeries.add(Double.parseDouble(object22[0]) / 60.0, Double.parseDouble(object22[i]));
                            xYSeries2.add(Double.parseDouble(object22[0]) / (double)n2, Double.parseDouble(object22[i]));
                            xYSeries3.add(Double.parseDouble(object22[0]) / (double)n3, Double.parseDouble(object22[i]));
                            xYSeries4.add(Double.parseDouble(object22[0]) / (double)n4, Double.parseDouble(object22[i]));
                            xYSeries5.add(Double.parseDouble(object22[0]) / (double)n5, Double.parseDouble(object22[i]));
                        }
                        Series series = new Series((CatalogObject)objectArray[1], d, (XYSeries)object, Series.FileType.BTC, Series.Unit.SEC);
                        object22 = new Series((CatalogObject)objectArray[1], d, xYSeries, Series.FileType.BTC, Series.Unit.MIN);
                        Series series2 = new Series((CatalogObject)objectArray[1], d, xYSeries2, Series.FileType.BTC, Series.Unit.HOUR);
                        Series series3 = new Series((CatalogObject)objectArray[1], d, xYSeries3, Series.FileType.BTC, Series.Unit.DAY);
                        Series series4 = new Series((CatalogObject)objectArray[1], d, xYSeries4, Series.FileType.BTC, Series.Unit.MONTH);
                        Series series5 = new Series((CatalogObject)objectArray[1], d, xYSeries5, Series.FileType.BTC, Series.Unit.YEAR);
                        this.setOfSeries.add(series);
                        this.setOfSeries.add((Series)object22);
                        this.setOfSeries.add(series2);
                        this.setOfSeries.add(series3);
                        this.setOfSeries.add(series4);
                        this.setOfSeries.add(series5);
                    }
                    break;
                }
                case PROFILE: {
                    int n6 = 0;
                    int n7 = 0;
                    for (CatalogObject objectArray2 : arrayList) {
                        if (objectArray2 instanceof Pollutant) {
                            ++n6;
                            continue;
                        }
                        if (!(objectArray2 instanceof Surfactant)) continue;
                        ++n7;
                    }
                    for (int i = 1; i <= n; ++i) {
                        Object[] objectArray2 = this.parmetersForPROFILESeries(i, arrayList, d, n6, n7);
                        if (objectArray2 == null) continue;
                        XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        for (String[] stringArray : arrayList2) {
                            xYSeries.add(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[i]));
                        }
                        Series series = new Series((CatalogObject)objectArray2[1], d, xYSeries, Series.FileType.PROFILE, (Series.ProfileType)((Object)objectArray2[2]));
                        this.setOfSeries.add(series);
                    }
                    break;
                }
            }
        }
    }

    public void parseFileAndComputeLS(File file, ArrayList<CatalogObject> arrayList, double d, Series.FileType fileType, VersionedProject versionedProject) {
        Object object;
        Object[] objectArray;
        Object object2;
        Object object3;
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        try {
            FileReader fileReader = new FileReader(file);
            object3 = new BufferedReader(fileReader);
            object2 = null;
            while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                object2 = ((String)object2).trim();
                objectArray = ((String)object2).split("\\s+", 0);
                arrayList2.add((String[])objectArray);
            }
            ((BufferedReader)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Verarbeitung der Fortran Ausgabedatei " + file.getName() + " fehlgeschlagen!", "Fehler", 0);
            return;
        }
        int n = versionedProject.getLeaves().size();
        object3 = new double[n];
        object2 = new double[n];
        objectArray = new double[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = (String)0.0;
            object2[i] = versionedProject.getLeaves().get(i).getHydraulic().getValues()[1];
            Material material = versionedProject.getLeaves().get(i).getMaterial();
            object = material.getAquiferMaterials().iterator();
            while (object.hasNext()) {
                AquiferMaterial aquiferMaterial = (AquiferMaterial)object.next();
                double d2 = aquiferMaterial.getValues()[2];
                double d3 = 0.0;
                for (GrainSize grainSize : material.getGrainSizes()) {
                    d3 += material.getMassFractionValue(aquiferMaterial, grainSize) * material.getTotalFractionForGrainSize(grainSize) / 10000.0;
                }
                objectArray[i] = objectArray[i] + d3 / d2;
                System.out.println("grain sizes = " + i + " = " + material.getGrainSizes());
                System.out.println("p_s = " + i + " = " + d2);
                System.out.println("mass = " + i + " = " + d3);
            }
            object3[i] = (1.0 - object2[i]) / objectArray[i];
            System.out.println("p_b = " + i + " = " + (double)object3[i] + ", por_i = " + (double)object2[i]);
        }
        double d4 = 0.0;
        object = new double[n];
        for (int i = 0; i < n; ++i) {
            object[i] = versionedProject.getLeaves().get(i).getXUK() - versionedProject.getLeaves().get(i).getXOK();
            d4 += object[i] * object3[i];
        }
        double d5 = versionedProject.getCrossSection() * d4;
        double d6 = 0.0;
        if (versionedProject.isZustrom()) {
            d6 = versionedProject.getBcFlowValueTop();
        } else if (versionedProject.isAbstrom()) {
            d6 = versionedProject.getBcFlowValueBottom();
        } else if (!versionedProject.isAbstrom() && !versionedProject.isZustrom()) {
            double d7 = 0.0;
            for (int i = 0; i < versionedProject.getLeaves().size(); ++i) {
                double d8 = versionedProject.getLeaves().get(i).getXUK() - versionedProject.getLeaves().get(i).getXOK();
                double d9 = versionedProject.getLeaves().get(i).getHydraulic().getValues()[0];
                d7 += d8 / d9;
            }
            d6 = (versionedProject.getBcFlowValueTop() - versionedProject.getBcFlowValueBottom()) / d7 * versionedProject.getCrossSection();
        }
        System.out.println("M = " + d5);
        System.out.println("Q = " + (d6 *= 1000.0));
        if (arrayList2.size() > 0) {
            int n2 = ((String[])arrayList2.get(0)).length - 1;
            switch (fileType) {
                case BTC: {
                    for (int i = 1; i <= n2; ++i) {
                        Object object42;
                        Object[] objectArray2 = this.parmetersForBTCSeries(i, arrayList, d);
                        if (objectArray2 == null) continue;
                        XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries3 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries4 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries5 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries6 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries7 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries8 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries9 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries10 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries11 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries12 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries13 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        XYSeries xYSeries14 = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        int n3 = 3600;
                        int n4 = n3 * 24;
                        int n5 = n4 * 30;
                        int n6 = n5 * 12;
                        int n7 = 0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        for (Object object42 : arrayList2) {
                            double d7 = Double.parseDouble(object42[0]);
                            double d8 = Double.parseDouble(object42[i]);
                            double d9 = d6 * d7 / d5;
                            xYSeries.add(d7, d8);
                            xYSeries2.add(d7 / 60.0, d8);
                            xYSeries3.add(d7 / (double)n3, d8);
                            xYSeries4.add(d7 / (double)n4, d8);
                            xYSeries5.add(d7 / (double)n5, d8);
                            xYSeries6.add(d7 / (double)n6, d8);
                            xYSeries7.add(d9, d8);
                            double d10 = n7 > 0 ? d7 - Double.parseDouble(((String[])arrayList2.get(n7 - 1))[0]) : d7;
                            double d11 = d6 * d10;
                            double d12 = d8 * d11;
                            double d13 = (d3 += d12) / (d2 += d11);
                            xYSeries8.add(d7, d13);
                            xYSeries9.add(d7 / 60.0, d13);
                            xYSeries10.add(d7 / (double)n3, d13);
                            xYSeries11.add(d7 / (double)n4, d13);
                            xYSeries12.add(d7 / (double)n5, d13);
                            xYSeries13.add(d7 / (double)n6, d13);
                            xYSeries14.add(d9, d13);
                            ++n7;
                        }
                        Series series = new Series((CatalogObject)objectArray2[1], d, xYSeries, Series.FileType.BTC, Series.Unit.SEC);
                        object42 = new Series((CatalogObject)objectArray2[1], d, xYSeries2, Series.FileType.BTC, Series.Unit.MIN);
                        Series series2 = new Series((CatalogObject)objectArray2[1], d, xYSeries3, Series.FileType.BTC, Series.Unit.HOUR);
                        Series series3 = new Series((CatalogObject)objectArray2[1], d, xYSeries4, Series.FileType.BTC, Series.Unit.DAY);
                        Series series4 = new Series((CatalogObject)objectArray2[1], d, xYSeries5, Series.FileType.BTC, Series.Unit.MONTH);
                        Series series5 = new Series((CatalogObject)objectArray2[1], d, xYSeries6, Series.FileType.BTC, Series.Unit.YEAR);
                        Series series6 = new Series((CatalogObject)objectArray2[1], d, xYSeries7, Series.FileType.BTC, Series.Unit.LS);
                        Series series7 = new Series((CatalogObject)objectArray2[1], d, xYSeries8, Series.FileType.AAC, Series.Unit.SEC);
                        Series series8 = new Series((CatalogObject)objectArray2[1], d, xYSeries9, Series.FileType.AAC, Series.Unit.MIN);
                        Series series9 = new Series((CatalogObject)objectArray2[1], d, xYSeries10, Series.FileType.AAC, Series.Unit.HOUR);
                        Series series10 = new Series((CatalogObject)objectArray2[1], d, xYSeries11, Series.FileType.AAC, Series.Unit.DAY);
                        Series series11 = new Series((CatalogObject)objectArray2[1], d, xYSeries12, Series.FileType.AAC, Series.Unit.MONTH);
                        Series series12 = new Series((CatalogObject)objectArray2[1], d, xYSeries13, Series.FileType.AAC, Series.Unit.YEAR);
                        Series series13 = new Series((CatalogObject)objectArray2[1], d, xYSeries14, Series.FileType.AAC, Series.Unit.LS);
                        this.setOfSeries.add(series);
                        this.setOfSeries.add((Series)object42);
                        this.setOfSeries.add(series2);
                        this.setOfSeries.add(series3);
                        this.setOfSeries.add(series4);
                        this.setOfSeries.add(series5);
                        this.setOfSeries.add(series6);
                        this.setOfSeries.add(series7);
                        this.setOfSeries.add(series8);
                        this.setOfSeries.add(series9);
                        this.setOfSeries.add(series10);
                        this.setOfSeries.add(series11);
                        this.setOfSeries.add(series12);
                        this.setOfSeries.add(series13);
                    }
                    break;
                }
                case PROFILE: {
                    int n8 = 0;
                    int n9 = 0;
                    for (CatalogObject objectArray3 : arrayList) {
                        if (objectArray3 instanceof Pollutant) {
                            ++n8;
                            continue;
                        }
                        if (!(objectArray3 instanceof Surfactant)) continue;
                        ++n9;
                    }
                    for (int i = 1; i <= n2; ++i) {
                        Object[] objectArray2 = this.parmetersForPROFILESeries(i, arrayList, d, n8, n9);
                        if (objectArray2 == null) continue;
                        XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray2[0])));
                        for (String[] stringArray : arrayList2) {
                            xYSeries.add(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[i]));
                        }
                        Series series = new Series((CatalogObject)objectArray2[1], d, xYSeries, Series.FileType.PROFILE, (Series.ProfileType)((Object)objectArray2[2]));
                        this.setOfSeries.add(series);
                    }
                    break;
                }
            }
        }
    }

    public void generateEmptyMeasSeries(ArrayList<CatalogObject> arrayList, double d, Series.FileType fileType) {
        String[] stringArray;
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        if (fileType.equals((Object)Series.FileType.BTC)) {
            stringArray = new String[arrayList.size() + 1];
            stringArray[0] = "0.0";
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i + 1] = "nn";
            }
        } else {
            int n = 0;
            int n2 = 0;
            for (CatalogObject catalogObject : arrayList) {
                if (catalogObject instanceof Pollutant) {
                    ++n;
                    continue;
                }
                if (!(catalogObject instanceof Surfactant)) continue;
                ++n2;
            }
            int n3 = n * 5 + n2 * 2;
            stringArray = new String[n3 + 1];
            stringArray[0] = "0.0";
            for (int i = 0; i < n3; ++i) {
                stringArray[i + 1] = "nn";
            }
        }
        arrayList2.add(stringArray);
        this.convertMeasFileValuesToSeries(arrayList2, arrayList, d, fileType);
    }

    public void parseMeasFile(File file, ArrayList<CatalogObject> arrayList, double d, Series.FileType fileType) {
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                String[] stringArray = string.split("\\s+", 0);
                arrayList2.add(stringArray);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, "Verarbeitung der Messwerte-Datei " + file.getName() + " fehlgeschlagen!", "Fehler", 0);
            return;
        }
        if (arrayList2.size() > 0) {
            this.convertMeasFileValuesToSeries(arrayList2, arrayList, d, fileType);
        }
    }

    private void convertMeasFileValuesToSeries(ArrayList<String[]> arrayList, ArrayList<CatalogObject> arrayList2, double d, Series.FileType fileType) {
        int n = arrayList.get(0).length - 1;
        switch (fileType) {
            case BTC: {
                for (int i = 1; i <= n; ++i) {
                    Object object2;
                    Object[] objectArray = this.parmetersForBTCSeries(i, arrayList2, d);
                    if (objectArray == null) continue;
                    XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    XYSeries xYSeries2 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    XYSeries xYSeries3 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    XYSeries xYSeries4 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    XYSeries xYSeries5 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    XYSeries xYSeries6 = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    int n2 = 3600;
                    int n3 = n2 * 24;
                    int n4 = n3 * 30;
                    int n5 = n4 * 12;
                    for (Object object2 : arrayList) {
                        if (object2[i].equals("nn")) continue;
                        xYSeries.add(Double.parseDouble(object2[0]), Double.parseDouble(object2[i]));
                        xYSeries2.add(Double.parseDouble(object2[0]) / 60.0, Double.parseDouble(object2[i]));
                        xYSeries3.add(Double.parseDouble(object2[0]) / (double)n2, Double.parseDouble(object2[i]));
                        xYSeries4.add(Double.parseDouble(object2[0]) / (double)n3, Double.parseDouble(object2[i]));
                        xYSeries5.add(Double.parseDouble(object2[0]) / (double)n4, Double.parseDouble(object2[i]));
                        xYSeries6.add(Double.parseDouble(object2[0]) / (double)n5, Double.parseDouble(object2[i]));
                    }
                    Series series = new Series((CatalogObject)objectArray[1], d, xYSeries, Series.FileType.BTC, Series.Unit.SEC, Series.OriginType.MEAS);
                    object2 = new Series((CatalogObject)objectArray[1], d, xYSeries2, Series.FileType.BTC, Series.Unit.MIN, Series.OriginType.MEAS);
                    Series series2 = new Series((CatalogObject)objectArray[1], d, xYSeries3, Series.FileType.BTC, Series.Unit.HOUR, Series.OriginType.MEAS);
                    Series series3 = new Series((CatalogObject)objectArray[1], d, xYSeries4, Series.FileType.BTC, Series.Unit.DAY, Series.OriginType.MEAS);
                    Series series4 = new Series((CatalogObject)objectArray[1], d, xYSeries5, Series.FileType.BTC, Series.Unit.MONTH, Series.OriginType.MEAS);
                    Series series5 = new Series((CatalogObject)objectArray[1], d, xYSeries6, Series.FileType.BTC, Series.Unit.YEAR, Series.OriginType.MEAS);
                    this.setOfSeries.add(series);
                    this.setOfSeries.add((Series)object2);
                    this.setOfSeries.add(series2);
                    this.setOfSeries.add(series3);
                    this.setOfSeries.add(series4);
                    this.setOfSeries.add(series5);
                }
                break;
            }
            case PROFILE: {
                int n6 = 0;
                int n7 = 0;
                for (CatalogObject objectArray : arrayList2) {
                    if (objectArray instanceof Pollutant) {
                        ++n6;
                        continue;
                    }
                    if (!(objectArray instanceof Surfactant)) continue;
                    ++n7;
                }
                for (int i = 1; i <= n; ++i) {
                    Object[] objectArray = this.parmetersForPROFILESeries(i, arrayList2, d, n6, n7);
                    if (objectArray == null) continue;
                    XYSeries xYSeries = new XYSeries((Comparable)((Object)((String)objectArray[0])));
                    for (String[] stringArray : arrayList) {
                        if (stringArray[i].equals("nn")) continue;
                        xYSeries.add(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[i]));
                    }
                    Series series = new Series((CatalogObject)objectArray[1], d, xYSeries, Series.FileType.PROFILE, (Series.ProfileType)((Object)objectArray[2]), Series.OriginType.MEAS);
                    this.setOfSeries.add(series);
                }
                break;
            }
        }
    }

    public boolean containsSurfactant() {
        for (Series series : this.setOfSeries) {
            if (!series.isCatalogObjectOfTypeSurfactant()) continue;
            return true;
        }
        return false;
    }
}

