/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.data.catalog.CatalogObject;
import de.dsite.project.VersionedProject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ResultParser {
    private XYSeriesCollection dataset;
    private HashMap<String, XYSeries> setOfSeries = new HashMap();

    public ResultParser() {
        this.setDataset(new XYSeriesCollection());
    }

    public XYSeriesCollection getXYSeriesCollection(ArrayList<String> arrayList) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (String string : arrayList) {
            if (!this.setOfSeries.containsKey(string)) continue;
            xYSeriesCollection.addSeries(this.setOfSeries.get(string));
        }
        return xYSeriesCollection;
    }

    public XYSeriesCollection getXYSeriesCollectionBTCForPollutant(CatalogObject catalogObject, VersionedProject versionedProject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < versionedProject.getBtcValues().length + 1; ++i) {
            String string = " x=" + versionedProject.getLeaves().get(versionedProject.getLeaves().size() - 1).getXUK();
            if (i > 0) {
                string = " x=" + versionedProject.getBtcValues()[i - 1];
            }
            arrayList.add(catalogObject.getBezeichnung() + string);
        }
        return this.getXYSeriesCollection(arrayList);
    }

    public boolean parseFile(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                String[] stringArray = string.split("\\s+", 0);
                arrayList.add(stringArray);
            }
            int n = ((String[])arrayList.get(0)).length - 1;
            for (int i = 1; i <= n; ++i) {
                String string2 = new String("Datensatz " + i);
                XYSeries xYSeries = new XYSeries((Comparable)((Object)string2));
                for (String[] stringArray : arrayList) {
                    xYSeries.add(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[i]));
                }
                this.getDataset().addSeries(xYSeries);
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Fehlerhafte Eingaben!\nBerechnung kann nicht durchgefuehrt werden!", "Fehler", 0);
            return false;
        }
    }

    public boolean parseBTCFile(File file, ArrayList<CatalogObject> arrayList, String string) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                String[] stringArray = string2.split("\\s+", 0);
                arrayList2.add(stringArray);
            }
            int n = ((String[])arrayList2.get(0)).length - 1;
            for (int i = 1; i <= n; ++i) {
                Object object;
                String string3 = "";
                if (i <= arrayList.size()) {
                    object = arrayList.get(i - 1).getBezeichnung();
                    String string4 = Character.toUpperCase(((String)object).charAt(0)) + ((String)object).substring(1, ((String)object).length());
                    string3 = new String((String)string4 + string);
                }
                object = new XYSeries((Comparable)((Object)string3));
                for (String[] stringArray : arrayList2) {
                    ((XYSeries)object).add(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[i]));
                }
                this.setOfSeries.put(string3, (XYSeries)object);
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Verarbeitung der Fortran Ausgabedatei " + file.getName() + " fehlgeschlagen!", "Fehler", 0);
            return false;
        }
    }

    public boolean parseProfileFile(File file, ArrayList<CatalogObject> arrayList, String string) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                String[] stringArray = string2.split("\\s+", 0);
                arrayList2.add(stringArray);
            }
            int n = ((String[])arrayList2.get(0)).length - 1;
            for (int i = 1; i <= n; ++i) {
                String string3 = "";
                if (i <= arrayList.size() * 5) {
                    int n2 = (int)Math.ceil((i - 1) / 5);
                    String string4 = arrayList.get(n2).getBezeichnung();
                    Object object = Character.toUpperCase(string4.charAt(0)) + string4.substring(1, string4.length());
                    string3 = new String((String)object + string);
                    if (i % 5 == 1) {
                        string3 = string3.concat(" (DISS)");
                    } else if (i % 5 == 2) {
                        string3 = string3.concat(" (MIC)");
                    } else if (i % 5 == 3) {
                        string3 = string3.concat(" (SORB)");
                    } else if (i % 5 == 4) {
                        string3 = string3.concat(" (DIFF)");
                    } else if (i % 5 == 5) {
                        string3 = string3.concat(" (MONO)");
                    }
                }
                XYSeries xYSeries = new XYSeries((Comparable)((Object)string3));
                for (Object object : arrayList2) {
                    xYSeries.add(Double.parseDouble(object[0]), Double.parseDouble(object[i]));
                }
                this.setOfSeries.put(string3, xYSeries);
            }
            bufferedReader.close();
            return true;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Verarbeitung der Fortran Ausgabedatei " + file.getName() + " fehlgeschlagen!", "Fehler", 0);
            return false;
        }
    }

    public void setDataset(XYSeriesCollection xYSeriesCollection) {
        this.dataset = xYSeriesCollection;
    }

    public XYSeriesCollection getDataset() {
        return this.dataset;
    }
}

