/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.controller.MainWindowController;
import de.dsite.gui.FortranPanel;
import de.dsite.project.VersionedProject;
import de.dsite.utils.FortranUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class FortranSwingWorker
extends SwingWorker<Integer, String> {
    private long duration;
    private VersionedProject project;
    private FortranPanel panel;
    private File outDir;
    private Process process;

    public FortranSwingWorker(VersionedProject versionedProject, FortranPanel fortranPanel, File file) {
        this.project = versionedProject;
        this.panel = fortranPanel;
        this.outDir = file;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        String string;
        ProcessBuilder processBuilder = FortranUtils.buildProcess();
        if (processBuilder == null) {
            return null;
        }
        processBuilder.directory(this.outDir);
        processBuilder.redirectErrorStream(true);
        this.process = processBuilder.start();
        this.publish(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.fortran_log_start));
        this.duration = -System.currentTimeMillis();
        InputStream inputStream = this.getProcess().getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 0;
        this.setProgress(0);
        int n2 = this.project.getTimesteps().sumOfTimestepCounts();
        if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
            n2 *= this.project.getLeaves().size();
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (++n % 10 == 0) {
                if (this.isCancelled()) {
                    this.setProgress(0);
                    this.publish(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.fortran_log_abort));
                    return null;
                }
                int n3 = (int)Math.floor(n * 100 / n2);
                if (n3 <= 100) {
                    this.setProgress(n3);
                }
            }
            this.publish(string);
        }
        try {
            this.getProcess().waitFor();
        }
        catch (InterruptedException interruptedException) {
            this.publish(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.fortran_log_abort));
        }
        return null;
    }

    @Override
    protected void process(List<String> list) {
        for (String string : list) {
            this.panel.appendLineToLogArea(string);
        }
    }

    @Override
    protected void done() {
        try {
            Integer n = (Integer)this.get();
        }
        catch (InterruptedException interruptedException) {
            this.publish("Interrupted");
            this.closeStreamsAndDestroyProcess();
        }
        catch (ExecutionException executionException) {
            this.publish("Exception raised");
            this.closeStreamsAndDestroyProcess();
        }
        catch (CancellationException cancellationException) {
            this.publish(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.fortran_log_abort));
            this.closeStreamsAndDestroyProcess();
        }
        this.setProgress(0);
        this.duration += System.currentTimeMillis();
    }

    private void closeStreamsAndDestroyProcess() {
        try {
            this.getProcess().getInputStream().close();
            this.getProcess().getOutputStream().close();
            this.getProcess().getErrorStream().close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.getProcess().destroy();
    }

    private Process getProcess() {
        return this.process;
    }
}

