/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.data.ObservedSubject;
import de.dsite.data.Series;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.DataProvider;
import de.dsite.gui.ResultPlot;
import de.dsite.gui.ResultPlotBuilder;
import de.dsite.gui.SubjectListener;
import de.dsite.io.SeriesCollector;
import de.dsite.project.VersionedProject;
import de.dsite.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;

public class FortranOutputConverter
implements ObservedSubject,
DataProvider {
    private File fortranResultsFolder;
    private VersionedProject project;
    private SeriesCollector seriesCollector;
    private ArrayList<ResultPlot> btcPollutant;
    private ArrayList<ResultPlot> profilePollutant;
    private ArrayList<ResultPlot> btcSurfactant;
    private ArrayList<ResultPlot> profileSurfactant;
    private int numberOfBTCFiles;
    private int numberOfProfileFiles;
    private double[] observationValuesBTC;
    private Series.Unit unit;
    private ResultPlotBuilder.AxisRelation axisRelation;
    private ArrayList<SubjectListener> observer = new ArrayList();

    public FortranOutputConverter(File file, VersionedProject versionedProject) {
        this.fortranResultsFolder = file;
        this.project = versionedProject;
        this.btcPollutant = new ArrayList();
        this.profilePollutant = new ArrayList();
        this.setBtcSurfactant(new ArrayList<ResultPlot>());
        this.setProfileSurfactant(new ArrayList<ResultPlot>());
        this.seriesCollector = new SeriesCollector();
        this.numberOfBTCFiles = versionedProject.getBtcValues() == null ? 1 : versionedProject.getBtcValues().length + 1;
        this.observationValuesBTC = new double[this.numberOfBTCFiles];
        this.observationValuesBTC[0] = versionedProject.getLeaves().get(versionedProject.getLeaves().size() - 1).getXUK();
        if (this.numberOfBTCFiles > 1) {
            for (int i = 0; i < versionedProject.getBtcValues().length; ++i) {
                this.observationValuesBTC[i + 1] = versionedProject.getBtcValues()[i];
            }
        }
        this.numberOfProfileFiles = 0;
        if (versionedProject.getProfileValues() != null) {
            this.numberOfProfileFiles = versionedProject.getProfileValues().length;
        }
        this.convert();
    }

    private void convert() {
        ArrayList<CatalogObject> arrayList;
        File file;
        Object object;
        File file2;
        String string;
        int n;
        this.btcPollutant.clear();
        this.profilePollutant.clear();
        this.getBtcSurfactant().clear();
        this.getProfileSurfactant().clear();
        String string2 = this.project.getSzenarioName();
        String string3 = " ";
        int n2 = string2.indexOf(string3);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        if (string2 == null || string2 == "") {
            return;
        }
        for (n = 0; n < this.numberOfBTCFiles; ++n) {
            string = string2.concat(".0" + n + ".btc.sdo");
            file2 = new File(this.fortranResultsFolder.getAbsolutePath().concat("/" + string));
            if (FileUtils.fileExists(file2)) {
                object = new ArrayList<CatalogObject>();
                ((ArrayList)object).addAll(this.project.allPollutants());
                ((ArrayList)object).addAll(this.project.allSurfactants());
                this.seriesCollector.parseFileAndComputeLS(file2, (ArrayList<CatalogObject>)object, this.observationValuesBTC[n], Series.FileType.BTC, this.project);
            }
            object = string2.concat(".meas.0" + n + ".btc.sdo");
            file = new File(this.fortranResultsFolder.getAbsolutePath().concat("/" + (String)object));
            arrayList = new ArrayList<CatalogObject>();
            arrayList.addAll(this.project.allPollutants());
            arrayList.addAll(this.project.allSurfactants());
            if (FileUtils.fileExists(file)) {
                this.seriesCollector.parseMeasFile(file, arrayList, this.observationValuesBTC[n], Series.FileType.BTC);
                continue;
            }
            this.seriesCollector.generateEmptyMeasSeries(arrayList, this.observationValuesBTC[n], Series.FileType.BTC);
        }
        for (n = 0; n < this.numberOfProfileFiles; ++n) {
            string = string2.concat(".0" + (n + 1) + ".prf.sdo");
            file2 = new File(this.fortranResultsFolder.getAbsolutePath().concat("/" + string));
            if (FileUtils.fileExists(file2)) {
                object = new ArrayList();
                ((ArrayList)object).addAll(this.project.allPollutants());
                ((ArrayList)object).addAll(this.project.allSurfactants());
                this.seriesCollector.parseFile(file2, (ArrayList<CatalogObject>)object, this.project.getProfileValues()[n], Series.FileType.PROFILE);
            }
            object = string2.concat(".meas.0" + (n + 1) + ".prf.sdo");
            file = new File(this.fortranResultsFolder.getAbsolutePath().concat("/" + (String)object));
            arrayList = new ArrayList();
            arrayList.addAll(this.project.allPollutants());
            arrayList.addAll(this.project.allSurfactants());
            if (FileUtils.fileExists(file)) {
                this.seriesCollector.parseMeasFile(file, arrayList, this.project.getProfileValues()[n], Series.FileType.PROFILE);
                continue;
            }
            this.seriesCollector.generateEmptyMeasSeries(arrayList, this.project.getProfileValues()[n], Series.FileType.PROFILE);
        }
    }

    private ResultPlot buildResultPlotWithData(Set<Series> set) {
        ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
        resultPlotBuilder.projectFolder = this.fortranResultsFolder;
        resultPlotBuilder.setData(set);
        return resultPlotBuilder.create();
    }

    private ResultPlot buildResultPlotWithDataAndMaxYAxisValue(Set<Series> set, double d) {
        ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
        resultPlotBuilder.projectFolder = this.fortranResultsFolder;
        resultPlotBuilder.setData(set);
        resultPlotBuilder.setMaximumYAxis(d);
        return resultPlotBuilder.create();
    }

    public void generatePlots() {
        ResultPlot resultPlot;
        ArrayList<Double> arrayList;
        double d;
        double d2;
        Object object;
        Set<Series> set;
        Object object2;
        Object object3;
        CatalogObject catalogObject;
        this.btcPollutant.clear();
        this.profilePollutant.clear();
        this.btcSurfactant.clear();
        this.profileSurfactant.clear();
        if (this.project.allPollutants().size() == 1 && this.numberOfBTCFiles == 1) {
            catalogObject = this.project.allPollutants().get(0);
            object3 = this.seriesCollector.getBTCSeriesForPollutant((Pollutant)catalogObject, this.getUnit());
            object3.addAll(this.seriesCollector.getBTCMeasForPollutant((Pollutant)catalogObject, this.getUnit()));
            object2 = this.buildResultPlotWithData((Set<Series>)object3);
            if (object2 != null) {
                this.btcPollutant.add((ResultPlot)object2);
            }
        } else {
            for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                object3 = this.project.allPollutants().get(i);
                Set<Series> set2 = this.seriesCollector.getBTCSeriesForPollutant((Pollutant)object3, this.getUnit());
                set2.addAll(this.seriesCollector.getBTCMeasForPollutant((Pollutant)object3, this.getUnit()));
                set = this.buildResultPlotWithData(set2);
                if (set == null) continue;
                this.btcPollutant.add((ResultPlot)((Object)set));
            }
            double d3 = this.seriesCollector.getMaximumValueForPollutantBTCSeries();
            for (int i = 0; i < this.numberOfBTCFiles; ++i) {
                set = this.seriesCollector.getBTCPollutantsSeriesForObservationValue(this.observationValuesBTC[i], this.getUnit());
                set.addAll(this.seriesCollector.getBTCPollutantsMeasForObservationValue(this.observationValuesBTC[i], this.getUnit()));
                if (set.size() <= 0) continue;
                object = null;
                object = this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL ? this.buildResultPlotWithDataAndMaxYAxisValue(set, d3) : this.buildResultPlotWithData(set);
                if (object == null) continue;
                this.btcPollutant.add((ResultPlot)object);
            }
        }
        if (this.project.allSurfactants().size() == 1 && this.numberOfBTCFiles == 1) {
            catalogObject = this.project.allSurfactants().get(0);
            object3 = this.seriesCollector.getBTCSeriesForSurfactant((Surfactant)catalogObject, this.getUnit());
            object3.addAll(this.seriesCollector.getBTCMeasForSurfactant((Surfactant)catalogObject, this.getUnit()));
            object2 = this.buildResultPlotWithData((Set<Series>)object3);
            if (object2 != null) {
                this.getBtcSurfactant().add((ResultPlot)object2);
            }
        } else {
            for (int i = 0; i < this.project.allSurfactants().size(); ++i) {
                object3 = this.project.allSurfactants().get(i);
                object2 = this.seriesCollector.getBTCSeriesForSurfactant((Surfactant)object3, this.getUnit());
                object2.addAll(this.seriesCollector.getBTCMeasForSurfactant((Surfactant)object3, this.getUnit()));
                set = this.buildResultPlotWithData((Set<Series>)object2);
                if (set == null) continue;
                this.getBtcSurfactant().add((ResultPlot)((Object)set));
            }
            double d4 = this.seriesCollector.getMaximumValueForSurfactantBTCSeries();
            for (int i = 0; i < this.numberOfBTCFiles; ++i) {
                set = this.seriesCollector.getBTCSurfactantsSeriesForObservationValue(this.observationValuesBTC[i], this.unit);
                set.addAll(this.seriesCollector.getBTCSurfactantsMeasForObservationValue(this.observationValuesBTC[i], this.getUnit()));
                if (set.size() <= 0) continue;
                object = null;
                object = this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL ? this.buildResultPlotWithDataAndMaxYAxisValue(set, d4) : this.buildResultPlotWithData(set);
                if (object == null) continue;
                this.getBtcSurfactant().add((ResultPlot)object);
            }
        }
        if (this.project.allPollutants().size() == 1 && this.numberOfProfileFiles == 1) {
            Object object4;
            Pollutant pollutant = this.project.allPollutants().get(0);
            object3 = new ResultPlotBuilder();
            ((ResultPlotBuilder)object3).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object3).setFileType(Series.FileType.PROFILE);
            if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                ((ResultPlotBuilder)object3).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                object4 = this.seriesCollector.getProfileXXXSeriesForPollutantAndProfile(pollutant, Series.ProfileType.DISS);
                object4.addAll(this.seriesCollector.getProfileXXXMeasForPollutantAndProfile(pollutant, Series.ProfileType.DISS));
                ((ResultPlotBuilder)object3).setData((Set<Series>)object4);
            } else {
                object4 = this.seriesCollector.getProfileXXXSeriesForPollutantAndAllProfiles(pollutant);
                object4.addAll(this.seriesCollector.getProfileXXXMeasForPollutantAndAllProfiles(pollutant));
                ((ResultPlotBuilder)object3).setData((Set<Series>)object4);
            }
            object4 = ((ResultPlotBuilder)object3).create();
            if (object4 != null) {
                this.profilePollutant.add((ResultPlot)object4);
            }
        } else {
            for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                object3 = this.project.allPollutants().get(i);
                ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
                resultPlotBuilder.projectFolder = this.fortranResultsFolder;
                resultPlotBuilder.setFileType(Series.FileType.PROFILE);
                if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                    resultPlotBuilder.setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                    set = this.seriesCollector.getProfileXXXSeriesForPollutantAndProfile((Pollutant)object3, Series.ProfileType.DISS);
                    set.addAll(this.seriesCollector.getProfileXXXMeasForPollutantAndProfile((Pollutant)object3, Series.ProfileType.DISS));
                    resultPlotBuilder.setData(set);
                } else {
                    set = this.seriesCollector.getProfileXXXSeriesForPollutantAndAllProfiles((Pollutant)object3);
                    set.addAll(this.seriesCollector.getProfileXXXMeasForPollutantAndAllProfiles((Pollutant)object3));
                    resultPlotBuilder.setData(set);
                    resultPlotBuilder.setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.GENERAL && this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d5 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList();
                        arrayList.add(d5);
                        arrayList.add(d2);
                        arrayList.add(d);
                        resultPlotBuilder.setMaximumYAxis(arrayList);
                    }
                }
                object = resultPlotBuilder.create();
                if (object == null) continue;
                this.profilePollutant.add((ResultPlot)object);
            }
            if (this.numberOfProfileFiles > 1) {
                double d6 = this.seriesCollector.getMaximumValueForPollutantProfileSeries();
                for (int i = 0; i < this.numberOfProfileFiles; ++i) {
                    set = new ResultPlotBuilder();
                    ((ResultPlotBuilder)((Object)set)).projectFolder = this.fortranResultsFolder;
                    ((ResultPlotBuilder)((Object)set)).setFileType(Series.FileType.PROFILE);
                    ((ResultPlotBuilder)((Object)set)).setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                        ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(d6);
                    } else if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d7 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList<Double>();
                        arrayList.add(d7);
                        arrayList.add(d2);
                        arrayList.add(d);
                        ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(arrayList);
                    }
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        ((ResultPlotBuilder)((Object)set)).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        object = this.seriesCollector.getProfilePollutantsXXXSeriesForValueAndProfile(this.project.getProfileValues()[i], Series.ProfileType.DISS);
                        object.addAll(this.seriesCollector.getProfilePollutantsXXXMeasForValueAndProfile(this.project.getProfileValues()[i], Series.ProfileType.DISS));
                        ((ResultPlotBuilder)((Object)set)).setData((Set<Series>)object);
                    } else {
                        object = this.seriesCollector.getProfilePollutantsXXXSeriesForValueAndAllProfiles(this.project.getProfileValues()[i]);
                        object.addAll(this.seriesCollector.getProfilePollutantsXXXMeasForValueAndAllProfiles(this.project.getProfileValues()[i]));
                        ((ResultPlotBuilder)((Object)set)).setData((Set<Series>)object);
                    }
                    resultPlot = ((ResultPlotBuilder)((Object)set)).create();
                    if (resultPlot == null) continue;
                    this.profilePollutant.add(resultPlot);
                }
            }
        }
        if (this.project.allSurfactants().size() == 1 && this.numberOfProfileFiles == 1) {
            Object object5;
            Surfactant surfactant = this.project.allSurfactants().get(0);
            object3 = new ResultPlotBuilder();
            ((ResultPlotBuilder)object3).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object3).setFileType(Series.FileType.PROFILE);
            if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                ((ResultPlotBuilder)object3).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                object5 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndProfile(surfactant, Series.ProfileType.DISS);
                ((ResultPlotBuilder)object3).setData((Set<Series>)object5);
            } else {
                object5 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndAllProfiles(surfactant);
                ((ResultPlotBuilder)object3).setData((Set<Series>)object5);
            }
            object5 = ((ResultPlotBuilder)object3).create();
            if (object5 != null) {
                this.getProfileSurfactant().add((ResultPlot)object5);
            }
        } else {
            if (this.project.allSurfactants().size() > 1) {
                for (int i = 0; i < this.project.allSurfactants().size(); ++i) {
                    object3 = this.project.allSurfactants().get(i);
                    ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
                    resultPlotBuilder.projectFolder = this.fortranResultsFolder;
                    resultPlotBuilder.setFileType(Series.FileType.PROFILE);
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        resultPlotBuilder.setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        set = this.seriesCollector.getProfileXXXSeriesForSurfactantAndProfile((Surfactant)object3, Series.ProfileType.DISS);
                        resultPlotBuilder.setData(set);
                    } else {
                        set = this.seriesCollector.getProfileXXXSeriesForSurfactantAndAllProfiles((Surfactant)object3);
                        resultPlotBuilder.setData(set);
                        resultPlotBuilder.setAxisRelation(this.getAxisRelation());
                        if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.GENERAL && this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                            double d8 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                            d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                            d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                            arrayList = new ArrayList();
                            arrayList.add(d8);
                            arrayList.add(d2);
                            arrayList.add(d);
                            resultPlotBuilder.setMaximumYAxis(arrayList);
                        }
                    }
                    object = resultPlotBuilder.create();
                    if (object == null) continue;
                    this.getProfileSurfactant().add((ResultPlot)object);
                }
            }
            if (this.numberOfProfileFiles > 1) {
                double d9 = this.seriesCollector.getMaximumValueForPollutantProfileSeries();
                for (int i = 0; i < this.numberOfProfileFiles; ++i) {
                    set = new ResultPlotBuilder();
                    ((ResultPlotBuilder)((Object)set)).projectFolder = this.fortranResultsFolder;
                    ((ResultPlotBuilder)((Object)set)).setFileType(Series.FileType.PROFILE);
                    ((ResultPlotBuilder)((Object)set)).setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                        ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(d9);
                    } else if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d10 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList();
                        arrayList.add(d10);
                        arrayList.add(d2);
                        arrayList.add(d);
                        ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(arrayList);
                    }
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        ((ResultPlotBuilder)((Object)set)).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        object = this.seriesCollector.getProfileSurfactantsXXXSeriesForValueAndProfile(this.project.getProfileValues()[i], Series.ProfileType.DISS);
                        ((ResultPlotBuilder)((Object)set)).setData((Set<Series>)object);
                    } else {
                        object = this.seriesCollector.getProfileSurfactantsXXXSeriesForValueAndAllProfiles(this.project.getProfileValues()[i]);
                        ((ResultPlotBuilder)((Object)set)).setData((Set<Series>)object);
                    }
                    resultPlot = ((ResultPlotBuilder)((Object)set)).create();
                    if (resultPlot == null) continue;
                    this.getProfileSurfactant().add(resultPlot);
                }
            }
        }
        this.notifyListener();
    }

    public void generatePlots_() {
        ArrayList<Double> arrayList;
        double d;
        double d2;
        ResultPlot resultPlot;
        Set<Series> set;
        Set<Series> set2;
        Object object;
        Object object2;
        CatalogObject catalogObject;
        this.btcPollutant.clear();
        this.profilePollutant.clear();
        this.btcSurfactant.clear();
        this.profileSurfactant.clear();
        if (this.project.allPollutants().size() == 1 && this.numberOfBTCFiles == 1) {
            catalogObject = this.project.allPollutants().get(0);
            object2 = this.seriesCollector.getBTCSeriesForPollutant((Pollutant)catalogObject, this.getUnit());
            object = new ResultPlotBuilder();
            ((ResultPlotBuilder)object).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object).setData((Set<Series>)object2);
            set2 = ((ResultPlotBuilder)object).create();
            if (set2 != null) {
                this.btcPollutant.add((ResultPlot)((Object)set2));
            }
        } else {
            for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                object2 = this.project.allPollutants().get(i);
                Set<Series> set3 = this.seriesCollector.getBTCSeriesForPollutant((Pollutant)object2, this.getUnit());
                set2 = new ResultPlotBuilder();
                ((ResultPlotBuilder)((Object)set2)).projectFolder = this.fortranResultsFolder;
                ((ResultPlotBuilder)((Object)set2)).setData(set3);
                set = ((ResultPlotBuilder)((Object)set2)).create();
                if (set == null) continue;
                this.btcPollutant.add((ResultPlot)((Object)set));
            }
            double d3 = this.seriesCollector.getMaximumValueForPollutantBTCSeries();
            for (int i = 0; i < this.numberOfBTCFiles; ++i) {
                set2 = this.seriesCollector.getBTCPollutantsSeriesForObservationValue(this.observationValuesBTC[i], this.getUnit());
                if (set2.size() <= 0) continue;
                set = new ResultPlotBuilder();
                ((ResultPlotBuilder)((Object)set)).projectFolder = this.fortranResultsFolder;
                ((ResultPlotBuilder)((Object)set)).setData(set2);
                if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                    ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(d3);
                }
                if ((resultPlot = ((ResultPlotBuilder)((Object)set)).create()) == null) continue;
                this.btcPollutant.add(resultPlot);
            }
        }
        if (this.project.allSurfactants().size() == 1 && this.numberOfBTCFiles == 1) {
            catalogObject = this.project.allSurfactants().get(0);
            object2 = this.seriesCollector.getBTCSeriesForSurfactant((Surfactant)catalogObject, this.getUnit());
            object = new ResultPlotBuilder();
            ((ResultPlotBuilder)object).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object).setData((Set<Series>)object2);
            set2 = ((ResultPlotBuilder)object).create();
            if (set2 != null) {
                this.getBtcSurfactant().add((ResultPlot)((Object)set2));
            }
        } else {
            for (int i = 0; i < this.project.allSurfactants().size(); ++i) {
                object2 = this.project.allSurfactants().get(i);
                object = this.seriesCollector.getBTCSeriesForSurfactant((Surfactant)object2, this.getUnit());
                set2 = new ResultPlotBuilder();
                ((ResultPlotBuilder)((Object)set2)).projectFolder = this.fortranResultsFolder;
                ((ResultPlotBuilder)((Object)set2)).setData((Set<Series>)object);
                set = ((ResultPlotBuilder)((Object)set2)).create();
                if (set == null) continue;
                this.getBtcSurfactant().add((ResultPlot)((Object)set));
            }
            double d4 = this.seriesCollector.getMaximumValueForSurfactantBTCSeries();
            for (int i = 0; i < this.numberOfBTCFiles; ++i) {
                set2 = this.seriesCollector.getBTCSurfactantsSeriesForObservationValue(this.observationValuesBTC[i], this.unit);
                if (set2.size() <= 0) continue;
                set = new ResultPlotBuilder();
                ((ResultPlotBuilder)((Object)set)).projectFolder = this.fortranResultsFolder;
                ((ResultPlotBuilder)((Object)set)).setData(set2);
                if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                    ((ResultPlotBuilder)((Object)set)).setMaximumYAxis(d4);
                }
                if ((resultPlot = ((ResultPlotBuilder)((Object)set)).create()) == null) continue;
                this.getBtcSurfactant().add(resultPlot);
            }
        }
        if (this.project.allPollutants().size() == 1 && this.numberOfProfileFiles == 1) {
            Object object3;
            Pollutant pollutant = this.project.allPollutants().get(0);
            object2 = new ResultPlotBuilder();
            ((ResultPlotBuilder)object2).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object2).setFileType(Series.FileType.PROFILE);
            if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                ((ResultPlotBuilder)object2).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                object3 = this.seriesCollector.getProfileXXXSeriesForPollutantAndProfile(pollutant, Series.ProfileType.DISS);
                ((ResultPlotBuilder)object2).setData((Set<Series>)object3);
            } else {
                object3 = this.seriesCollector.getProfileXXXSeriesForPollutantAndAllProfiles(pollutant);
                ((ResultPlotBuilder)object2).setData((Set<Series>)object3);
            }
            object3 = ((ResultPlotBuilder)object2).create();
            if (object3 != null) {
                this.profilePollutant.add((ResultPlot)object3);
            }
        } else {
            for (int i = 0; i < this.project.allPollutants().size(); ++i) {
                object2 = this.project.allPollutants().get(i);
                ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
                resultPlotBuilder.projectFolder = this.fortranResultsFolder;
                resultPlotBuilder.setFileType(Series.FileType.PROFILE);
                if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                    resultPlotBuilder.setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                    set2 = this.seriesCollector.getProfileXXXSeriesForPollutantAndProfile((Pollutant)object2, Series.ProfileType.DISS);
                    resultPlotBuilder.setData(set2);
                } else {
                    set2 = this.seriesCollector.getProfileXXXSeriesForPollutantAndAllProfiles((Pollutant)object2);
                    resultPlotBuilder.setData(set2);
                    resultPlotBuilder.setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.GENERAL && this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d5 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList();
                        arrayList.add(d5);
                        arrayList.add(d2);
                        arrayList.add(d);
                        resultPlotBuilder.setMaximumYAxis(arrayList);
                    }
                }
                set = resultPlotBuilder.create();
                if (set == null) continue;
                this.profilePollutant.add((ResultPlot)((Object)set));
            }
            if (this.numberOfProfileFiles > 1) {
                double d6 = this.seriesCollector.getMaximumValueForPollutantProfileSeries();
                for (int i = 0; i < this.numberOfProfileFiles; ++i) {
                    set2 = new ResultPlotBuilder();
                    ((ResultPlotBuilder)((Object)set2)).projectFolder = this.fortranResultsFolder;
                    ((ResultPlotBuilder)((Object)set2)).setFileType(Series.FileType.PROFILE);
                    ((ResultPlotBuilder)((Object)set2)).setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                        ((ResultPlotBuilder)((Object)set2)).setMaximumYAxis(d6);
                    } else if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d7 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList<Double>();
                        arrayList.add(d7);
                        arrayList.add(d2);
                        arrayList.add(d);
                        ((ResultPlotBuilder)((Object)set2)).setMaximumYAxis(arrayList);
                    }
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        ((ResultPlotBuilder)((Object)set2)).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        set = this.seriesCollector.getProfilePollutantsXXXSeriesForValueAndProfile(this.project.getProfileValues()[i], Series.ProfileType.DISS);
                        ((ResultPlotBuilder)((Object)set2)).setData(set);
                    } else {
                        set = this.seriesCollector.getProfilePollutantsXXXSeriesForValueAndAllProfiles(this.project.getProfileValues()[i]);
                        ((ResultPlotBuilder)((Object)set2)).setData(set);
                    }
                    resultPlot = ((ResultPlotBuilder)((Object)set2)).create();
                    if (resultPlot == null) continue;
                    this.profilePollutant.add(resultPlot);
                }
            }
        }
        if (this.project.allSurfactants().size() == 1 && this.numberOfProfileFiles == 1) {
            Object object4;
            Surfactant surfactant = this.project.allSurfactants().get(0);
            object2 = new ResultPlotBuilder();
            ((ResultPlotBuilder)object2).projectFolder = this.fortranResultsFolder;
            ((ResultPlotBuilder)object2).setFileType(Series.FileType.PROFILE);
            if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                ((ResultPlotBuilder)object2).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                object4 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndProfile(surfactant, Series.ProfileType.DISS);
                ((ResultPlotBuilder)object2).setData((Set<Series>)object4);
            } else {
                object4 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndAllProfiles(surfactant);
                ((ResultPlotBuilder)object2).setData((Set<Series>)object4);
            }
            object4 = ((ResultPlotBuilder)object2).create();
            if (object4 != null) {
                this.getProfileSurfactant().add((ResultPlot)object4);
            }
        } else {
            if (this.project.allSurfactants().size() > 1) {
                for (int i = 0; i < this.project.allSurfactants().size(); ++i) {
                    object2 = this.project.allSurfactants().get(i);
                    ResultPlotBuilder resultPlotBuilder = new ResultPlotBuilder();
                    resultPlotBuilder.projectFolder = this.fortranResultsFolder;
                    resultPlotBuilder.setFileType(Series.FileType.PROFILE);
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        resultPlotBuilder.setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        set2 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndProfile((Surfactant)object2, Series.ProfileType.DISS);
                        resultPlotBuilder.setData(set2);
                    } else {
                        set2 = this.seriesCollector.getProfileXXXSeriesForSurfactantAndAllProfiles((Surfactant)object2);
                        resultPlotBuilder.setData(set2);
                        resultPlotBuilder.setAxisRelation(this.getAxisRelation());
                        if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.GENERAL && this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                            double d8 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                            d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                            d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                            arrayList = new ArrayList();
                            arrayList.add(d8);
                            arrayList.add(d2);
                            arrayList.add(d);
                            resultPlotBuilder.setMaximumYAxis(arrayList);
                        }
                    }
                    set = resultPlotBuilder.create();
                    if (set == null) continue;
                    this.getProfileSurfactant().add((ResultPlot)((Object)set));
                }
            }
            if (this.numberOfProfileFiles > 1) {
                double d9 = this.seriesCollector.getMaximumValueForPollutantProfileSeries();
                for (int i = 0; i < this.numberOfProfileFiles; ++i) {
                    set2 = new ResultPlotBuilder();
                    ((ResultPlotBuilder)((Object)set2)).projectFolder = this.fortranResultsFolder;
                    ((ResultPlotBuilder)((Object)set2)).setFileType(Series.FileType.PROFILE);
                    ((ResultPlotBuilder)((Object)set2)).setAxisRelation(this.getAxisRelation());
                    if (this.getAxisRelation() == ResultPlotBuilder.AxisRelation.GENERAL) {
                        ((ResultPlotBuilder)((Object)set2)).setMaximumYAxis(d9);
                    } else if (this.getAxisRelation() != ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE && this.getAxisRelation() == ResultPlotBuilder.AxisRelation.INDIVIDUAL_CONSTANT) {
                        double d10 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DISS);
                        d2 = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.SORB);
                        d = this.seriesCollector.getMaximumValueForPollutantProfileSeriesOfProfileType(Series.ProfileType.DIFF);
                        arrayList = new ArrayList();
                        arrayList.add(d10);
                        arrayList.add(d2);
                        arrayList.add(d);
                        ((ResultPlotBuilder)((Object)set2)).setMaximumYAxis(arrayList);
                    }
                    if (this.project.getMode() == VersionedProject.SimulationMode.SMART) {
                        ((ResultPlotBuilder)((Object)set2)).setPlotType(ResultPlotBuilder.PlotType.DOTPLOT);
                        set = this.seriesCollector.getProfileSurfactantsXXXSeriesForValueAndProfile(this.project.getProfileValues()[i], Series.ProfileType.DISS);
                        ((ResultPlotBuilder)((Object)set2)).setData(set);
                    } else {
                        set = this.seriesCollector.getProfileSurfactantsXXXSeriesForValueAndAllProfiles(this.project.getProfileValues()[i]);
                        ((ResultPlotBuilder)((Object)set2)).setData(set);
                    }
                    resultPlot = ((ResultPlotBuilder)((Object)set2)).create();
                    if (resultPlot == null) continue;
                    this.getProfileSurfactant().add(resultPlot);
                }
            }
        }
        this.notifyListener();
    }

    public ArrayList<ResultPlot> getResultPlotsBTCPollutant() {
        return this.btcPollutant;
    }

    public ArrayList<ResultPlot> getResultPlotsProfilePollutant() {
        return this.profilePollutant;
    }

    public ArrayList<ResultPlot> getResultPlotsBTCSurfactant() {
        return this.getBtcSurfactant();
    }

    public ArrayList<ResultPlot> getResultPlotsProfileSurfactant() {
        return this.getProfileSurfactant();
    }

    @Override
    public void addListener(SubjectListener subjectListener) {
        this.observer.add(subjectListener);
    }

    @Override
    public void removeListener(SubjectListener subjectListener) {
        int n = this.observer.indexOf(subjectListener);
        if (n >= 0) {
            this.observer.remove(n);
        }
    }

    @Override
    public void notifyListener() {
        for (SubjectListener subjectListener : this.observer) {
            subjectListener.update(this);
        }
    }

    @Override
    public ArrayList<ResultPlot> getBTCsPollutants() {
        return this.btcPollutant.size() > 0 ? this.btcPollutant : null;
    }

    @Override
    public ArrayList<ResultPlot> getProfilesPollutants() {
        return this.profilePollutant.size() > 0 ? this.profilePollutant : null;
    }

    @Override
    public ArrayList<ResultPlot> getBTCsSurfactants() {
        return this.getBtcSurfactant().size() > 0 ? this.getBtcSurfactant() : null;
    }

    @Override
    public ArrayList<ResultPlot> getProfilesSurfactants() {
        return this.getProfileSurfactant().size() > 0 ? this.getProfileSurfactant() : null;
    }

    private ArrayList<ResultPlot> getBtcSurfactant() {
        return this.btcSurfactant;
    }

    private void setBtcSurfactant(ArrayList<ResultPlot> arrayList) {
        this.btcSurfactant = arrayList;
    }

    private ArrayList<ResultPlot> getProfileSurfactant() {
        return this.profileSurfactant;
    }

    private void setProfileSurfactant(ArrayList<ResultPlot> arrayList) {
        this.profileSurfactant = arrayList;
    }

    public Series.Unit getUnit() {
        if (this.unit == null) {
            this.unit = Series.Unit.SEC;
        }
        return this.unit;
    }

    public void setUnit(Series.Unit unit) {
        this.unit = unit;
    }

    public ResultPlotBuilder.AxisRelation getAxisRelation() {
        if (this.axisRelation == null) {
            this.axisRelation = ResultPlotBuilder.AxisRelation.INDIVIDUAL_VARIABLE;
        }
        return this.axisRelation;
    }

    public void setAxisRelation(ResultPlotBuilder.AxisRelation axisRelation) {
        this.axisRelation = axisRelation;
    }
}

