/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.utils.FileUtils;
import de.dsite.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class BuildProperties {
    private static final String NAME_OF_BUILDCONFIG_FILE = "BuildConfig.properties";
    private static BuildProperties instance;
    private final Properties properties = new Properties();

    public static BuildProperties getInstance() throws IOException {
        if (instance == null) {
            instance = new BuildProperties();
        }
        return instance;
    }

    private BuildProperties() throws IOException {
        this.readBuildProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBuildProperties() throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(FileUtils.getPropertiesFolder(), NAME_OF_BUILDCONFIG_FILE));
            this.properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(fileInputStream);
            throw throwable;
        }
        StreamUtils.safeClose(fileInputStream);
    }

    public String getProperty(PropertyName propertyName) {
        return this.properties.getProperty(propertyName.propertyKey);
    }

    public static enum PropertyName {
        LANGUAGE("language"),
        OS("os"),
        VERSION("version");

        final String propertyKey;

        private PropertyName(String string2) {
            this.propertyKey = string2;
        }
    }
}

