/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.io;

import de.dsite.utils.FileUtils;
import de.dsite.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class ApplicationProperties {
    private static final String NAME_OF_APPLICATIONCONFIG_FILE = "ApplicationConfig.properties";
    private static ApplicationProperties instance;
    private final Properties properties = new Properties();

    public static ApplicationProperties getInstance() throws IOException {
        if (instance == null) {
            instance = new ApplicationProperties();
        }
        return instance;
    }

    private ApplicationProperties() throws IOException {
        this.readApplicationProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readApplicationProperties() throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(FileUtils.getPropertiesFolder(), NAME_OF_APPLICATIONCONFIG_FILE));
            this.properties.load(fileInputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(fileInputStream);
            throw throwable;
        }
        StreamUtils.safeClose(fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeApplicationProperties() throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(FileUtils.getPropertiesFolder(), NAME_OF_APPLICATIONCONFIG_FILE));
            this.properties.store(fileOutputStream, null);
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(fileOutputStream);
            throw throwable;
        }
        StreamUtils.safeClose(fileOutputStream);
    }

    public String getProperty(PropertyName propertyName) {
        return this.properties.getProperty(propertyName.propertyKey);
    }

    public void setProperty(PropertyName propertyName, String string) {
        this.properties.setProperty(propertyName.propertyKey, string);
    }

    public static enum PropertyName {
        UNIT_TIME_PROPERTY_CARD("unit.time.property.card"),
        UNIT_BC_FLOW_CARD("unit.bc.flow.card"),
        UNIT_BC_TRANSPORT_CARD("unit.bc.transport.card"),
        UNIT_OUTPUT_SPECS_CARD("unit.output.specs.card"),
        UNIT_RESULTS("unit.results");

        final String propertyKey;

        private PropertyName(String string2) {
            this.propertyKey = string2;
        }
    }
}

