/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui.listcard;

import de.dsite.controller.MainWindowController;
import de.dsite.gui.listcard.ResultCard;
import de.dsite.utils.FileUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ResultCardFile
extends ResultCard {
    private static final long serialVersionUID = 1L;
    private File resultsFolder;
    private JButton selectFileButton;
    private JTextField tf_fileChooser;
    private JTextArea fileContentArea;

    public ResultCardFile() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.output_card_files_title)), BorderFactory.createEmptyBorder(15, 15, 15, 15)));
    }

    @Override
    protected void createComponents() {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        this.selectFileButton = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_select));
        this.selectFileButton.setPreferredSize(new Dimension(100, 20));
        this.selectFileButton.addActionListener(new SelectButtonActionListener());
        this.tf_fileChooser = new JTextField(20);
        this.tf_fileChooser.setName("tf_fileChooser");
        this.tf_fileChooser.setEditable(false);
        this.fileContentArea = new JTextArea();
        this.fileContentArea.setEditable(false);
        this.fileContentArea.setLineWrap(true);
        this.fileContentArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.fileContentArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.add(this.tf_fileChooser);
        jPanel.add(this.selectFileButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "First");
        jPanel2.add((Component)jScrollPane, "Center");
        this.addComponent(this, gridBagLayout, jPanel2, 0, 0, 1, 1, 0.25, 1.0, 1);
    }

    public void setResultsFolder(File file) {
        ResultCardFile.assertResultsFolderNotNull(file);
        ResultCardFile.assertResultsFolderExists(file);
        this.resultsFolder = file;
        try {
            this.tf_fileChooser.setText(file.getCanonicalPath());
        }
        catch (Exception exception) {
            this.tf_fileChooser.setText(file.getAbsolutePath());
        }
    }

    public void clearFileOutputs() {
        this.fileContentArea.setText("");
        this.tf_fileChooser.setText("");
    }

    private static void assertResultsFolderNotNull(File file) {
        if (file == null) {
            throw new IllegalArgumentException("parameter 'resultsFolder' must not be null");
        }
    }

    private static void assertResultsFolderExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("parameter 'resultsFolder' does not exist!");
        }
    }

    private class SelectButtonActionListener
    implements ActionListener {
        private SelectButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file;
            JFileChooser jFileChooser = ResultCardFile.this.resultsFolder != null ? new JFileChooser(ResultCardFile.this.resultsFolder) : new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = FileUtils.getFileExtension(file);
                    return file.isDirectory() || string.equals("out") || string.equals("dat") || string.equals("ba1") || string.equals("ba2");
                }

                @Override
                public String getDescription() {
                    return "*.ba1, *.ba2, *.dat, *.out";
                }
            });
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0 && (file = jFileChooser.getSelectedFile()).canWrite()) {
                try {
                    ResultCardFile.this.tf_fileChooser.setText(file.getCanonicalPath());
                }
                catch (Exception exception) {
                    ResultCardFile.this.tf_fileChooser.setText(file.getAbsolutePath());
                }
                try {
                    ResultCardFile.this.fileContentArea.read(new FileReader(file), "");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

