/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui.listcard;

import de.dsite.controller.MainWindowController;
import de.dsite.data.GrainSize;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.gui.listcard.ListCard;
import de.dsite.project.Material;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class MaterialCard
extends ListCard {
    private static final long serialVersionUID = 1L;
    private final JList<Material> materialList = new JList();
    private final JTextField nameTextField = new JTextField(20);
    private final JButton addMaterial = new JButton("+");
    private final JButton delMaterial = new JButton("-");
    private final JButton materialFromFile = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.load));
    private final JButton materialToFile = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.save));
    private final JTable aquiferMaterialsTable = new JTable();
    private final JButton addNewAquiferMaterial = new JButton("+");
    private final JButton addCatalogAquiferMaterial = new JButton("+");
    private final JButton delAquiferMaterial = new JButton("-");
    private final JRadioButton userDefButton = new JRadioButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_rbtn1));
    private final JRadioButton dinButton = new JRadioButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_rbtn2));
    private final JTable grainSizeTable = new JTable();
    private final JButton addGrainSize = new JButton("+");
    private final JButton addDefaultOrDinGrainSize = new JButton("+");
    private final JButton delGrainSize = new JButton("-");
    private final JComboBox<AquiferMaterial> aquiferComboBox = new JComboBox();
    private final JComboBox<GrainSize> grainSizeComboBox = new JComboBox();
    private final JTable compositionTable = new JTable();

    public MaterialCard() {
        super(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_title));
        this.createComponents();
    }

    @Override
    protected void createComponents() {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.materialList.setSelectionMode(0);
        this.materialList.setVisibleRowCount(5);
        this.materialList.setSelectedIndex(0);
        JScrollPane jScrollPane = new JScrollPane(this.materialList);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.materialFromFile);
        jPanel2.add(this.materialToFile);
        jPanel2.add(this.delMaterial);
        jPanel2.add(this.addMaterial);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "Last");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_lbl1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        this.compositionTable.setDefaultRenderer(Object.class, new ColoredTableCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane(this.compositionTable);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        jPanel3.add(jScrollPane2);
        jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_lbl2)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.nameTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_composition_lbl3)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel4.add((Component)this.nameTextField, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane3 = new JScrollPane(this.aquiferMaterialsTable);
        jScrollPane3.setVerticalScrollBarPolicy(22);
        JPanel jPanel6 = new JPanel(new FlowLayout(2));
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(this.aquiferComboBox);
        jPanel7.add(this.addCatalogAquiferMaterial);
        jPanel7.setBorder(BorderFactory.createEtchedBorder());
        jPanel6.add(jPanel7);
        jPanel6.add(this.delAquiferMaterial);
        jPanel6.add(this.addNewAquiferMaterial);
        jPanel5.add((Component)jScrollPane3, "Center");
        jPanel5.add((Component)jPanel6, "Last");
        jPanel5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_lbl1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel(new GridLayout(0, 1));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.userDefButton);
        buttonGroup.add(this.dinButton);
        jPanel9.add(this.userDefButton);
        jPanel9.add(this.dinButton);
        jPanel9.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_lbl2)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel10 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane4 = new JScrollPane(this.getGrainSizeTable());
        jScrollPane4.setVerticalScrollBarPolicy(22);
        jPanel10.add((Component)jScrollPane4, "Center");
        JPanel jPanel11 = new JPanel(new FlowLayout(2));
        JPanel jPanel12 = new JPanel(new FlowLayout(2));
        jPanel12.add(this.grainSizeComboBox);
        jPanel12.add(this.addDefaultOrDinGrainSize);
        jPanel12.setBorder(BorderFactory.createEtchedBorder());
        jPanel11.add(jPanel12);
        jPanel11.add(this.delGrainSize);
        jPanel11.add(this.addGrainSize);
        jPanel10.add((Component)jPanel11, "Last");
        jScrollPane4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_lbl3)), BorderFactory.createEmptyBorder(5, 5, 5, 5)), jPanel10.getBorder()));
        jPanel8.add((Component)jPanel9, "Before");
        jPanel8.add((Component)jPanel10, "Center");
        jPanel8.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_lbl4)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel13 = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel13.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridy = 1;
        jPanel13.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel13.add((Component)jPanel8, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel13.add((Component)jPanel3, gridBagConstraints);
        jPanel13.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_grainsize_lbl5)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addComponentToLeft(this, gridBagLayout, jPanel, 0, 200, 0.0, 0.0);
        this.addComponent(this, gridBagLayout, jPanel13, 1, 0, 1, 1, 1.0, 1.0, 1);
        this.addComponent((Container)this, gridBagLayout, (Component)this.createControlPanel(ListCard.CardPanelState.MID_PANEL), 0, 3, 2, 1, 0.0, 0.0, new Insets(0, 0, 0, 0), 20);
    }

    @Override
    public String cardName() {
        return MainWindowController.InputCardValue.MATERIAL.name();
    }

    public void disableDINAdding() {
        this.addDefaultOrDinGrainSize.setEnabled(false);
        this.grainSizeComboBox.setEnabled(false);
    }

    public void enableDINAdding() {
        this.addDefaultOrDinGrainSize.setEnabled(true);
        this.grainSizeComboBox.setEnabled(true);
    }

    public void addAddMaterialButtonListener(ActionListener actionListener) {
        this.addMaterial.addActionListener(actionListener);
    }

    public void addDelMaterialButtonListener(ActionListener actionListener) {
        this.delMaterial.addActionListener(actionListener);
    }

    public void addMaterialListModel(ListModel<Material> listModel) {
        this.materialList.setModel(listModel);
    }

    public void selectFileMaterialActionListener(ActionListener actionListener) {
        this.materialFromFile.addActionListener(actionListener);
    }

    public void storeFileMaterialActionListener(ActionListener actionListener) {
        this.materialToFile.addActionListener(actionListener);
    }

    public void addMaterialListSelectionListener(ListSelectionListener listSelectionListener) {
        this.materialList.addListSelectionListener(listSelectionListener);
    }

    public String getTextFieldString() {
        return this.nameTextField.getText();
    }

    public void addTextFieldActionListener(ActionListener actionListener) {
        this.nameTextField.addActionListener(actionListener);
    }

    public void addTextFieldFocusListener(FocusListener focusListener) {
        this.nameTextField.addFocusListener(focusListener);
    }

    public void setTextFieldString(String string) {
        this.nameTextField.setText(string);
    }

    public void addCompositionTableModel(AbstractTableModel abstractTableModel) {
        this.compositionTable.setModel(abstractTableModel);
    }

    public JList<Material> getMaterialList() {
        return this.materialList;
    }

    public void addAquiferComboBoxModel(DefaultComboBoxModel<AquiferMaterial> defaultComboBoxModel) {
        this.aquiferComboBox.setModel(defaultComboBoxModel);
    }

    public void addGrainSizeComboBoxModel(DefaultComboBoxModel<GrainSize> defaultComboBoxModel) {
        this.grainSizeComboBox.setModel(defaultComboBoxModel);
    }

    public void addAddNewAquiferMaterialButtonListener(ActionListener actionListener) {
        this.addNewAquiferMaterial.addActionListener(actionListener);
    }

    public void addAddCatalogAquiferMaterialButtonListener(ActionListener actionListener) {
        this.addCatalogAquiferMaterial.addActionListener(actionListener);
    }

    public void addDelAquiferMaterialButtonListener(ActionListener actionListener) {
        this.delAquiferMaterial.addActionListener(actionListener);
    }

    public void addAddNewGrainSizeButtonListener(ActionListener actionListener) {
        this.addGrainSize.addActionListener(actionListener);
    }

    public void addAddDefaultOrDinGrainSizeButtonListener(ActionListener actionListener) {
        this.addDefaultOrDinGrainSize.addActionListener(actionListener);
    }

    public void addDelGrainSizeButtonListener(ActionListener actionListener) {
        this.delGrainSize.addActionListener(actionListener);
    }

    public void setAddGrainSizeEnabled(boolean bl) {
        this.addGrainSize.setEnabled(bl);
    }

    public void setRadioButtonUserDef(boolean bl) {
        this.userDefButton.setSelected(bl);
    }

    public void addUserDefButtonListener(ActionListener actionListener) {
        this.userDefButton.addActionListener(actionListener);
    }

    public void addDinButtonListener(ActionListener actionListener) {
        this.dinButton.addActionListener(actionListener);
    }

    public void setRadioButtonDin(boolean bl) {
        this.dinButton.setSelected(bl);
    }

    public JTable getAquiferMaterialsTable() {
        return this.aquiferMaterialsTable;
    }

    public JRadioButton getDinButton() {
        return this.dinButton;
    }

    public JRadioButton getUserDefButton() {
        return this.userDefButton;
    }

    public JTable getGrainSizeTable() {
        return this.grainSizeTable;
    }

    public void addTableModelGrainSize(AbstractTableModel abstractTableModel) {
        this.grainSizeTable.setModel(abstractTableModel);
    }

    public void addTableModelAquiferMaterials(AbstractTableModel abstractTableModel) {
        this.aquiferMaterialsTable.setModel(abstractTableModel);
    }

    private final class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private ColoredTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n == 0 && n2 == jTable.getColumnCount() - 1 || n == jTable.getRowCount() - 1) {
                if (object instanceof Double) {
                    this.setForeground((Double)object != 100.0 ? Color.RED : Color.GREEN);
                    this.setText(object.toString());
                } else {
                    this.setForeground(Color.BLACK);
                }
                super.setValue(object);
            }
            if (n == 0) {
                this.setBackground(Color.LIGHT_GRAY);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }

        @Override
        public void setValue(Object object) {
            if (object instanceof Float) {
                this.setForeground(((Float)object).floatValue() != 100.0f ? Color.RED : Color.GREEN);
                this.setText(object.toString());
            } else {
                this.setForeground(Color.BLACK);
            }
            super.setValue(object);
        }
    }
}

