/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui.listcard;

import de.dsite.controller.MainWindowController;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class ListCard
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JButton prev = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_prev));
    private final JButton next = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_next));

    public ListCard(String string) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        this.setVisible(true);
    }

    protected abstract void createComponents();

    public abstract String cardName();

    protected void addComponent(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void addComponentToLeft(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, double d, double d2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = n;
        gridBagConstraints.ipady = n2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void addComponent(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = n5;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void addComponent(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n5;
        gridBagConstraints.ipady = n6;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected void addComponent(Container container, GridBagLayout gridBagLayout, Component component, int n, int n2, int n3, int n4, double d, double d2, Insets insets, int n5) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.insets = insets;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public void addNextButtonListener(ActionListener actionListener) {
        this.getNext().addActionListener(actionListener);
    }

    public void addPrevButtonListener(ActionListener actionListener) {
        this.getPrev().addActionListener(actionListener);
    }

    protected JPanel createControlPanel(CardPanelState cardPanelState) {
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        switch (cardPanelState.getValue()) {
            case 0: {
                jPanel.add(this.getNext());
                break;
            }
            case 1: {
                jPanel.add(this.getNext());
                jPanel.add(this.getPrev());
                break;
            }
            case 2: {
                jPanel.add(this.getPrev());
                break;
            }
            default: {
                jPanel.add(this.getNext());
                jPanel.add(this.getPrev());
            }
        }
        return jPanel;
    }

    public JButton getPrev() {
        return this.prev;
    }

    public JButton getNext() {
        return this.next;
    }

    static enum CardPanelState {
        FIRST_PANEL(0),
        MID_PANEL(1),
        LAST_PANEL(2);

        private final int value;

        private CardPanelState(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

