/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui.listcard;

import de.dsite.controller.CatalogController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.gui.listcard.ListCard;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CatalogCard
extends ListCard {
    private static final long serialVersionUID = 1L;
    private final JTable polTable = new JTable();
    private final JTable surTable = new JTable();
    private final JPanel tableCardPanel = new JPanel(new CardLayout());
    private final JButton addColumn = new JButton("+");
    private final JButton delColumn = new JButton("-");
    private final JButton addCatalogColumn = new JButton("+");
    private final JList<CatalogController.CatalogValue> catalogs = new JList();
    private final JComboBox<CatalogObject> comboBox = new JComboBox();

    public CatalogCard() {
        super(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_title));
        this.createComponents();
    }

    @Override
    protected void createComponents() {
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        this.catalogs.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.catalogs);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_lbl1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane(this.polTable);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        JScrollPane jScrollPane3 = new JScrollPane(this.surTable);
        jScrollPane3.setVerticalScrollBarPolicy(22);
        this.tableCardPanel.add((Component)jScrollPane2, CatalogController.CatalogValue.SCHADSTOFFE.name());
        this.tableCardPanel.add((Component)jScrollPane3, CatalogController.CatalogValue.STOFFE.name());
        this.tableCardPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_catalog_lbl2)), BorderFactory.createEmptyBorder(5, 5, 5, 5)), this.tableCardPanel.getBorder()));
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.comboBox);
        jPanel3.add(this.addCatalogColumn);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add(jPanel3);
        jPanel2.add(this.delColumn);
        jPanel2.add(this.addColumn);
        jPanel.add((Component)this.tableCardPanel, "Center");
        jPanel.add((Component)jPanel2, "Last");
        this.addComponentToLeft(this, gridBagLayout, jScrollPane, 150, 150, 0.0, 0.0);
        this.addComponent((Container)this, gridBagLayout, (Component)jPanel, 1, 0, 1, 1, 1.0, 0.0, 15, 250);
        this.addComponent((Container)this, gridBagLayout, (Component)this.createControlPanel(ListCard.CardPanelState.MID_PANEL), 0, 2, 3, 1, 0.0, 1.0, new Insets(0, 0, 0, 0), 20);
    }

    @Override
    public String cardName() {
        return MainWindowController.InputCardValue.KOMPONENTEN.name();
    }

    public void addCatalogsListSelectionListener(ListSelectionListener listSelectionListener) {
        this.catalogs.addListSelectionListener(listSelectionListener);
    }

    public void addPolTableModel(AbstractTableModel abstractTableModel) {
        this.polTable.setModel(abstractTableModel);
    }

    public void addSurTableModel(AbstractTableModel abstractTableModel) {
        this.surTable.setModel(abstractTableModel);
    }

    public void addComboBoxModel(DefaultComboBoxModel<CatalogObject> defaultComboBoxModel) {
        this.comboBox.setModel(defaultComboBoxModel);
    }

    public void addAddColumnButtonListener(ActionListener actionListener) {
        this.addColumn.addActionListener(actionListener);
    }

    public void addAddFromFileColumnButtonListener(ActionListener actionListener) {
        this.addCatalogColumn.addActionListener(actionListener);
    }

    public void addDelColumnButtonListener(ActionListener actionListener) {
        this.delColumn.addActionListener(actionListener);
    }

    public JTable getPolTable() {
        return this.polTable;
    }

    public JTable getSurTable() {
        return this.surTable;
    }

    public void addListModel(DefaultListModel<CatalogController.CatalogValue> defaultListModel) {
        this.catalogs.setModel(defaultListModel);
    }

    public JPanel getTableCardPanel() {
        return this.tableCardPanel;
    }

    public JList<CatalogController.CatalogValue> getCatalogs() {
        return this.catalogs;
    }
}

