/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.data.Layer;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class TreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private JButton addButton;
    private JButton removeButton;

    public TreePanel() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_lbl1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Layer layer = new Layer(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_rootlayer), 0.0, 0.0);
        this.rootNode = new DefaultMutableTreeNode(layer);
        this.setTreeModel(new DefaultTreeModel(this.rootNode));
        this.getTreeModel().addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.getTreeModel());
        this.tree.setEditable(false);
        this.tree.setFocusable(true);
        this.getTree().getSelectionModel().setSelectionMode(1);
        this.getTree().setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.getTree());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setFocusable(true);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setMinimumSize(this.tree.getMinimumSize());
        jViewport.setPreferredSize(this.tree.getPreferredSize());
        this.add((Component)jScrollPane, "Center");
        this.setAddButton(new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_btn1)));
        this.setRemoveButton(new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_btn2)));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.getAddButton());
        jPanel.add(this.getRemoveButton());
        this.add((Component)jPanel, "Last");
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.getTreeModel().reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.getTreeModel().removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        this.toolkit.beep();
    }

    public int getNumberOfChildNodes() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getChildCount();
        }
        return 0;
    }

    public boolean isSelected() {
        return this.getTree().getSelectionPath() != null;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath treePath = this.getTree().getSelectionPath();
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public boolean isFirstChild() {
        TreePath treePath = this.getTree().getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getPreviousNode().getLevel() < defaultMutableTreeNode.getLevel();
    }

    public boolean isLastChild() {
        TreePath treePath = this.getTree().getSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return defaultMutableTreeNode.getPreviousNode().getLevel() > defaultMutableTreeNode.getLevel();
    }

    public int getLevel() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            return defaultMutableTreeNode.getLevel();
        }
        return -1;
    }

    public boolean addObjectWhenSelected(Object object) {
        if (this.getTree().getSelectionPath() != null) {
            return this.addObject(object);
        }
        return false;
    }

    public boolean addObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.getTree().getSelectionPath();
        defaultMutableTreeNode = treePath == null ? this.rootNode : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return this.addObject(defaultMutableTreeNode, object, true);
    }

    public boolean addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, false);
    }

    public boolean addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        if (defaultMutableTreeNode.getLevel() < 2) {
            this.getTreeModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            if (bl) {
                this.getTree().scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            return true;
        }
        return false;
    }

    public void selectParentNode() {
        if (this.getLevel() > 0) {
            TreePath treePath = this.getTree().getSelectionPath().getParentPath();
            this.tree.setSelectionPath(treePath);
        }
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public void setAddButton(JButton jButton) {
        this.addButton = jButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public void setRemoveButton(JButton jButton) {
        this.removeButton = jButton;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(DefaultTreeModel defaultTreeModel) {
        this.treeModel = defaultTreeModel;
    }

    public void addSelectionChangedListener(TreeSelectionListener treeSelectionListener) {
        this.getTree().addTreeSelectionListener(treeSelectionListener);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public String getRootName() {
        return ((Layer)this.rootNode.getUserObject()).getName();
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            TreePath treePath = new TreePath(defaultMutableTreeNode);
            TreePanel.this.tree.setSelectionPath(treePath);
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            TreePath treePath = treeModelEvent.getTreePath().pathByAddingChild(defaultMutableTreeNode);
            TreePanel.this.tree.setSelectionPath(treePath);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }
}

