/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.data.Series;
import de.dsite.gui.BTCAACPlot;
import de.dsite.gui.ProfileDotPlot;
import de.dsite.gui.ProfilePlot;
import de.dsite.gui.ResultPlot;
import de.dsite.utils.ResourceBundleUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeriesCollection;

public class ResultPlotBuilder {
    public File projectFolder = null;
    String plotTitle = "";
    String xAxisLabel = "";
    String yAxisLabel = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_yaxis);
    double yAxisMaximumValue = 0.0;
    ArrayList<Double> yAxisMaximumValues = new ArrayList();
    ArrayList<String> xAxisSubLabels = new ArrayList();
    ArrayList<String> yAxisSubLabels = new ArrayList();
    ArrayList<XYSeriesCollection> data = new ArrayList();
    ArrayList<XYSeriesCollection> aac = new ArrayList();
    ArrayList<XYSeriesCollection> meas = new ArrayList();
    ArrayList<XYPlot> plots = new ArrayList();
    PlotType plotType = PlotType.LINEPLOT;
    Series.FileType fileType = Series.FileType.BTC;
    private AxisRelation axisRelation = AxisRelation.INDIVIDUAL_VARIABLE;

    private String firstLetterUpperCase(String string) {
        String string2 = "" + string.charAt(0);
        return new String(string2.toUpperCase() + string.substring(1));
    }

    private String labelForUnit(Series.Unit unit) {
        if (unit.equals((Object)Series.Unit.SEC)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_sec);
        }
        if (unit.equals((Object)Series.Unit.MIN)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_min);
        }
        if (unit.equals((Object)Series.Unit.HOUR)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_hour);
        }
        if (unit.equals((Object)Series.Unit.DAY)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_day);
        }
        if (unit.equals((Object)Series.Unit.MONTH)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_month);
        }
        if (unit.equals((Object)Series.Unit.YEAR)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_year);
        }
        if (unit.equals((Object)Series.Unit.LS)) {
            return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_xaxis_ls);
        }
        return "";
    }

    private String ylabelForUnit(Series.Unit unit) {
        return MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_yaxis);
    }

    private void createLabelsForPollutantAndValue(String string, double d, Series.Unit unit) {
        if (this.fileType.equals((Object)Series.FileType.BTC)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_header1) + " " + this.firstLetterUpperCase(string) + ", x = " + d + " m");
            this.xAxisLabel = this.labelForUnit(unit);
            this.yAxisLabel = this.ylabelForUnit(unit);
            if (unit.equals((Object)Series.Unit.LS)) {
                // empty if block
            }
        } else if (this.fileType.equals((Object)Series.FileType.PROFILE)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_header1) + " " + this.firstLetterUpperCase(string) + ", t = " + d + " s");
            this.xAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_xaxis));
            this.yAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_yaxis));
        }
    }

    private void createLabelsForPollutant(String string, Series.Unit unit) {
        if (this.fileType.equals((Object)Series.FileType.BTC)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_header2) + " " + this.firstLetterUpperCase(string));
            this.xAxisLabel = this.labelForUnit(unit);
            this.yAxisLabel = this.ylabelForUnit(unit);
        } else if (this.fileType.equals((Object)Series.FileType.PROFILE)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_header1) + " " + this.firstLetterUpperCase(string));
            this.xAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_xaxis));
            this.yAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_yaxis));
        }
    }

    private void createLabelsForValue(double d, Series.Unit unit) {
        if (this.fileType.equals((Object)Series.FileType.BTC)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_btc_header3) + " x = " + d + " m");
            this.xAxisLabel = this.labelForUnit(unit);
            this.yAxisLabel = this.ylabelForUnit(unit);
        } else if (this.fileType.equals((Object)Series.FileType.PROFILE)) {
            this.plotTitle = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_header2) + " t = " + d + " s");
            this.xAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_xaxis));
            this.yAxisLabel = new String(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.results_profile_yaxis));
        }
    }

    public ResultPlotBuilder setFileType(Series.FileType fileType) {
        this.fileType = fileType;
        return this;
    }

    public ResultPlotBuilder setPlotType(PlotType plotType) {
        this.plotType = plotType;
        return this;
    }

    public ResultPlotBuilder setMaximumYAxis(double d) {
        this.yAxisMaximumValue = d;
        return this;
    }

    public ResultPlotBuilder setMaximumYAxis(ArrayList<Double> arrayList) {
        this.yAxisMaximumValues = arrayList;
        return this;
    }

    private ResultPlotBuilder setLabels(Set<Series> set) {
        Series series5;
        Object object;
        Object[] objectArray = set.toArray();
        Series series2 = (Series)objectArray[0];
        if (set.size() == 3 && series2.isFileTypeProfile()) {
            object = (Series)objectArray[1];
            series5 = (Series)objectArray[2];
            if (!(series2.getProfileType().equals((Object)((Series)object).getProfileType()) || series2.getProfileType().equals((Object)series5.getProfileType()) || ((Series)object).getProfileType().equals((Object)series5.getProfileType()))) {
                this.createLabelsForPollutantAndValue(((Series)objectArray[0]).getNameOfPollutant(), ((Series)objectArray[0]).getObservationValue(), ((Series)objectArray[0]).getUnit());
                return this;
            }
        }
        if (set.size() == 5 && series2.isFileTypeProfile()) {
            object = (Series)objectArray[1];
            series5 = (Series)objectArray[2];
            Series series3 = (Series)objectArray[3];
            Series series4 = (Series)objectArray[4];
            if (!(series2.getProfileType().equals((Object)((Series)object).getProfileType()) || series2.getProfileType().equals((Object)series5.getProfileType()) || series2.getProfileType().equals((Object)series3.getProfileType()) || series2.getProfileType().equals((Object)series4.getProfileType()) || ((Series)object).getProfileType().equals((Object)series5.getProfileType()) || ((Series)object).getProfileType().equals((Object)series3.getProfileType()) || ((Series)object).getProfileType().equals((Object)series4.getProfileType()) || series5.getProfileType().equals((Object)series3.getProfileType()) || series5.getProfileType().equals((Object)series4.getProfileType()) || series3.getProfileType().equals((Object)series4.getProfileType()))) {
                this.createLabelsForPollutantAndValue(((Series)objectArray[0]).getNameOfPollutant(), ((Series)objectArray[0]).getObservationValue(), ((Series)objectArray[0]).getUnit());
                return this;
            }
        }
        if (set.size() > 1) {
            for (Series series5 : set) {
                if (series2.getNameOfPollutant().equals(series5.getNameOfPollutant())) continue;
                this.createLabelsForValue(series2.getObservationValue(), series2.getUnit());
                return this;
            }
            this.createLabelsForPollutant(series2.getNameOfPollutant(), series2.getUnit());
            return this;
        }
        if (set.size() == 1) {
            this.createLabelsForPollutantAndValue(((Series)objectArray[0]).getNameOfPollutant(), ((Series)objectArray[0]).getObservationValue(), ((Series)objectArray[0]).getUnit());
        }
        return this;
    }

    public ResultPlotBuilder setData(Set<Series> set) {
        if (set != null && set.size() > 0) {
            this.data.clear();
            this.aac.clear();
            this.meas.clear();
            this.xAxisSubLabels.clear();
            this.yAxisSubLabels.clear();
            this.setLabels(set);
            Iterator<Series> iterator = set.iterator();
            if (this.fileType.equals((Object)Series.FileType.BTC) || this.fileType.equals((Object)Series.FileType.AAC)) {
                XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection3 = new XYSeriesCollection();
                while (iterator.hasNext()) {
                    Series series = iterator.next();
                    if (series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) {
                        if (series.getFileType().equals((Object)Series.FileType.BTC)) {
                            xYSeriesCollection.addSeries(series.getXYSeries());
                            continue;
                        }
                        if (!series.getFileType().equals((Object)Series.FileType.AAC)) continue;
                        xYSeriesCollection2.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (!series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
                    xYSeriesCollection3.addSeries(series.getXYSeries());
                }
                this.data.add(xYSeriesCollection);
                this.aac.add(xYSeriesCollection2);
                this.meas.add(xYSeriesCollection3);
                return this;
            }
            if (this.fileType.equals((Object)Series.FileType.PROFILE)) {
                XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection4 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection5 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection6 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection7 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection8 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection9 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection10 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection11 = new XYSeriesCollection();
                XYSeriesCollection xYSeriesCollection12 = new XYSeriesCollection();
                while (iterator.hasNext()) {
                    Series series = iterator.next();
                    if (series.getOrigin().equals((Object)Series.OriginType.FORTRAN)) {
                        if (series.getProfileType().equals((Object)Series.ProfileType.DISS)) {
                            xYSeriesCollection.addSeries(series.getXYSeries());
                            continue;
                        }
                        if (series.getProfileType().equals((Object)Series.ProfileType.SORB)) {
                            xYSeriesCollection4.addSeries(series.getXYSeries());
                            continue;
                        }
                        if (series.getProfileType().equals((Object)Series.ProfileType.DIFF)) {
                            xYSeriesCollection5.addSeries(series.getXYSeries());
                            continue;
                        }
                        if (series.getProfileType().equals((Object)Series.ProfileType.MIC)) {
                            xYSeriesCollection6.addSeries(series.getXYSeries());
                            continue;
                        }
                        if (!series.getProfileType().equals((Object)Series.ProfileType.MONO)) continue;
                        xYSeriesCollection7.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (!series.getOrigin().equals((Object)Series.OriginType.MEAS)) continue;
                    if (series.getProfileType().equals((Object)Series.ProfileType.DISS)) {
                        xYSeriesCollection8.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (series.getProfileType().equals((Object)Series.ProfileType.SORB)) {
                        xYSeriesCollection9.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (series.getProfileType().equals((Object)Series.ProfileType.DIFF)) {
                        xYSeriesCollection10.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (series.getProfileType().equals((Object)Series.ProfileType.MIC)) {
                        xYSeriesCollection11.addSeries(series.getXYSeries());
                        continue;
                    }
                    if (!series.getProfileType().equals((Object)Series.ProfileType.MONO)) continue;
                    xYSeriesCollection12.addSeries(series.getXYSeries());
                }
                if (xYSeriesCollection.getSeriesCount() > 0) {
                    this.data.add(xYSeriesCollection);
                    this.yAxisSubLabels.add("DISS");
                }
                if (xYSeriesCollection4.getSeriesCount() > 0) {
                    this.data.add(xYSeriesCollection4);
                    this.yAxisSubLabels.add("SORB");
                }
                if (xYSeriesCollection5.getSeriesCount() > 0) {
                    this.data.add(xYSeriesCollection5);
                    this.yAxisSubLabels.add("DIFF");
                }
                if (xYSeriesCollection6.getSeriesCount() > 0) {
                    this.data.add(xYSeriesCollection6);
                    this.yAxisSubLabels.add("MIC");
                }
                if (xYSeriesCollection7.getSeriesCount() > 0) {
                    this.data.add(xYSeriesCollection7);
                    this.yAxisSubLabels.add("MONO");
                }
                if (xYSeriesCollection8.getSeriesCount() > 0) {
                    this.meas.add(xYSeriesCollection8);
                    this.yAxisSubLabels.add("DISS(Meas)");
                }
                if (xYSeriesCollection9.getSeriesCount() > 0) {
                    this.meas.add(xYSeriesCollection9);
                    this.yAxisSubLabels.add("SORB(Meas)");
                }
                if (xYSeriesCollection10.getSeriesCount() > 0) {
                    this.meas.add(xYSeriesCollection10);
                    this.yAxisSubLabels.add("DIFF(Meas)");
                }
                if (xYSeriesCollection11.getSeriesCount() > 0) {
                    this.meas.add(xYSeriesCollection11);
                    this.yAxisSubLabels.add("MIC(Meas)");
                }
                if (xYSeriesCollection12.getSeriesCount() > 0) {
                    this.meas.add(xYSeriesCollection12);
                    this.yAxisSubLabels.add("MONO(Meas)");
                }
            }
            return null;
        }
        return null;
    }

    public ResultPlot create() {
        if (this.data.size() > 0) {
            if (this.data.size() != this.meas.size()) {
                System.err.println("ResultPlotBuilder.create(): Size of data and meas unequal!");
            }
            if (this.fileType.equals((Object)Series.FileType.BTC)) {
                if (this.meas.size() > 0) {
                    return new BTCAACPlot(this.data.get(0), this.aac.get(0), this.meas.get(0), this.plotTitle, this.xAxisLabel, this.yAxisLabel, this.xAxisSubLabels, this.yAxisMaximumValue, false, this.projectFolder);
                }
                return new BTCAACPlot(this.data.get(0), this.aac.get(0), null, this.plotTitle, this.xAxisLabel, this.yAxisLabel, this.xAxisSubLabels, this.yAxisMaximumValue, false, this.projectFolder);
            }
            if (this.fileType.equals((Object)Series.FileType.PROFILE) && this.plotType.equals((Object)PlotType.LINEPLOT)) {
                if (this.meas.size() > 0) {
                    switch (this.getAxisRelation()) {
                        case INDIVIDUAL_VARIABLE: {
                            return new ProfilePlot(this.data, this.meas, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValue, true);
                        }
                        case GENERAL: {
                            return new ProfilePlot(this.data, this.meas, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValue, false);
                        }
                        case INDIVIDUAL_CONSTANT: {
                            return new ProfilePlot(this.data, this.meas, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValues);
                        }
                    }
                } else {
                    switch (this.getAxisRelation()) {
                        case INDIVIDUAL_VARIABLE: {
                            return new ProfilePlot(this.data, null, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValue, true);
                        }
                        case GENERAL: {
                            return new ProfilePlot(this.data, null, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValue, false);
                        }
                        case INDIVIDUAL_CONSTANT: {
                            return new ProfilePlot(this.data, null, new String(this.plotTitle + " (mg/m3)"), this.xAxisLabel, this.yAxisLabel, this.yAxisSubLabels, this.yAxisMaximumValues);
                        }
                    }
                }
            } else {
                if (this.fileType.equals((Object)Series.FileType.PROFILE) && this.plotType.equals((Object)PlotType.DOTPLOT)) {
                    if (this.meas.size() > 0) {
                        return new ProfileDotPlot(this.data.get(0), this.meas.get(0), this.plotTitle, this.xAxisLabel, this.yAxisLabel, this.yAxisMaximumValue);
                    }
                    return new ProfileDotPlot(this.data.get(0), null, this.plotTitle, this.xAxisLabel, this.yAxisLabel, this.yAxisMaximumValue);
                }
                System.err.println("Filetype '" + (Object)((Object)this.fileType) + "' is not supported!");
            }
        }
        return null;
    }

    public AxisRelation getAxisRelation() {
        return this.axisRelation;
    }

    public void setAxisRelation(AxisRelation axisRelation) {
        this.axisRelation = axisRelation;
    }

    public static enum AxisRelation {
        INDIVIDUAL_VARIABLE,
        INDIVIDUAL_CONSTANT,
        GENERAL;


        public String toString() {
            return MainWindowController.resourceManager.getLangString(AxisRelation.valueOf(AxisRelation.class, super.toString()));
        }
    }

    public static enum PlotType {
        LINEPLOT,
        DOTPLOT;

    }
}

