/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.gui.ResultPlot;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class ProfileDotPlot
extends ResultPlot {
    private static final long serialVersionUID = 1L;
    private JFreeChart chart;

    public ProfileDotPlot(XYSeriesCollection xYSeriesCollection, XYSeriesCollection xYSeriesCollection2, String string, String string2, String string3, double d) {
        JFreeChart jFreeChart;
        int n;
        if (xYSeriesCollection.getSeriesCount() != xYSeriesCollection2.getSeriesCount()) {
            System.err.println("ProfileDotPlot: number of series in data and meas doesn't match");
        }
        XYSeriesCollection xYSeriesCollection3 = new XYSeriesCollection();
        for (n = 0; n < xYSeriesCollection.getSeriesCount(); ++n) {
            xYSeriesCollection3.addSeries(xYSeriesCollection.getSeries(n));
        }
        for (n = 0; n < xYSeriesCollection2.getSeriesCount(); ++n) {
            xYSeriesCollection3.addSeries(xYSeriesCollection2.getSeries(n));
        }
        this.chart = jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYSeriesCollection3, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new Color(238, 238, 238));
        double d2 = xYSeriesCollection.getRangeUpperBound(true);
        if (d2 == 0.0) {
            d2 = 0.0;
        }
        if (d > d2) {
            d2 = d;
        }
        if (d != 0.0) {
            this.setYAxisMaximum(d2);
        }
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        for (int i = 0; i < xYSeriesCollection3.getSeriesCount(); ++i) {
            if (i < xYSeriesCollection.getSeriesCount()) {
                xYLineAndShapeRenderer.setBaseShapesFilled(true);
                xYLineAndShapeRenderer.setBaseShapesVisible(true);
                xYLineAndShapeRenderer.setSeriesPaint(i, this.colors[i]);
                continue;
            }
            xYLineAndShapeRenderer.setBaseShapesFilled(true);
            xYLineAndShapeRenderer.setBaseShapesVisible(true);
            xYLineAndShapeRenderer.setSeriesVisibleInLegend(i, (Boolean)false);
            xYLineAndShapeRenderer.setSeriesPaint(i, this.colors[i - xYSeriesCollection.getSeriesCount()]);
            xYLineAndShapeRenderer.setSeriesStroke(i, new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f));
        }
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
    }

    public void setYAxisMaximum(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        NumberAxis numberAxis = new NumberAxis(xYPlot.getRangeAxis().getLabel());
        numberAxis.setRange(0.0, d);
        numberAxis.setTickLabelFont(xYPlot.getDomainAxis().getTickLabelFont());
        numberAxis.setLabelFont(xYPlot.getDomainAxis().getTickLabelFont());
        xYPlot.setRangeAxis(numberAxis);
    }
}

