/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.data.ObservedProject;
import de.dsite.gui.ChartEditor;
import de.dsite.gui.ChartPlot;
import de.dsite.gui.ProjectListener;
import de.dsite.project.SecondaryLayer;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class Plotter
extends JPanel
implements ProjectListener {
    private static final long serialVersionUID = 1L;
    private ChartPlot plot;
    private ChartEditor editor;
    private ObservedProject subject;

    public Plotter(ObservedProject observedProject, String string) {
        super(new GridLayout(1, 0, 10, 10));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(string), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.subject = observedProject;
        this.subject.addListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        this.plot = new ChartPlot();
        this.plot.setBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_lbl1)));
        this.plot.setVisible(true);
        jPanel.add((Component)this.plot, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.editor = new ChartEditor();
        this.editor.setBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_lbl2)));
        jPanel2.add(this.editor);
        this.add(jPanel);
        this.add(jPanel2);
        this.setVisible(true);
    }

    public void updateSubject(ObservedProject observedProject) {
        this.subject = observedProject;
        this.subject.addListener(this);
    }

    public ChartPlot getChartPlot() {
        return this.plot;
    }

    public ChartEditor getEditor() {
        return this.editor;
    }

    @Override
    public void updateWithData(ArrayList<?> arrayList) {
        if (arrayList != null && arrayList.size() > 0 && arrayList.get(0) instanceof SecondaryLayer) {
            this.plot.updateChart(arrayList);
            this.editor.updateData(arrayList);
        }
    }
}

