/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.utils.FileUtils;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class NewProjectDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final String btnOK = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_ok);
    private final String btnAB = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_abort);
    private File newProject = null;
    private JOptionPane optionPane;
    private JTextField textField;
    private JTextField textFieldPath;

    public NewProjectDialog(JFrame jFrame) {
        super(jFrame, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_new_title), true);
        JPanel jPanel = this.createContent();
        Object[] objectArray = new Object[]{this.btnOK, this.btnAB};
        this.optionPane = new JOptionPane(jPanel, -1, 0, null, objectArray, objectArray[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewProjectDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.optionPane.addPropertyChangeListener(this);
    }

    private JPanel createContent() {
        final JButton jButton = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_select));
        this.textField = new JTextField(20);
        JPanel jPanel = new JPanel();
        jPanel.add(this.textField);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_new_lbl1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        final JRadioButton jRadioButton = new JRadioButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_new_rbtn1));
        final JRadioButton jRadioButton2 = new JRadioButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_new_rbtn2));
        jRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton.isSelected()) {
                    NewProjectDialog.this.textFieldPath.setEnabled(false);
                    jButton.setEnabled(false);
                }
            }
        });
        buttonGroup.add(jRadioButton2);
        jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jRadioButton2.isSelected()) {
                    NewProjectDialog.this.textFieldPath.setEnabled(true);
                    jButton.setEnabled(true);
                }
            }
        });
        this.textFieldPath = new JTextField(20);
        final File file = FileUtils.getExapmlesFolder();
        String string = file.getAbsolutePath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        this.textFieldPath.setText(string);
        this.textFieldPath.setEnabled(true);
        this.textFieldPath.setSize(100, 30);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file2;
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "Verzeichnis";
                    }
                });
                int n = jFileChooser.showOpenDialog(NewProjectDialog.this);
                if (n == 0 && (file2 = jFileChooser.getSelectedFile()).canWrite()) {
                    NewProjectDialog.this.textFieldPath.setText(file2.getPath());
                }
            }
        });
        jButton.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.textFieldPath);
        jPanel3.add(jButton);
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.textFieldPath.setEnabled(false);
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_window_new_lbl2)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel, "First");
        jPanel5.add((Component)jPanel4, "After");
        jPanel5.setVisible(true);
        return jPanel5;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.optionPane && string.equals("value")) {
            Object object = this.optionPane.getValue();
            if (object == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.btnOK.equals(object)) {
                boolean bl = this.validateUserInput();
                if (bl) {
                    this.textField.setText(null);
                    this.setVisible(false);
                } else {
                    this.textField.selectAll();
                    JOptionPane.showMessageDialog(this, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_file_exists_line1) + "\n" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error_dialog_file_exists_line2) + "\n", MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.error), 0);
                    this.textField.setText(null);
                    this.textField.requestFocusInWindow();
                }
            } else {
                this.textField.setText(null);
                this.setVisible(false);
            }
        }
    }

    private boolean validateUserInput() {
        String string = this.textFieldPath.getText();
        String string2 = this.textField.getText();
        if (!string2.equals("")) {
            File file;
            if (!string2.equals(string2.replaceAll(" ", ""))) {
                string2 = string2.replaceAll(" ", "");
            }
            if (!string2.toLowerCase().endsWith(".ser")) {
                string2 = string2.concat(".ser");
            }
            if (!(file = new File(string, string2)).exists()) {
                this.newProject = file;
                return true;
            }
            return false;
        }
        return false;
    }

    public File getNewProject() {
        return this.newProject;
    }
}

