/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.gui.FortranPanel;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JMenu fileMenu = new JMenu(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_file));
    private final JMenu settingsMenu = new JMenu(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_settings));
    private final JMenu helpMenu = new JMenu(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_help));
    private JMenuItem newItem;
    private JMenuItem loadProjectItem;
    private JMenuItem saveWithoutDialogItem;
    private JMenuItem saveProjectItem;
    private JMenuItem prepareItem;
    private JMenuItem startItem;
    private JMenuItem runItem;
    private JMenuItem exitItem;
    private JMenuItem helpItem;
    private JMenuItem aboutItem;
    private JMenuItem unitsItem;
    private JMenuItem axisrangeItem;
    private JMenuItem languageItem;
    private JList<MainWindowController.InputCardValue> inputList;
    private JList<MainWindowController.OutputCardValue> outputList;
    private boolean[] listItemEnabledFlags;
    private boolean[] listItemEnabledFlagsOutput;
    private JScrollPane inputpane;
    private JScrollPane outputpane;
    private JTabbedPane tabbedPane;
    private JPanel tab1;
    private JPanel tab2;
    private JPanel tab3;
    private JPanel tab4;

    public MainWindow(MainWindowController mainWindowController) {
        super("WinSMART");
        Dimension dimension;
        this.setFocusable(true);
        this.setDefaultCloseOperation(3);
        try {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (HeadlessException headlessException) {
            dimension = new Dimension(1200, 800);
        }
        this.setSize(dimension.width, dimension.height);
        Image image = Toolkit.getDefaultToolkit().getImage("icons/Letter-S-icon32px.png");
        this.setIconImage(image);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createNorth();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.createWest();
        this.add((Component)jPanel2, "West");
        this.add((Component)this.createCenter(), "Center");
        this.add((Component)this.createButtonPanel(), "South");
        this.setVisible(true);
    }

    private JPanel createNorth() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        this.newItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_new));
        this.loadProjectItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_open));
        this.saveWithoutDialogItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_save));
        this.saveProjectItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_save_as));
        this.prepareItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_calculate_prepare));
        this.startItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_calculate_start));
        this.runItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_calculate));
        this.exitItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_quit));
        this.fileMenu.add(this.newItem);
        this.fileMenu.add(this.loadProjectItem);
        this.fileMenu.add(this.saveWithoutDialogItem);
        this.fileMenu.add(this.saveProjectItem);
        this.fileMenu.add(this.startItem);
        this.fileMenu.add(this.runItem);
        this.fileMenu.add(this.exitItem);
        this.helpItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_manual));
        this.aboutItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_about));
        this.languageItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_lang));
        this.helpMenu.add(this.helpItem);
        this.helpMenu.add(this.aboutItem);
        this.unitsItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_units));
        this.axisrangeItem = new JMenuItem(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_axisrange));
        this.settingsMenu.add(this.unitsItem);
        this.settingsMenu.add(this.axisrangeItem);
        jMenuBar.add(this.fileMenu);
        jMenuBar.add(this.settingsMenu);
        jMenuBar.add(this.helpMenu);
        jPanel.add((Component)jMenuBar, "North");
        return jPanel;
    }

    public JPanel createWest() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        int n2 = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = n2;
        gridBagConstraints.ipady = n2;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        this.inputList = new JList();
        this.getInputList().setSelectionMode(0);
        this.inputList.setSelectionModel(new DisabledItemSelectionModel());
        this.inputList.setCellRenderer(new DisabledItemListCellRenderer());
        this.getInputList().setVisibleRowCount(10);
        this.getInputList().setSelectedIndex(0);
        this.inputpane = new JScrollPane(this.getInputList());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 9;
        this.inputpane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_list)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)this.inputpane, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        this.outputList = new JList();
        this.outputList.setSelectionMode(0);
        this.outputList.setVisibleRowCount(5);
        this.outputList.setSelectionModel(new DisabledItemSelectionModelOutput());
        this.outputList.setCellRenderer(new DisabledItemListCellRendererOutput());
        this.outputpane = new JScrollPane(this.outputList);
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridheight = 2;
        this.outputpane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.output_list)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)this.outputpane, gridBagConstraints);
        return jPanel;
    }

    public void disableListItemAtIndex(int n) {
        if (n >= 0 && n < this.listItemEnabledFlags.length) {
            this.listItemEnabledFlags[n] = false;
            this.inputList.updateUI();
        }
    }

    public void enableListItemAtIndex(int n) {
        if (n >= 0 && n < this.listItemEnabledFlags.length) {
            this.listItemEnabledFlags[n] = true;
            this.inputList.updateUI();
        }
    }

    public void disableOutputListItemAtIndex(int n) {
        if (n >= 0 && n < this.listItemEnabledFlagsOutput.length) {
            this.listItemEnabledFlagsOutput[n] = false;
            this.outputList.updateUI();
        }
    }

    public void enableOutputListItemAtIndex(int n) {
        if (n >= 0 && n < this.listItemEnabledFlagsOutput.length) {
            this.listItemEnabledFlagsOutput[n] = true;
            this.outputList.updateUI();
        }
    }

    public void disableOutputListItems() {
        for (int i = 0; i < this.listItemEnabledFlagsOutput.length; ++i) {
            this.listItemEnabledFlagsOutput[i] = false;
        }
        this.outputList.updateUI();
    }

    public void disableOutputListItemsButLast() {
        for (int i = 0; i < this.listItemEnabledFlagsOutput.length - 1; ++i) {
            this.listItemEnabledFlagsOutput[i] = false;
        }
        this.outputList.updateUI();
    }

    private JPanel createCenter() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 5;
        int n2 = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = n2;
        gridBagConstraints.ipady = n2;
        gridBagConstraints.insets = new Insets(n, n, n, n);
        gridBagConstraints.fill = 1;
        this.tab1 = new JPanel(new CardLayout());
        this.tab2 = new JPanel(new BorderLayout());
        this.tab2.setName(TabValue.INPUTPANEL.name());
        this.tab3 = new JPanel(new CardLayout());
        this.tab4 = new FortranPanel();
        this.tabbedPane = this.createTabbedPane();
        jPanel.add((Component)this.tabbedPane, gridBagConstraints);
        return jPanel;
    }

    public void updateTabNames() {
        this.tabbedPane.setTitleAt(0, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab1));
        this.tabbedPane.setTitleAt(1, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab2));
        this.tabbedPane.setTitleAt(2, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab3));
        this.tabbedPane.setTitleAt(3, MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab4));
    }

    public void updateMenu() {
        this.fileMenu.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_file));
        this.helpMenu.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_help));
        this.newItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_new));
        this.loadProjectItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_open));
        this.saveWithoutDialogItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_save));
        this.saveProjectItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_save_as));
        this.runItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_calculate));
        this.newItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_new));
        this.exitItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_quit));
        this.helpItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_manual));
        this.aboutItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_about));
        this.languageItem.setText(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.menu_lang));
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab1), this.tab1);
        jTabbedPane.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab2), this.tab2);
        jTabbedPane.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab3), this.tab3);
        jTabbedPane.add(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.center_tab4), this.tab4);
        return jTabbedPane;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    public void addMenuItemNewListener(ActionListener actionListener) {
        this.newItem.addActionListener(actionListener);
    }

    public void addMenuItemLoadProjectListener(ActionListener actionListener) {
        this.loadProjectItem.addActionListener(actionListener);
    }

    public void addMenuItemSaveWithoutDialogListener(ActionListener actionListener) {
        this.saveWithoutDialogItem.addActionListener(actionListener);
    }

    public void addMenuItemSaveProjectListener(ActionListener actionListener) {
        this.saveProjectItem.addActionListener(actionListener);
    }

    public void addMenuItemPrepareListener(ActionListener actionListener) {
        this.prepareItem.addActionListener(actionListener);
    }

    public void addMenuItemStartListener(ActionListener actionListener) {
        this.startItem.addActionListener(actionListener);
    }

    public void addMenuItemRunListener(ActionListener actionListener) {
        this.runItem.addActionListener(actionListener);
    }

    public void addMenuItemExitListener(ActionListener actionListener) {
        this.exitItem.addActionListener(actionListener);
    }

    public void addMenuItemHelpBookListener(ActionListener actionListener) {
        this.helpItem.addActionListener(actionListener);
    }

    public void addMenuItemAboutListener(ActionListener actionListener) {
        this.aboutItem.addActionListener(actionListener);
    }

    public void addMenuItemUnitsListener(ActionListener actionListener) {
        this.unitsItem.addActionListener(actionListener);
    }

    public void addMenuItemAxisRangeListener(ActionListener actionListener) {
        this.axisrangeItem.addActionListener(actionListener);
    }

    public void addMenuItemLanguageListener(ActionListener actionListener) {
        this.languageItem.addActionListener(actionListener);
    }

    public void addInputListModel(DefaultListModel<MainWindowController.InputCardValue> defaultListModel) {
        this.inputList.setModel(defaultListModel);
        this.listItemEnabledFlags = new boolean[defaultListModel.size()];
        for (int i = 0; i < defaultListModel.size(); ++i) {
            this.listItemEnabledFlags[i] = true;
        }
    }

    public void addInputListSelectionListener(ListSelectionListener listSelectionListener) {
        this.inputList.addListSelectionListener(listSelectionListener);
    }

    public void addInputListFocusListener(FocusListener focusListener) {
        this.inputList.addFocusListener(focusListener);
    }

    public void addInputListMouseListener(MouseListener mouseListener) {
        this.inputList.addMouseListener(mouseListener);
    }

    public void addOutputListModel(DefaultListModel<MainWindowController.OutputCardValue> defaultListModel) {
        this.outputList.setModel(defaultListModel);
        this.listItemEnabledFlagsOutput = new boolean[defaultListModel.size()];
        for (int i = 0; i < defaultListModel.size(); ++i) {
            this.listItemEnabledFlagsOutput[i] = false;
        }
    }

    public void addOutputListSelectionListener(ListSelectionListener listSelectionListener) {
        this.outputList.addListSelectionListener(listSelectionListener);
    }

    public void addOutputListFocusListener(FocusListener focusListener) {
        this.outputList.addFocusListener(focusListener);
    }

    public void addOutputListMouseListener(MouseListener mouseListener) {
        this.outputList.addMouseListener(mouseListener);
    }

    public void addCardToInputPanel(Component component, Object object) {
        this.tab1.add(component, object);
    }

    public void addCardToResultPanel(Component component, Object object) {
        this.tab3.add(component, object);
    }

    public void addTabChangeListener(ChangeListener changeListener) {
        this.tabbedPane.addChangeListener(changeListener);
    }

    public void showTab(TabValue tabValue) {
        this.tabbedPane.setSelectedIndex(tabValue.getIndex());
    }

    public void setListItemEnabled(int n, boolean bl) {
        this.outputList.getComponent(n).setEnabled(bl);
    }

    public void setAllListItemsEnabled(boolean bl) {
        for (int i = 0; i < this.outputList.getModel().getSize(); ++i) {
            this.outputList.getComponent(i).setEnabled(bl);
        }
    }

    public void setInputList(JList<MainWindowController.InputCardValue> jList) {
        this.inputList = jList;
    }

    public JList<MainWindowController.InputCardValue> getInputList() {
        return this.inputList;
    }

    public JPanel getTab1() {
        return this.tab1;
    }

    public JPanel getTab2() {
        return this.tab2;
    }

    public void setTab2(JPanel jPanel) {
        this.tab2.add(jPanel);
    }

    public JPanel getTab3() {
        return this.tab3;
    }

    public JPanel getTab4() {
        return this.tab4;
    }

    public void setMenuItemsRunEnabled(boolean bl) {
        this.runItem.setEnabled(bl);
        this.startItem.setEnabled(bl);
    }

    private class DisabledItemSelectionModelOutput
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1L;

        private DisabledItemSelectionModelOutput() {
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (MainWindow.this.listItemEnabledFlagsOutput[n2]) {
                super.setSelectionInterval(n, n);
            }
        }
    }

    private class DisabledItemListCellRendererOutput
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private DisabledItemListCellRendererOutput() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            if (MainWindow.this.listItemEnabledFlagsOutput[n]) {
                return super.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
            Component component = super.getListCellRendererComponent(jList, object, n, false, false);
            component.setEnabled(false);
            return component;
        }
    }

    private class DisabledItemSelectionModel
    extends DefaultListSelectionModel {
        private static final long serialVersionUID = 1L;

        private DisabledItemSelectionModel() {
        }

        @Override
        public void setSelectionInterval(int n, int n2) {
            if (MainWindow.this.listItemEnabledFlags[n2]) {
                super.setSelectionInterval(n, n);
            } else if (this.getAnchorSelectionIndex() < n) {
                for (int i = n; i < MainWindow.this.listItemEnabledFlags.length; ++i) {
                    if (!MainWindow.this.listItemEnabledFlags[i]) continue;
                    super.setSelectionInterval(i, i);
                    return;
                }
            } else {
                for (int i = n; i >= 0; --i) {
                    if (!MainWindow.this.listItemEnabledFlags[i]) continue;
                    super.setSelectionInterval(i, i);
                    return;
                }
            }
        }
    }

    private class DisabledItemListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private DisabledItemListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            if (MainWindow.this.listItemEnabledFlags[n]) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                component.setVisible(false);
                return component;
            }
            Component component = super.getListCellRendererComponent(jList, object, n, false, false);
            component.setEnabled(false);
            return component;
        }
    }

    public static enum TabValue {
        INPUTPANEL(0),
        STATUSPANEL(1),
        OUTPUTPANEL(2),
        FORTRANLOGPANEL(3);

        private final int index;

        private TabValue(int n2) {
            this.index = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return MainWindowController.resourceManager.getLangString(TabValue.valueOf(TabValue.class, super.toString()));
        }
    }
}

