/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FortranPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JProgressBar fProgressBar;
    private JTextArea fLogArea;
    private JButton fCancelBtn;

    public FortranPanel() {
        this.setLayout(new BorderLayout());
        this.fProgressBar = this.createAndInitProgressBar();
        this.fCancelBtn = new JButton(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.btn_abort));
        this.fLogArea = new JTextArea();
        this.fLogArea.setEditable(false);
        this.fLogArea.setLineWrap(true);
        this.fLogArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.fLogArea);
        jScrollPane.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel();
        jPanel.add(this.fProgressBar);
        jPanel.add(this.fCancelBtn);
        this.add((Component)jPanel, "First");
        this.add((Component)jScrollPane, "Center");
    }

    private JProgressBar createAndInitProgressBar() {
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setValue(0);
        jProgressBar.setStringPainted(true);
        return jProgressBar;
    }

    public void setProgress(int n) {
        this.fProgressBar.setValue(n);
    }

    public void clearLogArea() {
        this.fLogArea.setText("");
    }

    public void appendLineToLogArea(String string) {
        this.fLogArea.append(string + "\n");
    }

    public void enableFCancelButton() {
        this.fCancelBtn.setEnabled(true);
    }

    public void disableFCancelButton() {
        this.fCancelBtn.setEnabled(false);
    }

    public void addFCancelButtonActionListener(ActionListener actionListener) {
        this.fCancelBtn.addActionListener(actionListener);
    }
}

