/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.data.Layer;
import de.dsite.data.SecondaryLayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    protected JButton addButton;
    protected JButton removeButton;
    final String ADD_COMMAND = "add";
    final String REMOVE_COMMAND = "remove";
    private DefaultMutableTreeNode selectedNode;
    private Layer selectedLayer;

    public DynamicTree() {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Schichtexplorer"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.selectedLayer = new Layer("root", 0.0, 0.0);
        this.rootNode = new DefaultMutableTreeNode(this.selectedLayer);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        TreePath treePath = new TreePath(this.rootNode);
        this.tree.setSelectionPath(treePath);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DynamicTree.this.selectedNode = (DefaultMutableTreeNode)DynamicTree.this.tree.getLastSelectedPathComponent();
                if (DynamicTree.this.selectedNode == null) {
                    return;
                }
                DynamicTree.this.selectedLayer = (Layer)DynamicTree.this.selectedNode.getUserObject();
            }
        });
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)jScrollPane, "First");
        TreeButtonListener treeButtonListener = new TreeButtonListener();
        this.addButton = new JButton("Neu");
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(treeButtonListener);
        this.removeButton = new JButton("Entfernen");
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(treeButtonListener);
        JPanel jPanel = new JPanel();
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        this.add((Component)jPanel, "After");
    }

    public DynamicTree(ArrayList<Layer> arrayList) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Schichtexplorer"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.selectedLayer = new Layer("root", 0.0, 0.0);
        this.rootNode = new DefaultMutableTreeNode(this.selectedLayer);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.treeModel.addTreeModelListener(new MyTreeModelListener());
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        if (arrayList != null) {
            this.arrayListToTree(arrayList);
        }
        TreePath treePath = new TreePath(this.rootNode);
        this.tree.setSelectionPath(treePath);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DynamicTree.this.selectedNode = (DefaultMutableTreeNode)DynamicTree.this.tree.getLastSelectedPathComponent();
                if (DynamicTree.this.selectedNode == null) {
                    return;
                }
                DynamicTree.this.selectedLayer = (Layer)DynamicTree.this.selectedNode.getUserObject();
            }
        });
        this.tree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.add((Component)jScrollPane, "First");
        TreeButtonListener treeButtonListener = new TreeButtonListener();
        this.addButton = new JButton("Neu");
        this.addButton.setActionCommand("add");
        this.addButton.addActionListener(treeButtonListener);
        this.removeButton = new JButton("Entfernen");
        this.removeButton.setActionCommand("remove");
        this.removeButton.addActionListener(treeButtonListener);
        JPanel jPanel = new JPanel();
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        this.add((Component)jPanel, "After");
    }

    public JTree getTree() {
        return this.tree;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public Layer getSelectedLayer() {
        return this.selectedLayer;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setLayer(Layer layer) {
        this.selectedLayer = layer;
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
        this.toolkit.beep();
    }

    public DefaultMutableTreeNode addObject(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.tree.getSelectionPath();
        defaultMutableTreeNode = treePath == null ? this.rootNode : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        return this.addObject(defaultMutableTreeNode, object, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        return this.addObject(defaultMutableTreeNode, object, false);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return defaultMutableTreeNode2;
    }

    public boolean isTreeValid() {
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            double d;
            Layer layer = (Layer)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            double d2 = layer.getXOK();
            if (d2 > (d = layer.getXUK())) {
                JOptionPane.showMessageDialog(null, "Fehler im erzeugten Baum: \nOberkante kleiner oder gleich Unterkante!", "Fehler", 0);
                return false;
            }
            if (d == 0.0) {
                JOptionPane.showMessageDialog(null, "Fehler im erzeugten Baum: \nUnterkante = 0 nicht erlaut!", "Fehler", 0);
                return false;
            }
            while (enumeration.hasMoreElements()) {
                layer = (Layer)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (layer.getXOK() == d2 && layer.getXUK() <= d) {
                    d = layer.getXUK();
                    continue;
                }
                if (layer.getXOK() == d) {
                    d2 = layer.getXOK();
                    d = layer.getXUK();
                    continue;
                }
                JOptionPane.showMessageDialog(null, "Fehler im erzeugten Baum!", "Fehler", 0);
                return false;
            }
            return true;
        }
        JOptionPane.showMessageDialog(null, "Keine Daten vorhanden!", "Fehler", 0);
        return false;
    }

    public ArrayList<Layer> treeToArrayList() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            Layer layer = (Layer)((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
            arrayList.add(layer);
        }
        return arrayList;
    }

    public ArrayList<SecondaryLayer> leavesToArrayList() {
        ArrayList<SecondaryLayer> arrayList = new ArrayList<SecondaryLayer>();
        Enumeration<TreeNode> enumeration = this.rootNode.preorderEnumeration();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getPath().length <= 2) continue;
            SecondaryLayer secondaryLayer = (SecondaryLayer)defaultMutableTreeNode.getUserObject();
            arrayList.add(secondaryLayer);
        }
        return arrayList;
    }

    public void arrayListToTree(ArrayList<Layer> arrayList) {
        if (arrayList == null) {
            return;
        }
        this.clear();
        Layer layer = arrayList.get(0);
        TreePath treePath = new TreePath(this.rootNode);
        this.tree.setSelectionPath(treePath);
        this.addObject(layer);
        TreePath treePath2 = this.tree.getSelectionPath();
        ListIterator<Layer> listIterator = arrayList.listIterator(1);
        while (listIterator.hasNext()) {
            Layer layer2 = listIterator.next();
            if (layer.getXOK() <= layer2.getXOK() && layer.getXUK() >= layer2.getXUK()) {
                this.addObject(layer2);
                this.tree.setSelectionPath(treePath2);
                continue;
            }
            if (layer.getXUK() == layer2.getXOK()) {
                this.tree.setSelectionPath(treePath);
                this.addObject(layer2);
                treePath2 = this.tree.getSelectionPath();
                layer = layer2;
                continue;
            }
            return;
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            if (treeModelEvent.getChildIndices() != null) {
                int n = treeModelEvent.getChildIndices()[0];
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModelEvent.getTreePath().getLastPathComponent();
            int n = treeModelEvent.getChildIndices()[0];
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            TreePath treePath = treeModelEvent.getTreePath();
            TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
            DynamicTree.this.tree.setSelectionPath(treePath2);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }
    }

    class TreeButtonListener
    implements ActionListener {
        TreeButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("add".equals(actionEvent.getActionCommand())) {
                TreePath treePath = DynamicTree.this.tree.getSelectionPath();
                if (treePath != null && treePath.getPathCount() <= 2) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    int n = defaultMutableTreeNode.getChildCount() + 1;
                    String string = DynamicTree.this.getSelectedLayer().getName();
                    double d = DynamicTree.this.getSelectedLayer().getXOK();
                    double d2 = DynamicTree.this.getSelectedLayer().getXUK();
                    if (treePath.getPathCount() == 2) {
                        SecondaryLayer secondaryLayer = new SecondaryLayer(string + "." + n++, d, d2, 1);
                        DynamicTree.this.addObject(secondaryLayer);
                    } else {
                        Layer layer = new Layer(string + "." + n++, d, d2);
                        DynamicTree.this.addObject(layer);
                    }
                }
            } else if ("remove".equals(actionEvent.getActionCommand())) {
                DynamicTree.this.removeCurrentNode();
            }
        }
    }
}

