/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.project.SecondaryLayer;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;

public class ChartPlot
extends JPanel {
    private static final long serialVersionUID = 1L;
    ArrayList<SecondaryLayer> secondaryLayers;
    private DefaultCategoryDataset dataset;
    private JFreeChart chart;
    private ChartPanel chartPanel;

    public ChartPlot() {
        if (this.secondaryLayers != null) {
            this.createDataset();
            this.chart = this.createChart(this.dataset);
            this.chartPanel = new ChartPanel(this.chart);
            this.chartPanel.setPreferredSize(new Dimension(250, 400));
            this.chartPanel.setVisible(true);
            this.add(this.chartPanel);
        }
    }

    public void updateChart(ArrayList<SecondaryLayer> arrayList) {
        this.secondaryLayers = arrayList;
        this.createDataset();
        this.chart = this.createChart(this.dataset);
        this.chart.fireChartChanged();
        if (this.chartPanel == null) {
            this.chartPanel = new ChartPanel(this.chart);
        }
        this.chartPanel.setChart(this.chart);
        this.chartPanel.updateUI();
        this.chartPanel.setPreferredSize(new Dimension(300, 500));
        this.chartPanel.setVisible(true);
        this.add(this.chartPanel);
    }

    private void createDataset() {
        this.dataset = new DefaultCategoryDataset();
        ListIterator<SecondaryLayer> listIterator = this.secondaryLayers.listIterator();
        while (listIterator.hasNext()) {
            SecondaryLayer secondaryLayer = listIterator.next();
            this.dataset.addValue(secondaryLayer.getXOK() - secondaryLayer.getXUK(), (Comparable)((Object)secondaryLayer.getName()), (Comparable)((Object)"A"));
            this.dataset.addValue(secondaryLayer.getXOK() - secondaryLayer.getXUK(), (Comparable)((Object)secondaryLayer.getName()), (Comparable)((Object)"B"));
        }
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("", "", MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_chartaxis), categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(new Color(238, 238, 238));
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"A"), (Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"B"), (Comparable)((Object)"G2"));
        SecondaryLayerBarRenderer secondaryLayerBarRenderer = new SecondaryLayerBarRenderer();
        secondaryLayerBarRenderer.setDrawBarOutline(true);
        secondaryLayerBarRenderer.setItemMargin(0.0);
        secondaryLayerBarRenderer.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRenderer(secondaryLayerBarRenderer);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        DecimalFormat decimalFormat = new DecimalFormat("#.##;#.##");
        decimalFormat.setNegativePrefix("");
        numberAxis.setNumberFormatOverride(decimalFormat);
        if (this.secondaryLayers.size() > 0) {
            numberAxis.setRange(-this.secondaryLayers.get(this.secondaryLayers.size() - 1).getXUK(), 0.0);
            if (this.secondaryLayers.get(this.secondaryLayers.size() - 1).getXUK() <= 25.0 && this.secondaryLayers.get(this.secondaryLayers.size() - 1).getXUK() > 5.0) {
                numberAxis.setTickUnit(new NumberTickUnit(1.0));
            } else if (this.secondaryLayers.get(this.secondaryLayers.size() - 1).getXUK() <= 50.0 && this.secondaryLayers.get(this.secondaryLayers.size() - 1).getXUK() > 25.0) {
                numberAxis.setTickUnit(new NumberTickUnit(2.0));
            }
        }
        return jFreeChart;
    }

    private class SecondaryLayerBarRenderer
    extends GroupedStackedBarRenderer {
        private static final long serialVersionUID = 1L;
        private Paint[] colors;

        public SecondaryLayerBarRenderer() {
            if (ChartPlot.this.secondaryLayers != null) {
                ListIterator<SecondaryLayer> listIterator = ChartPlot.this.secondaryLayers.listIterator();
                this.colors = new Paint[ChartPlot.this.secondaryLayers.size() * 2];
                int n = 0;
                while (listIterator.hasNext()) {
                    Color color;
                    SecondaryLayer secondaryLayer = listIterator.next();
                    if (secondaryLayer.getHydraulic() != null) {
                        color = secondaryLayer.getHydraulic().getColor();
                        this.colors[n] = color;
                    } else {
                        this.colors[n] = Color.lightGray;
                    }
                    color = secondaryLayer.getMaterial() != null ? secondaryLayer.getMaterial().getColor() : Color.lightGray;
                    this.colors[n + 1] = color;
                    n += 2;
                }
            }
        }

        @Override
        public Paint getItemPaint(int n, int n2) {
            return this.colors[2 * n + n2];
        }
    }
}

