/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.controller.MainWindowController;
import de.dsite.project.Hydraulic;
import de.dsite.project.Material;
import de.dsite.project.SecondaryLayer;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class ChartEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JTable hydraulicTable = new JTable(new HydraulicTableModel());
    private final JTable materialTable = new JTable(new MaterialTableModel());

    public ChartEditor() {
        super(new GridLayout(2, 1, 20, 20));
        this.hydraulicTable.setDefaultRenderer(Object.class, new ColorRenderer());
        this.materialTable.setDefaultRenderer(Object.class, new ColorRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.hydraulicTable);
        JScrollPane jScrollPane2 = new JScrollPane(this.materialTable);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_lbl3)));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_lbl4)));
        this.add(jScrollPane);
        this.add(jScrollPane2);
    }

    public void updateData(ArrayList<SecondaryLayer> arrayList) {
        HashSet<Hydraulic> hashSet = new HashSet<Hydraulic>();
        HashSet<Material> hashSet2 = new HashSet<Material>();
        for (SecondaryLayer serializable2 : arrayList) {
            if (serializable2.getHydraulic() != null) {
                hashSet.add(serializable2.getHydraulic());
            }
            if (serializable2.getMaterial() == null) continue;
            hashSet2.add(serializable2.getMaterial());
        }
        ArrayList arrayList2 = new ArrayList();
        if (hashSet2.size() > 0) {
            arrayList2.addAll(hashSet2);
            Collections.sort(arrayList2);
            ((MaterialTableModel)this.materialTable.getModel()).setMaterials(arrayList2);
        } else {
            ((MaterialTableModel)this.materialTable.getModel()).setMaterials(null);
        }
        ArrayList<Hydraulic> arrayList3 = new ArrayList<Hydraulic>();
        if (hashSet.size() > 0) {
            arrayList3.addAll(hashSet);
            Collections.sort(arrayList3);
            ((HydraulicTableModel)this.hydraulicTable.getModel()).setHydraulics(arrayList3);
        } else {
            ((HydraulicTableModel)this.hydraulicTable.getModel()).setHydraulics(null);
        }
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (jTable.getModel() instanceof HydraulicTableModel) {
                ArrayList<Hydraulic> arrayList = ((HydraulicTableModel)jTable.getModel()).hydraulics;
                if (arrayList != null && arrayList.size() > 0) {
                    this.setBackground(arrayList.get(n).getColor());
                } else {
                    this.setBackground(Color.white);
                }
            } else if (jTable.getModel() instanceof MaterialTableModel) {
                ArrayList arrayList = ((MaterialTableModel)jTable.getModel()).materials;
                if (arrayList != null && arrayList.size() > 0) {
                    this.setBackground(((Material)arrayList.get(n)).getColor());
                } else {
                    this.setBackground(Color.white);
                }
            }
            this.setText(object == null ? "" : object.toString());
            return this;
        }
    }

    public class MaterialTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_tcol4)};
        private ArrayList<Material> materials = new ArrayList();

        public void setMaterials(ArrayList<Material> arrayList) {
            this.materials = arrayList;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.materials == null ? 0 : this.materials.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.materials == null ? "" : this.materials.get(n).getName();
        }
    }

    public class HydraulicTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.geometry_tab_tcol3)};
        ArrayList<Hydraulic> hydraulics = new ArrayList();

        public void setHydraulics(ArrayList<Hydraulic> arrayList) {
            this.hydraulics = arrayList;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.hydraulics != null ? this.hydraulics.size() : 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 > 0 ? Double.valueOf(this.hydraulics.get(n).getValues()[n2]) : this.hydraulics.get(n).getName();
        }
    }
}

