/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.gui;

import de.dsite.gui.ResultPlot;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class BTCPlot
extends ResultPlot {
    private static final long serialVersionUID = 1L;
    private JFreeChart chart;

    public BTCPlot(XYSeriesCollection xYSeriesCollection, String string, String string2, String string3, double d) {
        JFreeChart jFreeChart;
        this.chart = jFreeChart = ChartFactory.createXYLineChart(string, string2, string3, xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(new Color(238, 238, 238));
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        double d2 = xYSeriesCollection.getRangeUpperBound(true);
        if (d > d2) {
            d2 = d;
        }
        if (d2 == 0.0) {
            d2 = 0.0;
        }
        this.setYAxisMaximum(d2);
        for (int i = 0; i < xYPlot.getSeriesCount(); ++i) {
            xYPlot.getRenderer().setSeriesStroke(i, new BasicStroke(1.3f));
        }
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        this.setLayout(new BorderLayout());
        this.add((Component)chartPanel, "Center");
    }

    public void setLogarithmicAxis() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        LogarithmicAxis logarithmicAxis = new LogarithmicAxis(xYPlot.getRangeAxis().getLabel());
        logarithmicAxis.setRange(0.001, xYPlot.getRangeAxis().getUpperBound());
        xYPlot.setRangeAxis(logarithmicAxis);
    }

    public void setNumberAxis() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        NumberAxis numberAxis = new NumberAxis(xYPlot.getRangeAxis().getLabel());
        numberAxis.setRange(0.0, xYPlot.getRangeAxis().getUpperBound());
        numberAxis.setTickLabelFont(xYPlot.getDomainAxis().getTickLabelFont());
        xYPlot.setRangeAxis(numberAxis);
    }

    public void setYAxisMaximum(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        NumberAxis numberAxis = new NumberAxis(xYPlot.getRangeAxis().getLabel());
        numberAxis.setRange(0.0, d);
        numberAxis.setTickLabelFont(xYPlot.getDomainAxis().getTickLabelFont());
        numberAxis.setLabelFont(xYPlot.getDomainAxis().getTickLabelFont());
        xYPlot.setRangeAxis(numberAxis);
    }

    public void setAxis() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setLabel("Neues Label");
        numberAxis.setTickMarksVisible(false);
        TickUnits tickUnits = (TickUnits)NumberAxis.createIntegerTickUnits();
        numberAxis.setStandardTickUnits(tickUnits);
    }
}

