/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.Series;
import java.io.Serializable;
import java.util.ArrayList;

public class Timesteps
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Series.Unit unit;
    private ArrayList<Integer> stepCounts = new ArrayList();
    private ArrayList<Double> stepLengths = new ArrayList();

    public Timesteps() {
        this.setUnit(Series.Unit.SEC);
    }

    public void addTimestep() {
        this.addTimestep(1, 1.0);
    }

    public void addTimestep(int n, double d) {
        if (n >= 1 && d > 0.0) {
            this.stepCounts.add(new Integer(n));
            this.stepLengths.add(new Double(d));
        }
    }

    public void addTimestepAtIndex(int n) {
        if (n > 0) {
            this.assertIndexInRange(n - 1);
        }
        this.stepCounts.add(n, new Integer(1));
        this.stepLengths.add(n, new Double(1.0));
    }

    public void deleteTimeStepAtIndex(int n) {
        this.assertIndexInRange(n);
        this.stepCounts.remove(n);
        this.stepLengths.remove(n);
    }

    public int numberOfTimesteps() {
        return this.stepCounts.size();
    }

    public int sumOfTimestepCounts() {
        int n = 0;
        if (this.numberOfTimesteps() == 0) {
            return n;
        }
        for (Integer n2 : this.stepCounts) {
            n += n2.intValue();
        }
        return n;
    }

    public double sumOfTimestepLengths() {
        double d = 0.0;
        if (this.numberOfTimesteps() == 0) {
            return d;
        }
        for (int i = 0; i < this.stepCounts.size(); ++i) {
            d += (double)this.stepCounts.get(i).intValue() * this.stepLengths.get(i);
        }
        return d;
    }

    public double sumOfTimestepLengthsInSeconds() {
        double d = this.sumOfTimestepLengths();
        switch (this.unit) {
            case MIN: {
                return d * 60.0;
            }
            case HOUR: {
                return d * 360.0;
            }
            case DAY: {
                return d * 8640.0;
            }
            case MONTH: {
                return d * 8640.0 * 30.0;
            }
            case YEAR: {
                return d * 8640.0 * 365.0;
            }
        }
        return d;
    }

    public int getTimeStepCountForTimestepAtIndex(int n) {
        this.assertIndexInRange(n);
        return this.stepCounts.get(n);
    }

    public void setTimeStepCountForTimestepAtIndex(int n, int n2) {
        this.assertIndexInRange(n);
        if (n2 <= 0) {
            throw new IllegalArgumentException("parameter 'count' = " + n2 + " must be > 0");
        }
        this.stepCounts.set(n, new Integer(n2));
    }

    public double getTimeStepLengthForTimestepAtIndex(int n) {
        this.assertIndexInRange(n);
        return this.stepLengths.get(n);
    }

    public double getTimeStepLengthForTimestepAtIndexInSeconds(int n) {
        double d = this.getTimeStepLengthForTimestepAtIndex(n);
        switch (this.unit) {
            case MIN: {
                return (int)(d * 60.0);
            }
            case HOUR: {
                return (int)(d * 360.0);
            }
            case DAY: {
                return (int)(d * 8640.0);
            }
            case MONTH: {
                return (int)(d * 8640.0 * 30.0);
            }
            case YEAR: {
                return (int)(d * 8640.0 * 365.0);
            }
        }
        return (int)d;
    }

    public void setTimeStepLengthForTimestepAtIndex(int n, double d) {
        this.assertIndexInRange(n);
        if (d <= 0.0) {
            throw new IllegalArgumentException("parameter 'length' = " + d + " must be > 0");
        }
        this.stepLengths.set(n, new Double(d));
    }

    public void setTimeStepLengthForTimestepAtIndexInSeconds(int n, double d) {
        this.assertIndexInRange(n);
        if (d <= 0.0) {
            throw new IllegalArgumentException("parameter 'length' = " + d + " must be > 0");
        }
        switch (this.unit) {
            case MIN: {
                this.stepLengths.set(n, new Double(d / 60.0));
                break;
            }
            case HOUR: {
                this.stepLengths.set(n, new Double(d / 360.0));
                break;
            }
            case DAY: {
                this.stepLengths.set(n, new Double(d / 8640.0));
                break;
            }
            case MONTH: {
                this.stepLengths.set(n, new Double(d / 259200.0));
                break;
            }
            case YEAR: {
                this.stepLengths.set(n, new Double(d / 3153600.0));
                break;
            }
            default: {
                this.stepLengths.set(n, new Double(d));
            }
        }
    }

    public Series.Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Series.Unit unit) {
        this.unit = unit;
    }

    private void assertIndexInRange(int n) {
        if (n < 0 || n > this.stepCounts.size() - 1) {
            throw new IllegalArgumentException("parameter 'index' = " + n + " must be >= 0 and < " + this.stepCounts.size());
        }
    }
}

