/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import java.io.Serializable;
import java.util.ArrayList;

public class SorptionMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<CatalogObject> aquiferMat = new ArrayList();
    private double[] feq;
    private int[] type;
    private double[][] params;

    public SorptionMatrix(ArrayList<CatalogObject> arrayList) {
        for (CatalogObject object2 : arrayList) {
            this.aquiferMat.add((AquiferMaterial)object2);
        }
        int n = arrayList.size();
        this.setFeq(new double[n]);
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1;
        }
        this.setType(nArray);
        this.setParams(new double[n][3]);
    }

    public boolean setAquiferMat(ArrayList<CatalogObject> arrayList) {
        boolean bl = false;
        int n = arrayList.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        double[][] dArray2 = new double[n][3];
        int n2 = 0;
        for (CatalogObject catalogObject : arrayList) {
            if (this.aquiferMat.contains(catalogObject)) {
                int n3 = this.aquiferMat.indexOf(catalogObject);
                dArray[n2] = this.getFeq()[n3];
                nArray[n2] = this.getType()[n3];
                for (int i = 0; i < 3; ++i) {
                    dArray2[n2][i] = this.getParams()[n3][i];
                }
            } else {
                nArray[n2] = 1;
                bl = true;
            }
            ++n2;
        }
        this.aquiferMat.clear();
        for (CatalogObject catalogObject : arrayList) {
            this.aquiferMat.add((AquiferMaterial)catalogObject);
        }
        this.setFeq(dArray);
        this.setType(nArray);
        this.setParams(dArray2);
        return bl;
    }

    public ArrayList<CatalogObject> getAquiferMat() {
        return this.aquiferMat;
    }

    public void setFeq(double[] dArray) {
        this.feq = dArray;
    }

    public double[] getFeq() {
        return this.feq;
    }

    public double getFeq(CatalogObject catalogObject) {
        if (this.aquiferMat.contains(catalogObject)) {
            return this.feq[this.aquiferMat.indexOf(catalogObject)];
        }
        return 0.0;
    }

    public void setType(int[] nArray) {
        this.type = nArray;
    }

    public int[] getType() {
        return this.type;
    }

    public void setParams(double[][] dArray) {
        this.params = dArray;
    }

    public double[][] getParams() {
        return this.params;
    }
}

