/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import org.jfree.data.xy.XYSeries;

public class Series
implements Comparable<Series> {
    private final XYSeries xySeries;
    private final CatalogObject catalogObject;
    private final Double observationValue;
    private final FileType fileType;
    private final ProfileType profileType;
    private final Unit unit;
    private final OriginType origin;

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, OriginType originType) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = ProfileType.NONE;
        this.unit = Unit.SEC;
        this.origin = originType;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = ProfileType.NONE;
        this.unit = Unit.SEC;
        this.origin = OriginType.FORTRAN;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, Unit unit) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = ProfileType.NONE;
        this.unit = unit;
        this.origin = OriginType.FORTRAN;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, Unit unit, OriginType originType) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = ProfileType.NONE;
        this.unit = unit;
        this.origin = originType;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, ProfileType profileType) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = profileType;
        this.unit = Unit.SEC;
        this.origin = OriginType.FORTRAN;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, ProfileType profileType, OriginType originType) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = profileType;
        this.unit = Unit.SEC;
        this.origin = originType;
    }

    public Series(CatalogObject catalogObject, double d, XYSeries xYSeries, FileType fileType, ProfileType profileType, Unit unit) {
        this.observationValue = d;
        this.catalogObject = catalogObject;
        this.xySeries = xYSeries;
        this.fileType = fileType;
        this.profileType = profileType;
        this.unit = unit;
        this.origin = OriginType.FORTRAN;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Series series = (Series)object;
        return this.compareTo(series) == 0;
    }

    @Override
    public int compareTo(Series series) {
        int n = this.getNameOfPollutant().compareTo(series.getNameOfPollutant());
        if (n == 0) {
            if (this.getObservationValue() - series.getObservationValue() < 0.0) {
                n = -1;
            } else if (this.getObservationValue() - series.getObservationValue() > 0.0) {
                n = 1;
            }
        }
        if (n == 0) {
            n = this.fileType.compareTo(series.fileType);
        }
        if (n == 0) {
            n = this.profileType.compareTo(series.profileType);
        }
        if (n == 0) {
            n = this.unit.compareTo(series.unit);
        }
        if (n == 0) {
            n = this.origin.compareTo(series.origin);
        }
        return n;
    }

    public int hashCode() {
        return this.catalogObject.getBezeichnung().hashCode() + this.fileType.hashCode() + this.profileType.hashCode() + this.observationValue.hashCode() + this.origin.hashCode() * 37;
    }

    public XYSeries getXYSeries() {
        return this.xySeries;
    }

    public double getObservationValue() {
        return this.observationValue;
    }

    public String getNameOfPollutant() {
        return this.catalogObject.getBezeichnung();
    }

    public boolean isCatalogObjectOfTypePollutant() {
        return this.catalogObject instanceof Pollutant;
    }

    public boolean isCatalogObjectOfTypeSurfactant() {
        return this.catalogObject instanceof Surfactant;
    }

    public boolean isFileTypeBTC() {
        return this.fileType.equals((Object)FileType.BTC) || this.fileType.equals((Object)FileType.AAC);
    }

    public boolean isFileTypeProfile() {
        return this.fileType.equals((Object)FileType.PROFILE);
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public ProfileType getProfileType() {
        return this.profileType;
    }

    public CatalogObject getCatalogObject() {
        return this.catalogObject;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public OriginType getOrigin() {
        return this.origin;
    }

    public static enum Unit {
        SEC("sec"),
        MIN("min"),
        HOUR("hour"),
        DAY("day"),
        MONTH("month"),
        YEAR("year"),
        LS("ls");

        final String value;

        private Unit(String string2) {
            this.value = string2;
        }

        public String toString() {
            return MainWindowController.resourceManager.getLangString(Unit.valueOf(Unit.class, super.toString()));
        }

        public static Unit getUnitWithValue(String string) {
            for (Unit unit : Unit.values()) {
                if (!unit.value.equals(string)) continue;
                return unit;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ProfileType {
        DISS,
        MIC,
        SORB,
        DIFF,
        MONO,
        NONE;

    }

    public static enum FileType {
        BTC,
        AAC,
        PROFILE;

    }

    public static enum OriginType {
        FORTRAN,
        MEAS;

    }
}

