/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.Hydraulic;
import de.dsite.data.Layer;
import de.dsite.data.Material;
import java.awt.Color;
import java.io.File;

public class SecondaryLayer
extends Layer {
    private static final long serialVersionUID = 1L;
    private Hydraulic hydraulic;
    private Material material;
    private int numModellzellen = 1;
    private static final Material defaultMaterial = new Material("Material 1", 1);
    private double residenceAlpha;
    private int residenceNumOfCells;
    private String residenceFile;
    private boolean residenceCalculationFromFile = false;
    private int indexA = 1;

    public SecondaryLayer(String string, double d, double d2) {
        super(string, d, d2);
        double[] dArray = new double[]{1.0E-4, 0.25, 0.25, 1.0};
        Color color = new Color(5, 100, 175);
        this.hydraulic = new Hydraulic("Hyd 1", dArray, color, this.indexA);
        this.material = defaultMaterial;
        this.residenceAlpha = 0.01;
        this.residenceNumOfCells = 100;
        File file = new File("");
        this.residenceFile = file.getAbsolutePath();
    }

    public SecondaryLayer(String string, double d, double d2, int n) {
        super(string, d, d2);
        this.setNumModellzellen(n);
        double[] dArray = new double[]{1.0E-4, 0.25, 0.25, 1.0};
        Color color = new Color(5, 100, 175);
        this.hydraulic = new Hydraulic("Hyd 1", dArray, color, this.indexA);
        this.material = defaultMaterial;
        this.residenceAlpha = 0.01;
        this.residenceNumOfCells = 100;
        File file = new File("./data");
        this.residenceFile = file.getAbsolutePath();
    }

    private SecondaryLayer(String string, double d, double d2, int n, Hydraulic hydraulic, Material material) {
        super(string, d, d2);
        SecondaryLayer.assertNumOfCellsGreaterNull(n);
        SecondaryLayer.assertHydraulicNotNull(hydraulic);
        SecondaryLayer.assertMaterialNotNull(material);
        this.setNumModellzellen(n);
        this.hydraulic = hydraulic;
        this.material = material;
    }

    public void setNumModellzellen(int n) {
        SecondaryLayer.assertNumOfCellsGreaterNull(n);
        this.numModellzellen = n;
    }

    public int getNumModellzellen() {
        return this.numModellzellen;
    }

    public Hydraulic getHydraulic() {
        return this.hydraulic;
    }

    public void setHydraulic(Hydraulic hydraulic) {
        this.hydraulic = hydraulic;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setIndexA(int n) {
        this.indexA = n;
    }

    public int getIndexA() {
        return this.indexA;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SecondaryLayer secondaryLayer = (SecondaryLayer)object;
        return this.getName().equals(secondaryLayer.getName()) && this.hydraulic.equals(secondaryLayer.hydraulic) && this.material.equals(secondaryLayer.material);
    }

    public int hashCode() {
        return this.getMaterial().getName().hashCode();
    }

    private static void assertNumOfCellsGreaterNull(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("parameter 'numOfCells' must be > 0");
        }
    }

    private static void assertHydraulicNotNull(Hydraulic hydraulic) {
        if (hydraulic == null) {
            throw new IllegalArgumentException("parameter 'hydraulic' must not be null");
        }
    }

    private static void assertMaterialNotNull(Material material) {
        if (material == null) {
            throw new IllegalArgumentException("parameter 'material' must not be null");
        }
    }

    public double getResidenceAlpha() {
        return this.residenceAlpha;
    }

    public void setResidenceAlpha(double d) {
        if (d <= 1.0 && d > 0.0) {
            this.residenceAlpha = d;
        }
    }

    public int getResidenceNumOfCells() {
        return this.residenceNumOfCells;
    }

    public void setResidenceNumOfCells(int n) {
        if (n >= 0) {
            this.residenceNumOfCells = n;
        }
    }

    public String getResidenceFile() {
        return this.residenceFile;
    }

    public void setResidenceFile(String string) {
        this.residenceFile = string;
    }

    public boolean isResidenceCalculationFromFile() {
        return this.residenceCalculationFromFile;
    }

    public void setResidenceCalculationFromFile(boolean bl) {
        this.residenceCalculationFromFile = bl;
    }
}

