/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.controller.MainWindowController;
import de.dsite.data.BioReductionMatrix;
import de.dsite.data.GrainSize;
import de.dsite.data.Layer;
import de.dsite.data.ObservedProject;
import de.dsite.data.Pair;
import de.dsite.data.SecondaryLayer;
import de.dsite.data.Series;
import de.dsite.data.SorptionMatrix;
import de.dsite.data.Timesteps;
import de.dsite.data.catalog.AquiferMaterial;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.data.catalog.Surfactant;
import de.dsite.gui.ProjectListener;
import de.dsite.utils.ResourceBundleUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Project
implements Serializable,
ObservedProject {
    private static final long serialVersionUID = 1L;
    private transient ArrayList<ProjectListener> observer;
    private String szenarioBezeichnung;
    private int simulationsModus;
    private String bemerkungen;
    private ArrayList<Layer> layers;
    private ArrayList<SecondaryLayer> leaves;
    private double crossSection;
    private String zeitModus;
    private int[][] zeitschritte;
    private int timeIntervall;
    private Timesteps timeSteps;
    private ArrayList<CatalogObject> polList;
    private ArrayList<CatalogObject> surList;
    private ArrayList<CatalogObject> amatList;
    private ArrayList<CatalogObject> polSelected;
    private ArrayList<CatalogObject> surSelected;
    private ArrayList<CatalogObject> amatSelected;
    private ArrayList<GrainSize> grainSizeList;
    private ArrayList<GrainSize> grainSizeSelected;
    private double bcFlowValueTop;
    private double bcFlowValueBottom;
    private boolean zustrom = true;
    private boolean abstrom = true;
    private boolean concentrationFixTop = true;
    private boolean concentrationFixStart = true;
    private boolean stageCompact = true;
    private boolean steadyStage = true;
    private boolean concentrationFixTopSur = true;
    private boolean concentrationFixStartSur = true;
    private boolean stageCompactSur = false;
    private boolean steadyStageSur = true;
    private HashMap<Pollutant, double[]> concentrations;
    private HashMap<Surfactant, double[]> concentrationsSur;
    private HashMap<Pollutant, double[]> initialConcentrations;
    private HashMap<Surfactant, double[]> initialConcentrationsSur;
    private BioReductionMatrix bioMatrix;
    private double[] times;
    private double[] xvalues;
    private double[] timesSur;
    private double[] xvaluesSur;
    private boolean modInterpol = true;
    private boolean modEV = false;
    private boolean modNV = false;
    private boolean modInterpolAB = true;
    private boolean modEVAB = false;
    private boolean modNVAB = false;
    private boolean modInterpolSur = true;
    private boolean modEVSur = false;
    private boolean modNVSur = false;
    private boolean modInterpolABSur = true;
    private boolean modEVABSur = false;
    private boolean modNVABSur = false;
    private HashMap<Pollutant, SorptionMatrix> sorptionMap;
    private double[] btcValues;
    private double[] profileValues;
    private double[] dimTransportmodell;
    private double[] dimKonzentrationsgleichgewicht;
    private double[] dimProzessschritte;
    private double dimIntrapartikeldiffusion = 0.01;
    private double[] dimIntrapartikeldiffusion_analyitsch;
    private double[] dimIp_diffusion;
    private double[] dimBioabbau;
    private double[] dimWeitere_parameter;
    private boolean modeAnalytic = false;
    private boolean modeNumeric = true;
    private boolean modeNone = false;
    private boolean calculationFocKoc = false;
    private boolean calculationKd = true;
    private boolean calculationDaq = false;
    private boolean sorpModeFocKoc = false;
    private boolean grainSizeDIN = false;
    private int outputControlMode = 0;
    private int[] timestepRange = new int[]{0, 0};
    private FileFormat formatBTCAndProfileOutput = FileFormat.CSV;
    private Set<ConcentrationValue> concentrationPollutant = new HashSet<ConcentrationValue>();
    private Set<ConcentrationValue> concentrationAquiferMaterial = new HashSet<ConcentrationValue>();
    private Map<Pair, double[]> solubilizationValues;
    private Map<Pair, double[]> adsolubilizationValues;
    private Map<Pair, double[]> monomereLayerValues;
    private Series.Unit unit;

    public Project() {
        this.setObserver(new ArrayList<ProjectListener>());
        this.szenarioBezeichnung = "";
        this.bemerkungen = "";
        Layer layer = new Layer(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_mainlayer) + ".1", 0.0, 1.0);
        SecondaryLayer secondaryLayer = new SecondaryLayer(MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_geometrie_secondarylayer) + ".1.1", 0.0, 1.0, 1);
        this.crossSection = 1.0;
        this.layers = new ArrayList();
        this.layers.add(layer);
        this.layers.add(secondaryLayer);
        this.leaves = new ArrayList();
        this.leaves.add(secondaryLayer);
        this.polSelected = new ArrayList();
        this.surSelected = new ArrayList();
        this.amatSelected = new ArrayList();
        this.timeSteps = new Timesteps();
        this.timeSteps.addTimestep();
        this.sorptionMap = new HashMap();
        this.concentrationPollutant.add(ConcentrationValue.DISS);
    }

    public void setSzenarioBezeichnung(String string) {
        this.szenarioBezeichnung = string;
    }

    public String getSzenarioBezeichnung() {
        return this.szenarioBezeichnung;
    }

    public void setSimulationsModus(int n) {
        if (n == 0 || n == 1) {
            this.simulationsModus = n;
        }
    }

    public int getSimulationsModus() {
        return this.simulationsModus;
    }

    public void setBemerkungen(String string) {
        this.bemerkungen = string;
    }

    public String getBemerkungen() {
        return this.bemerkungen;
    }

    public void setLayers(ArrayList<Layer> arrayList) {
        this.layers = arrayList;
    }

    public ArrayList<Layer> getLayers() {
        return this.layers;
    }

    public boolean isLayersvalid() {
        if (this.layers == null) {
            return false;
        }
        Layer layer = this.layers.get(0);
        ListIterator<Layer> listIterator = this.layers.listIterator(this.layers.size());
        while (listIterator.hasNext()) {
            Layer layer2 = listIterator.next();
            if (layer.getXOK() == layer2.getXOK() && layer.getXUK() == layer2.getXUK() || layer.getXUK() == layer2.getXOK()) {
                layer = layer2;
                continue;
            }
            return false;
        }
        return true;
    }

    public void setLeaves(ArrayList<SecondaryLayer> arrayList) {
        this.leaves = arrayList;
        this.notifyListener();
    }

    public ArrayList<SecondaryLayer> getLeaves() {
        return this.leaves;
    }

    public void addLeave(SecondaryLayer secondaryLayer) {
        this.leaves.add(secondaryLayer);
        this.notifyListener();
    }

    public void removeLeave(int n) {
        if (n >= 0 && n < this.leaves.size()) {
            this.leaves.remove(n);
            this.notifyListener();
        }
    }

    public void setZeitschritte(int[][] nArray) {
        if (nArray[0].length != 3) {
            throw new IllegalArgumentException("number of columns in parameter 'zeitschritte' must be 3!");
        }
        this.zeitschritte = nArray;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i][1] * nArray[i][2];
        }
        this.timeIntervall = n;
    }

    public int[][] getZeitschritte() {
        return this.zeitschritte;
    }

    public void setZeitModus(String string) {
        this.zeitModus = string;
    }

    public String getZeitModus() {
        return this.zeitModus;
    }

    public int getTimeIntervall() {
        return this.timeIntervall;
    }

    public void setTimeIntervall(int n) {
        this.timeIntervall = n;
    }

    public void setPolList(ArrayList<CatalogObject> arrayList) {
        this.polList = arrayList;
    }

    public ArrayList<CatalogObject> getPolList() {
        return this.polList;
    }

    public void setSurList(ArrayList<CatalogObject> arrayList) {
        this.surList = arrayList;
    }

    public ArrayList<CatalogObject> getSurList() {
        return this.surList;
    }

    public void setAmatList(ArrayList<CatalogObject> arrayList) {
        this.amatList = arrayList;
    }

    public ArrayList<CatalogObject> getAmatList() {
        return this.amatList;
    }

    public void setPolSelected(ArrayList<CatalogObject> arrayList) {
        this.polSelected = arrayList;
    }

    public ArrayList<CatalogObject> getPolSelected() {
        return this.polSelected;
    }

    public void setSurSelected(ArrayList<CatalogObject> arrayList) {
        this.surSelected = arrayList;
    }

    public ArrayList<CatalogObject> getSurSelected() {
        return this.surSelected;
    }

    public void setAmatSelected(ArrayList<CatalogObject> arrayList) {
        this.amatSelected = arrayList;
    }

    public ArrayList<CatalogObject> getAmatSelected() {
        return this.amatSelected;
    }

    public void setGrainSizeList(ArrayList<GrainSize> arrayList) {
        this.grainSizeList = arrayList;
    }

    public ArrayList<GrainSize> getGrainSizeList() {
        return this.grainSizeList;
    }

    public void setGrainSizeSelected(ArrayList<GrainSize> arrayList) {
        Collections.sort(arrayList);
        this.grainSizeSelected = arrayList;
    }

    public ArrayList<GrainSize> getGrainSizeSelected() {
        return this.grainSizeSelected;
    }

    public void setBcFlowValueTop(double d) {
        this.bcFlowValueTop = d;
    }

    public double getBcFlowValueTop() {
        return this.bcFlowValueTop;
    }

    public void setBcFlowValueBottom(double d) {
        this.bcFlowValueBottom = d;
    }

    public double getBcFlowValueBottom() {
        return this.bcFlowValueBottom;
    }

    public void setZustrom(boolean bl) {
        this.zustrom = bl;
    }

    public boolean isZustrom() {
        return this.zustrom;
    }

    public void setAbstrom(boolean bl) {
        this.abstrom = bl;
    }

    public boolean isAbstrom() {
        return this.abstrom;
    }

    public void setConcentrationFixTop(boolean bl) {
        this.concentrationFixTop = bl;
    }

    public boolean isConcentrationFixTop() {
        return this.concentrationFixTop;
    }

    public void setConcentrationFixStart(boolean bl) {
        this.concentrationFixStart = bl;
    }

    public boolean isConcentrationFixStart() {
        return this.concentrationFixStart;
    }

    public void setConcentrations(HashMap<Pollutant, double[]> hashMap) {
        this.concentrations = hashMap;
    }

    public HashMap<Pollutant, double[]> getConcentrations() {
        return this.concentrations;
    }

    public void setTimes(double[] dArray) {
        this.times = dArray;
    }

    public double[] getTimes() {
        if (this.times == null) {
            this.setTimes(new double[]{0.0});
        }
        return this.times;
    }

    public void setModInterpol(boolean bl) {
        this.modInterpol = bl;
    }

    public boolean isModInterpol() {
        return this.modInterpol;
    }

    public void setModEV(boolean bl) {
        this.modEV = bl;
    }

    public boolean isModEV() {
        return this.modEV;
    }

    public void setModNV(boolean bl) {
        this.modNV = bl;
    }

    public boolean isModNV() {
        return this.modNV;
    }

    public void setModInterpolAB(boolean bl) {
        this.modInterpolAB = bl;
    }

    public boolean isModInterpolAB() {
        return this.modInterpolAB;
    }

    public void setModEVAB(boolean bl) {
        this.modEVAB = bl;
    }

    public boolean isModEVAB() {
        return this.modEVAB;
    }

    public void setModNVAB(boolean bl) {
        this.modNVAB = bl;
    }

    public boolean isModNVAB() {
        return this.modNVAB;
    }

    public void setStageCompact(boolean bl) {
        this.stageCompact = bl;
    }

    public boolean isStageCompact() {
        return this.stageCompact;
    }

    public void setSteadyStage(boolean bl) {
        this.steadyStage = bl;
    }

    public boolean isSteadyStage() {
        return this.steadyStage;
    }

    public void setInitialConcentrations(HashMap<Pollutant, double[]> hashMap) {
        this.initialConcentrations = hashMap;
    }

    public HashMap<Pollutant, double[]> getInitialConcentrations() {
        if (this.initialConcentrations == null) {
            HashMap<Pollutant, double[]> hashMap = new HashMap<Pollutant, double[]>();
            for (CatalogObject catalogObject : this.getPolSelected()) {
                double[] dArray = new double[]{0.0};
                hashMap.put((Pollutant)catalogObject, dArray);
            }
            this.setInitialConcentrations(hashMap);
        }
        return this.initialConcentrations;
    }

    public void setSorptionMap(HashMap<Pollutant, SorptionMatrix> hashMap) {
        this.sorptionMap = hashMap;
    }

    public HashMap<Pollutant, SorptionMatrix> getSorptionMap() {
        return this.sorptionMap;
    }

    public void setCrossSection(double d) {
        this.crossSection = d;
    }

    public double getCrossSection() {
        return this.crossSection;
    }

    public double[] getBtcValues() {
        return this.btcValues;
    }

    public void setBtcValues(double[] dArray) {
        this.btcValues = dArray;
    }

    public double[] getProfileValues() {
        return this.profileValues;
    }

    public void setProfileValues(double[] dArray) {
        this.profileValues = dArray;
    }

    public BioReductionMatrix getBioMatrix() {
        return this.bioMatrix;
    }

    public void setBioMatrix(BioReductionMatrix bioReductionMatrix) {
        this.bioMatrix = bioReductionMatrix;
    }

    public double[] getDimTransportmodell() {
        if (this.dimTransportmodell == null) {
            double[] dArray = new double[]{10000.0, 500.0, 2000.0, 500.0, 1.0E-12};
            this.dimTransportmodell = dArray;
        }
        return this.dimTransportmodell;
    }

    public void setDimTransportmodell(double[] dArray) {
        this.dimTransportmodell = dArray;
    }

    public double[] getDimKonzentrationsgleichgewicht() {
        if (this.dimKonzentrationsgleichgewicht == null) {
            double[] dArray = new double[]{5000.0, 1.0E-10};
            this.dimKonzentrationsgleichgewicht = dArray;
        }
        return this.dimKonzentrationsgleichgewicht;
    }

    public void setDimKonzentrationsgleichgewicht(double[] dArray) {
        this.dimKonzentrationsgleichgewicht = dArray;
    }

    public double[] getDimProzessschritte() {
        if (this.dimProzessschritte == null) {
            double[] dArray = new double[]{0.4, 30.0};
            this.dimProzessschritte = dArray;
        }
        return this.dimProzessschritte;
    }

    public void setDimProzessschritte(double[] dArray) {
        this.dimProzessschritte = dArray;
    }

    public double getDimIntrapartikeldiffusion() {
        return this.dimIntrapartikeldiffusion;
    }

    public void setDimIntrapartikeldiffusion(double d) {
        this.dimIntrapartikeldiffusion = d;
    }

    public double[] getDimIntrapartikeldiffusion_analyitsch() {
        if (this.dimIntrapartikeldiffusion_analyitsch == null) {
            double[] dArray = new double[]{2000.0, 100.0, 1.0E-10, 1.0E-20};
            this.dimIntrapartikeldiffusion_analyitsch = dArray;
        }
        return this.dimIntrapartikeldiffusion_analyitsch;
    }

    public void setDimIntrapartikeldiffusion_analyitsch(double[] dArray) {
        this.dimIntrapartikeldiffusion_analyitsch = dArray;
    }

    public double[] getDimIp_diffusion() {
        if (this.dimIp_diffusion == null) {
            double[] dArray = new double[]{20.0, 100.0, 1.0, 1000000.0, 2.0, 0.4, 1.0E-12, 1.0E-20, 1.0E-20, 5.0};
            this.dimIp_diffusion = dArray;
        }
        return this.dimIp_diffusion;
    }

    public void setDimIp_diffusion(double[] dArray) {
        this.dimIp_diffusion = dArray;
    }

    public double[] getDimBioabbau() {
        if (this.dimBioabbau == null) {
            double[] dArray = new double[]{400.0, 1.0E-20};
            this.dimBioabbau = dArray;
        }
        return this.dimBioabbau;
    }

    public void setDimBioabbau(double[] dArray) {
        this.dimBioabbau = dArray;
    }

    public double[] getDimWeitere_parameter() {
        if (this.dimWeitere_parameter == null) {
            double[] dArray = new double[]{1.0E-10, 2.0, 0.995};
            this.dimWeitere_parameter = dArray;
        }
        return this.dimWeitere_parameter;
    }

    public void setDimWeitere_parameter(double[] dArray) {
        this.dimWeitere_parameter = dArray;
    }

    public boolean isModeAnalytic() {
        return this.modeAnalytic;
    }

    public void setModeAnalytic(boolean bl) {
        this.modeAnalytic = bl;
    }

    public boolean isModeNone() {
        return this.modeNone;
    }

    public void setModeNone(boolean bl) {
        this.modeNone = bl;
    }

    public boolean isModeNumeric() {
        return this.modeNumeric;
    }

    public void setModeNumeric(boolean bl) {
        this.modeNumeric = bl;
    }

    public boolean isCalculationFocKoc() {
        return this.calculationFocKoc;
    }

    public void setCalculationFocKoc(boolean bl) {
        this.calculationFocKoc = bl;
    }

    public boolean isCalculationKd() {
        return this.calculationKd;
    }

    public void setCalculationKd(boolean bl) {
        this.calculationKd = bl;
    }

    public boolean isCalculationDaq() {
        return this.calculationDaq;
    }

    public void setCalculationDaq(boolean bl) {
        this.calculationDaq = bl;
    }

    public boolean isGrainSizeDIN() {
        return this.grainSizeDIN;
    }

    public void setGrainSizeDIN(boolean bl) {
        this.grainSizeDIN = bl;
    }

    public int getOutputControlMode() {
        return this.outputControlMode;
    }

    public void setOutputControlMode(int n) {
        if (n < 0 || n >= 64) {
            throw new IllegalArgumentException("parameter 'outputControlMode' must be >= 0 and < 64");
        }
        this.outputControlMode = n;
    }

    public int[] getTimestepRange() {
        return this.timestepRange;
    }

    public void setTimestepRange(int[] nArray) {
        if (nArray.length != 2 || nArray[0] < 0 || nArray[1] < nArray[0]) {
            throw new IllegalArgumentException("parameter 'timestepRange' must be of type int[x1, x2], x1 < x2, x1 > 0'");
        }
        this.timestepRange = nArray;
    }

    public FileFormat getFormatBTCAndProfileOutput() {
        return this.formatBTCAndProfileOutput;
    }

    public void setFormatBTCAndProfileOutput(FileFormat fileFormat) {
        this.formatBTCAndProfileOutput = fileFormat;
    }

    public Set<ConcentrationValue> getConcentrationPollutant() {
        return this.concentrationPollutant;
    }

    public void setConcentrationPollutant(Set<ConcentrationValue> set) {
        this.concentrationPollutant = set;
    }

    public Set<ConcentrationValue> getConcentrationAquiferMaterial() {
        return this.concentrationAquiferMaterial;
    }

    public void setConcentrationAquiferMaterial(Set<ConcentrationValue> set) {
        this.concentrationAquiferMaterial = set;
    }

    public double[] getXvalues() {
        if (this.xvalues == null) {
            this.setXvalues(new double[]{0.0});
        }
        return this.xvalues;
    }

    public void setXvalues(double[] dArray) {
        this.xvalues = dArray;
    }

    public boolean isSorpModeFocKoc() {
        return this.sorpModeFocKoc;
    }

    public void setSorpModeFocKoc(boolean bl) {
        this.sorpModeFocKoc = bl;
    }

    public boolean isConcentrationFixTopSur() {
        return this.concentrationFixTopSur;
    }

    public void setConcentrationFixTopSur(boolean bl) {
        this.concentrationFixTopSur = bl;
    }

    public boolean isConcentrationFixStartSur() {
        return this.concentrationFixStartSur;
    }

    public void setConcentrationFixStartSur(boolean bl) {
        this.concentrationFixStartSur = bl;
    }

    public boolean isStageCompactSur() {
        return this.stageCompactSur;
    }

    public void setStageCompactSur(boolean bl) {
        this.stageCompactSur = bl;
    }

    public boolean isSteadyStageSur() {
        return this.steadyStageSur;
    }

    public void setSteadyStageSur(boolean bl) {
        this.steadyStageSur = bl;
    }

    public double[] getTimesSur() {
        if (this.timesSur == null) {
            this.setTimesSur(new double[]{0.0});
        }
        return this.timesSur;
    }

    public void setTimesSur(double[] dArray) {
        this.timesSur = dArray;
    }

    public double[] getXvaluesSur() {
        if (this.xvaluesSur == null) {
            this.setXvaluesSur(new double[]{0.0});
        }
        return this.xvaluesSur;
    }

    public void setXvaluesSur(double[] dArray) {
        this.xvaluesSur = dArray;
    }

    public boolean isModInterpolSur() {
        return this.modInterpolSur;
    }

    public void setModInterpolSur(boolean bl) {
        this.modInterpolSur = bl;
    }

    public boolean isModEVSur() {
        return this.modEVSur;
    }

    public void setModEVSur(boolean bl) {
        this.modEVSur = bl;
    }

    public boolean isModNVSur() {
        return this.modNVSur;
    }

    public void setModNVSur(boolean bl) {
        this.modNVSur = bl;
    }

    public boolean isModInterpolABSur() {
        return this.modInterpolABSur;
    }

    public void setModInterpolABSur(boolean bl) {
        this.modInterpolABSur = bl;
    }

    public boolean isModEVABSur() {
        return this.modEVABSur;
    }

    public void setModEVABSur(boolean bl) {
        this.modEVABSur = bl;
    }

    public boolean isModNVABSur() {
        return this.modNVABSur;
    }

    public void setModNVABSur(boolean bl) {
        this.modNVABSur = bl;
    }

    public HashMap<Surfactant, double[]> getConcentrationsSur() {
        if (this.concentrationsSur == null) {
            HashMap<Surfactant, double[]> hashMap = new HashMap<Surfactant, double[]>();
            for (CatalogObject catalogObject : this.getSurSelected()) {
                double[] dArray = new double[]{0.0};
                hashMap.put((Surfactant)catalogObject, dArray);
            }
            this.setConcentrationsSur(hashMap);
        }
        return this.concentrationsSur;
    }

    public void setConcentrationsSur(HashMap<Surfactant, double[]> hashMap) {
        this.concentrationsSur = hashMap;
    }

    public HashMap<Surfactant, double[]> getInitialConcentrationsSur() {
        if (this.initialConcentrationsSur == null) {
            HashMap<Surfactant, double[]> hashMap = new HashMap<Surfactant, double[]>();
            for (CatalogObject catalogObject : this.getSurSelected()) {
                double[] dArray = new double[]{0.0};
                hashMap.put((Surfactant)catalogObject, dArray);
            }
            this.setInitialConcentrationsSur(hashMap);
        }
        return this.initialConcentrationsSur;
    }

    public void setInitialConcentrationsSur(HashMap<Surfactant, double[]> hashMap) {
        this.initialConcentrationsSur = hashMap;
    }

    public void setSolubilizationValuesForPollutantAndSurfactant(Pollutant pollutant, Surfactant surfactant, double[] dArray) {
        this.getSolubilizationValues().put(new Pair(pollutant, surfactant), dArray);
    }

    public double[] getSolubilizationValuesForPolutantAndSurfactant(Pollutant pollutant, Surfactant surfactant) {
        if (this.getSolubilizationValues().get(new Pair(pollutant, surfactant)) == null) {
            return new double[]{1.0, 6.0, 0.0, 0.0, 0.0};
        }
        return this.getSolubilizationValues().get(new Pair(pollutant, surfactant));
    }

    public Map<Pair, double[]> getSolubilizationValues() {
        if (this.solubilizationValues == null) {
            this.solubilizationValues = new HashMap<Pair, double[]>();
        }
        return this.solubilizationValues;
    }

    public void setAdsolubilizationValuesForPollutantAndSurfactant(Pollutant pollutant, Surfactant surfactant, double[] dArray) {
        this.getAdsolubilizationValues().put(new Pair(pollutant, surfactant), dArray);
    }

    public double[] getAdsolubilizationValuesForPolutantAndSurfactant(Pollutant pollutant, Surfactant surfactant) {
        if (this.getAdsolubilizationValues().get(new Pair(pollutant, surfactant)) == null) {
            return new double[]{1.0, 6.0, 0.0, 0.0, 0.0};
        }
        return this.getAdsolubilizationValues().get(new Pair(pollutant, surfactant));
    }

    public Map<Pair, double[]> getAdsolubilizationValues() {
        if (this.adsolubilizationValues == null) {
            this.adsolubilizationValues = new HashMap<Pair, double[]>();
        }
        return this.adsolubilizationValues;
    }

    public void setMonomereLayerValuesForSurfactantAndAquiferMaterial(Surfactant surfactant, AquiferMaterial aquiferMaterial, double[] dArray) {
        this.getMonomereLayerValues().put(new Pair(surfactant, aquiferMaterial), dArray);
    }

    public double[] getMonomereLayerValuesForSurfactantAndAquiferMaterial(Surfactant surfactant, AquiferMaterial aquiferMaterial) {
        if (this.getMonomereLayerValues().get(new Pair(surfactant, aquiferMaterial)) == null) {
            return new double[]{1.0, 1.0, 0.0, 0.0, 0.0};
        }
        return this.getMonomereLayerValues().get(new Pair(surfactant, aquiferMaterial));
    }

    public Map<Pair, double[]> getMonomereLayerValues() {
        if (this.monomereLayerValues == null) {
            this.monomereLayerValues = new HashMap<Pair, double[]>();
        }
        return this.monomereLayerValues;
    }

    @Override
    public void addListener(ProjectListener projectListener) {
        this.getObserver().add(projectListener);
    }

    @Override
    public void removeListener(ProjectListener projectListener) {
        int n = this.getObserver().indexOf(projectListener);
        if (n >= 0) {
            this.getObserver().remove(n);
        }
    }

    @Override
    public void notifyListener() {
        for (ProjectListener projectListener : this.getObserver()) {
            projectListener.updateWithData(this.leaves);
        }
    }

    public ArrayList<ProjectListener> getObserver() {
        return this.observer;
    }

    public void setObserver(ArrayList<ProjectListener> arrayList) {
        this.observer = arrayList;
    }

    public Series.Unit getUnit() {
        if (this.unit == null) {
            this.unit = Series.Unit.SEC;
        }
        return this.unit;
    }

    public void setUnit(Series.Unit unit) {
        this.unit = unit;
    }

    public Timesteps getTimesteps() {
        return this.timeSteps;
    }

    public void setTimesteps(Timesteps timesteps) {
        this.timeSteps = timesteps;
    }

    public static enum ConcentrationValue {
        DISS(0, "diss"),
        MIC(1, "mic"),
        SORB(2, "sorb"),
        MONO(3, "mono"),
        DIFF(4, "diff"),
        RED(5, "red");

        private final int index;
        private final String name;

        private ConcentrationValue(int n2, String string2) {
            this.index = n2;
            this.name = string2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum FileFormat {
        CSV(0, "CSV"),
        TECPLOT(1, "TECPLOT"),
        ASCII(2, "ASCII"),
        MATLAB(3, "MATLAB");

        private final int index;
        private final String name;

        private FileFormat(int n2, String string2) {
            this.index = n2;
            this.name = string2;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

