/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.MassFractionMatrix;
import java.awt.Color;
import java.io.Serializable;

public class Material
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private int index;
    private Color color;
    private final Color baseColor = new Color(175, 35, 5);
    private MassFractionMatrix mfm;

    public Material(String string, int n) {
        Material.assertIndexGreaterZero(n);
        this.index = n;
        this.name = string;
        if (n == 1) {
            this.color = this.baseColor;
        }
        this.color = Material.lightUp(this.baseColor, n - 1);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setIndex(int n) {
        Material.assertIndexGreaterZero(n);
        this.color = this.index > n ? Material.lightUp(this.color, this.index - n) : Material.lightDown(this.color, this.index - n);
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public Color getColor() {
        return this.color;
    }

    public String toString() {
        return this.name;
    }

    public void setMfm(MassFractionMatrix massFractionMatrix) {
        this.mfm = massFractionMatrix;
    }

    public MassFractionMatrix getMfm() {
        return this.mfm;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Material material = (Material)object;
        return this.compareTo(material) == 0;
    }

    public int compareTo(Material material) {
        return this.index - material.index;
    }

    public int hashCode() {
        return 1;
    }

    private static Color lightUp(Color color, int n) {
        if (n == 0) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] + (float)n * 0.015f;
        fArray[2] = fArray[2] + (float)n * 0.02f;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    private static Color lightDown(Color color, int n) {
        if (n == 0) {
            return color;
        }
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        fArray[0] = fArray[0] - (float)n * 0.015f;
        fArray[2] = fArray[2] - (float)n * 0.02f;
        return new Color(Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]));
    }

    private static void assertIndexGreaterZero(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("parameter 'index' = " + n + " must be > 0 ");
        }
    }
}

