/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.GrainSize;
import de.dsite.data.catalog.CatalogObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class MassFractionMatrix
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private double[][] data;
    private ArrayList<CatalogObject> components;
    private ArrayList<GrainSize> fractions;
    private double[] fractionPercentages;

    public MassFractionMatrix(ArrayList<CatalogObject> arrayList, ArrayList<GrainSize> arrayList2) {
        MassFractionMatrix.assertComponentsNotNull(arrayList);
        MassFractionMatrix.assertFractionsNotNull(arrayList2);
        this.components = new ArrayList();
        for (CatalogObject comparable : arrayList) {
            this.components.add(comparable);
        }
        this.fractions = new ArrayList();
        for (GrainSize grainSize : arrayList2) {
            this.fractions.add(grainSize);
        }
        this.data = new double[this.components.size()][this.fractions.size()];
        this.fractionPercentages = new double[this.fractions.size()];
    }

    public void setValue(CatalogObject catalogObject, GrainSize grainSize, double d) {
        if (this.components.contains(catalogObject) && this.fractions.contains(grainSize)) {
            int n = this.components.indexOf(catalogObject);
            int n2 = this.fractions.indexOf(grainSize);
            this.data[n][n2] = d;
        }
    }

    public double getValue(CatalogObject catalogObject, GrainSize grainSize) {
        if (this.components.contains(catalogObject) && this.fractions.contains(grainSize)) {
            int n = this.components.indexOf(catalogObject);
            int n2 = this.fractions.indexOf(grainSize);
            return this.data[n][n2];
        }
        return 0.0;
    }

    public void setComponents(ArrayList<CatalogObject> arrayList) {
        double[][] dArray = new double[arrayList.size()][this.fractions.size()];
        int n = 0;
        for (CatalogObject catalogObject : arrayList) {
            if (this.components.contains(catalogObject)) {
                dArray[n] = this.data[this.components.indexOf(catalogObject)];
            }
            ++n;
        }
        this.data = dArray;
        this.components.clear();
        for (CatalogObject catalogObject : arrayList) {
            this.components.add(catalogObject);
        }
    }

    public ArrayList<CatalogObject> getComponents() {
        return this.components;
    }

    public void setFractions(ArrayList<GrainSize> arrayList) {
        double[][] dArray = new double[this.components.size()][arrayList.size()];
        double[] dArray2 = new double[arrayList.size()];
        int n = 0;
        for (GrainSize grainSize : arrayList) {
            if (this.fractions.contains(grainSize)) {
                for (int i = 0; i < this.data.length; ++i) {
                    dArray[i][n] = this.data[i][this.fractions.indexOf(grainSize)];
                }
                dArray2[n] = this.fractionPercentages[this.fractions.indexOf(grainSize)];
            }
            ++n;
        }
        this.data = dArray;
        this.fractionPercentages = dArray2;
        this.fractions.clear();
        for (GrainSize grainSize : arrayList) {
            this.fractions.add(grainSize);
        }
    }

    public double getPercentageOfFraction(GrainSize grainSize) {
        if (this.fractions.contains(grainSize)) {
            return this.fractionPercentages[this.fractions.indexOf(grainSize)];
        }
        return 0.0;
    }

    public void setPercentageOfFraction(GrainSize grainSize, double d) {
        if (this.fractions.contains(grainSize)) {
            this.fractionPercentages[this.fractions.indexOf((Object)grainSize)] = d;
        }
    }

    public ArrayList<GrainSize> getFractions() {
        return this.fractions;
    }

    public MassFractionMatrix clone() {
        try {
            return (MassFractionMatrix)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String printData() {
        return Arrays.deepToString((Object[])this.data);
    }

    public String printFractionPercentages() {
        return Arrays.toString(this.fractionPercentages);
    }

    private static void assertComponentsNotNull(ArrayList<CatalogObject> arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("parameter 'comp' must not be null");
        }
    }

    private static void assertFractionsNotNull(ArrayList<GrainSize> arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("parameter 'frac' must not be null");
        }
    }
}

