/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import java.io.Serializable;

public class Layer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_XOK_VALUE = 0;
    private String name;
    private double xOK;
    private double xUK;

    public Layer(String string, double d, double d2) {
        Layer.assertXOKLessToXUK(d, d2);
        Layer.assertXOKGreaterMINXOKValue(d);
        Layer.assertNameNotNull(string);
        this.name = string;
        this.xOK = Layer.round(d);
        this.xUK = Layer.round(d2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        Layer.assertNameNotNull(string);
        this.name = string;
    }

    public double getXOK() {
        return this.xOK;
    }

    public void setXOK(double d) {
        Layer.assertXOKLessToXUK(d, this.getXUK());
        Layer.assertXOKGreaterMINXOKValue(d);
        this.xOK = Layer.round(d);
    }

    public double getXUK() {
        return this.xUK;
    }

    public void setXUK(double d) {
        Layer.assertXOKGreaterMINXOKValue(d);
        this.xUK = Layer.round(d);
    }

    public String toString() {
        return this.name;
    }

    private static double round(double d) {
        d = Math.round(100000.0 * d);
        return d / 100000.0;
    }

    private static void assertXOKLessToXUK(double d, double d2) {
        if (d > d2) {
            throw new IllegalArgumentException("parameter 'xOK' = " + d + " must be < xUK = " + d2);
        }
    }

    private static void assertXOKGreaterMINXOKValue(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("parameter 'xOK' must be >= 0");
        }
    }

    private static void assertNameNotNull(String string) {
        if (string == null) {
            throw new IllegalArgumentException("parameter 'name' must not be null");
        }
    }
}

