/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.SecondaryLayer;
import de.dsite.data.catalog.Pollutant;
import java.io.Serializable;

public class KeyPair
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Pollutant pollutant;
    private final SecondaryLayer secLayer;

    public KeyPair(Pollutant pollutant, SecondaryLayer secondaryLayer) {
        KeyPair.assertPollutantNotNull(pollutant);
        KeyPair.assertLayerNotNull(secondaryLayer);
        this.pollutant = pollutant;
        this.secLayer = secondaryLayer;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyPair keyPair = (KeyPair)object;
        return this.pollutant.equals(keyPair.pollutant) && this.secLayer.equals(keyPair.secLayer);
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return new String("(" + this.pollutant.getBezeichnung() + ", " + this.secLayer.getName() + ")");
    }

    private static void assertPollutantNotNull(Pollutant pollutant) {
        if (pollutant == null) {
            throw new IllegalArgumentException("parameter 'Pollutant' must not be null");
        }
    }

    private static void assertLayerNotNull(SecondaryLayer secondaryLayer) {
        if (secondaryLayer == null) {
            throw new IllegalArgumentException("parameter 'SecondaryLayer' must not be null");
        }
    }
}

