/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.data;

import de.dsite.data.KeyPair;
import de.dsite.data.SecondaryLayer;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class BioReductionMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<KeyPair, double[]> mapOfValues = new HashMap<KeyPair, double[]>();
    private static final double[] initBioValues = new double[]{0.0, 86400.0, 1.0, 1.0};

    public BioReductionMatrix(ArrayList<CatalogObject> arrayList, ArrayList<SecondaryLayer> arrayList2) {
        if (arrayList != null && arrayList.size() > 0 && arrayList2 != null && arrayList2.size() > 0) {
            for (CatalogObject catalogObject : arrayList) {
                for (SecondaryLayer secondaryLayer : arrayList2) {
                    this.setBioReductionValuesForPollutantAndLayer((Pollutant)catalogObject, secondaryLayer, initBioValues);
                }
            }
        }
    }

    public double[] getBioReductionValuesForPollutantAndLayer(Pollutant pollutant, SecondaryLayer secondaryLayer) {
        BioReductionMatrix.assertPollutantNotNull(pollutant);
        BioReductionMatrix.assertLayerNotNull(secondaryLayer);
        KeyPair keyPair = new KeyPair(pollutant, secondaryLayer);
        if (this.mapOfValues.containsKey(keyPair)) {
            return this.mapOfValues.get(keyPair);
        }
        return null;
    }

    public void setBioReductionValuesForPollutantAndLayer(Pollutant pollutant, SecondaryLayer secondaryLayer, double[] dArray) {
        BioReductionMatrix.assertPollutantNotNull(pollutant);
        BioReductionMatrix.assertLayerNotNull(secondaryLayer);
        if (dArray.length == 4) {
            KeyPair keyPair = new KeyPair(pollutant, secondaryLayer);
            this.mapOfValues.put(keyPair, dArray);
        }
    }

    public void setDefaultBioReductionValuesForPollutantAndLayer(Pollutant pollutant, SecondaryLayer secondaryLayer) {
        BioReductionMatrix.assertPollutantNotNull(pollutant);
        BioReductionMatrix.assertLayerNotNull(secondaryLayer);
        this.mapOfValues.put(new KeyPair(pollutant, secondaryLayer), initBioValues);
    }

    private static void assertPollutantNotNull(CatalogObject catalogObject) {
        if (catalogObject == null) {
            throw new IllegalArgumentException("parameter 'Pollutant' must not be null");
        }
    }

    private static void assertLayerNotNull(SecondaryLayer secondaryLayer) {
        if (secondaryLayer == null) {
            throw new IllegalArgumentException("parameter 'SecondaryLayer' must not be null");
        }
    }
}

