/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.Series;
import de.dsite.data.Timesteps;
import de.dsite.gui.listcard.TimePropertyCard;
import de.dsite.io.ApplicationProperties;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class TimePropertyController
extends ListController {
    private final TableModel tableModel;
    private Series.Unit selectedUnit;
    private ApplicationProperties properties;

    public TimePropertyController(MainWindowController mainWindowController) {
        super(new TimePropertyCard(), mainWindowController);
        try {
            this.properties = ApplicationProperties.getInstance();
            Series.Unit[] unitArray = this.properties.getProperty(ApplicationProperties.PropertyName.UNIT_TIME_PROPERTY_CARD);
            Series.Unit unit = Series.Unit.getUnitWithValue((String)unitArray);
            this.selectedUnit = unit != null ? unit : Series.Unit.SEC;
        }
        catch (IOException iOException) {
            System.err.println("Application properies file could not be loaded!");
            this.selectedUnit = Series.Unit.SEC;
        }
        ((TimePropertyCard)this.view).addConstRadioButtonListener(new RadioButtonListener());
        ((TimePropertyCard)this.view).addAddColumnButtonListener(new AddColumnButtonListener());
        ((TimePropertyCard)this.view).addDelColumnButtonListener(new DelColumnButtonListener());
        this.tableModel = new TableModel();
        ((TimePropertyCard)this.view).addTableModel(this.tableModel);
        for (Series.Unit unit : Series.Unit.values()) {
            ((TimePropertyCard)this.view).getUnitsBox().addItem(unit);
        }
        ((TimePropertyCard)this.view).getUnitsBox().setSelectedItem((Object)this.selectedUnit);
        ((TimePropertyCard)this.view).addUnitsBoxListener(new UnitsListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        if (this.model.getTimesteps() != null) {
            this.tableModel.setTableData(this.model.getTimesteps());
        }
        if (this.model.getTimesteps().numberOfTimesteps() > 1) {
            ((TimePropertyCard)this.view).setRadioButtonVar(true);
        } else {
            ((TimePropertyCard)this.view).setRadioButtonConst(true);
        }
        ((TimePropertyCard)this.view).getUnitsBox().setSelectedItem((Object)this.model.getTimesteps().getUnit());
        this.view.setVisible(true);
    }

    public void loadModelData() {
        if (this.model.getTimesteps() != null) {
            this.tableModel.setTableData(this.model.getTimesteps());
        }
        if (this.model.getTimesteps().numberOfTimesteps() > 1) {
            ((TimePropertyCard)this.view).setRadioButtonVar(true);
        } else {
            ((TimePropertyCard)this.view).setRadioButtonConst(true);
        }
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((TimePropertyCard)this.view).getTable().isEditing()) {
            ((TimePropertyCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private String[] columnNames;
        private Timesteps timesteps;

        TableModel() {
            this.columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_timeproperty_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_timeproperty_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_timeproperty_tcol3) + " (" + TimePropertyController.this.selectedUnit.toString() + ")"};
        }

        public void setUnitLabel(Series.Unit unit) {
            this.columnNames[this.columnNames.length - 1] = MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_timeproperty_tcol3) + " (" + unit.toString() + ")";
            this.fireTableStructureChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            if (this.timesteps == null) {
                return 0;
            }
            return this.timesteps.numberOfTimesteps();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            if (n2 == 1) {
                return this.timesteps.getTimeStepCountForTimestepAtIndex(n);
            }
            return this.timesteps.getTimeStepLengthForTimestepAtIndex(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                try {
                    object = Integer.parseInt((String)object);
                    int n3 = (Integer)object;
                    this.timesteps.setTimeStepCountForTimestepAtIndex(n, n3);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n2 == 2) {
                try {
                    object = Double.parseDouble((String)object);
                    double d = (Double)object;
                    this.timesteps.setTimeStepLengthForTimestepAtIndex(n, d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public void addRow() {
            this.timesteps.addTimestep();
            this.fireTableRowsInserted(this.timesteps.numberOfTimesteps(), this.timesteps.numberOfTimesteps());
        }

        public void addRowAtIndex(int n) {
            this.timesteps.addTimestepAtIndex(n);
            this.fireTableRowsInserted(this.timesteps.numberOfTimesteps(), this.timesteps.numberOfTimesteps());
        }

        public void deleteRow() {
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().isEditing()) {
                ((TimePropertyCard)TimePropertyController.this.view).getTable().getCellEditor().stopCellEditing();
            }
            if (this.timesteps.numberOfTimesteps() > 1) {
                this.timesteps.deleteTimeStepAtIndex(this.timesteps.numberOfTimesteps() - 1);
                this.fireTableRowsDeleted(this.timesteps.numberOfTimesteps() - 1, this.timesteps.numberOfTimesteps() - 1);
            }
        }

        public void deleteRowAtIndex(int n) {
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().isEditing()) {
                ((TimePropertyCard)TimePropertyController.this.view).getTable().getCellEditor().stopCellEditing();
            }
            if (this.timesteps.numberOfTimesteps() > 1 && this.timesteps.numberOfTimesteps() > n) {
                this.timesteps.deleteTimeStepAtIndex(n);
                this.fireTableRowsDeleted(this.timesteps.numberOfTimesteps() - 1, this.timesteps.numberOfTimesteps() - 1);
            }
        }

        private void setTableData(Timesteps timesteps) {
            this.timesteps = timesteps;
            this.fireTableDataChanged();
        }
    }

    private final class UnitsListener
    implements ActionListener {
        private UnitsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            TimePropertyController.this.selectedUnit = (Series.Unit)((Object)jComboBox.getSelectedItem());
            TimePropertyController.this.tableModel.setUnitLabel(TimePropertyController.this.selectedUnit);
            if (TimePropertyController.this.model.getTimesteps() != null) {
                TimePropertyController.this.model.getTimesteps().setUnit(TimePropertyController.this.selectedUnit);
            }
            TimePropertyController.this.properties.setProperty(ApplicationProperties.PropertyName.UNIT_TIME_PROPERTY_CARD, TimePropertyController.this.selectedUnit.getValue());
            try {
                TimePropertyController.this.properties.writeApplicationProperties();
            }
            catch (IOException iOException) {
                System.err.println("Fail to write Application properies to file!");
            }
        }
    }

    private final class DelColumnButtonListener
    implements ActionListener {
        private DelColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().isEditing()) {
                ((TimePropertyCard)TimePropertyController.this.view).getTable().getCellEditor().stopCellEditing();
            }
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().getSelectedRow() != -1) {
                TimePropertyController.this.tableModel.deleteRowAtIndex(((TimePropertyCard)TimePropertyController.this.view).getTable().getSelectedRow());
            } else {
                TimePropertyController.this.tableModel.deleteRow();
            }
            if (TimePropertyController.this.tableModel.getRowCount() == 1) {
                ((TimePropertyCard)TimePropertyController.this.view).setRadioButtonConst(true);
            }
        }
    }

    private final class AddColumnButtonListener
    implements ActionListener {
        private AddColumnButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().isEditing()) {
                ((TimePropertyCard)TimePropertyController.this.view).getTable().getCellEditor().stopCellEditing();
            }
            if (((TimePropertyCard)TimePropertyController.this.view).getTable().getSelectedRow() != -1) {
                TimePropertyController.this.tableModel.addRowAtIndex(((TimePropertyCard)TimePropertyController.this.view).getTable().getSelectedRow() + 1);
            } else {
                TimePropertyController.this.tableModel.addRow();
            }
            ((TimePropertyCard)TimePropertyController.this.view).setRadioButtonVar(true);
        }
    }

    private final class RadioButtonListener
    implements ActionListener {
        private RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (TimePropertyController.this.tableModel.getRowCount() > 1) {
                int n = JOptionPane.showOptionDialog(TimePropertyController.this.view, "" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning_dialog_var_to_const_line1) + "\n " + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.cont), "" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.warning), 0, 2, null, new String[]{"" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.yes), "" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no)}, "" + MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.no));
                if (n == 0) {
                    while (TimePropertyController.this.tableModel.getRowCount() > 1) {
                        TimePropertyController.this.tableModel.deleteRow();
                    }
                } else {
                    ((TimePropertyCard)TimePropertyController.this.view).setRadioButtonVar(true);
                }
            }
        }
    }
}

