/*
 * Decompiled with CFR 0.152.
 */
package de.dsite.controller;

import de.dsite.controller.ListController;
import de.dsite.controller.MainWindowController;
import de.dsite.data.catalog.CatalogObject;
import de.dsite.data.catalog.Pollutant;
import de.dsite.gui.listcard.SorptionCard;
import de.dsite.project.SorptionValue;
import de.dsite.utils.ResourceBundleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SorptionController
extends ListController {
    private final TableModel tableModel;
    private final ListModel<CatalogObject> listModel;

    public SorptionController(MainWindowController mainWindowController) {
        super(new SorptionCard(), mainWindowController);
        ((SorptionCard)this.view).addRadioButtonListener("modeDiff", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setCalculationDaq(true);
            }
        });
        ((SorptionCard)this.view).addRadioButtonListener("modeEQ", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setCalculationDaq(false);
            }
        });
        ((SorptionCard)this.view).addRadioButtonListener("calcDiff1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setCalculationFocKoc(true);
                SorptionController.this.model.setCalculationKd(false);
            }
        });
        ((SorptionCard)this.view).addRadioButtonListener("calcDiff2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setCalculationFocKoc(false);
                SorptionController.this.model.setCalculationKd(true);
            }
        });
        ((SorptionCard)this.view).addRadioButtonListener("calcEq1", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setSorpModeFocKoc(true);
            }
        });
        ((SorptionCard)this.view).addRadioButtonListener("calcEq2", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SorptionController.this.model.setSorpModeFocKoc(false);
            }
        });
        this.tableModel = new TableModel();
        this.listModel = new DefaultListModel<CatalogObject>();
        ((SorptionCard)this.view).addTableModel(this.tableModel);
        ((SorptionCard)this.view).addSorptionListModel(this.listModel);
        ((SorptionCard)this.view).addSorptionListSelectionListener(new SorptionListSelectionListener());
    }

    @Override
    public void loadModelDataAndShowView() {
        ((SorptionCard)this.view).setRadioButtonSelected("calcDiff1", this.model.isCalculationFocKoc());
        ((SorptionCard)this.view).setRadioButtonSelected("calcDiff2", this.model.isCalculationKd());
        ((SorptionCard)this.view).setRadioButtonSelected("calcEq1", this.model.isSorpModeFocKoc());
        ((SorptionCard)this.view).setRadioButtonSelected("calcEq2", !this.model.isSorpModeFocKoc());
        ((SorptionCard)this.view).setRadioButtonSelected("modeDiff", this.model.isCalculationDaq());
        ((SorptionCard)this.view).setRadioButtonSelected("modeEQ", !this.model.isCalculationDaq());
        ((DefaultListModel)this.listModel).clear();
        for (CatalogObject catalogObject : this.model.allPollutants()) {
            ((DefaultListModel)this.listModel).addElement(catalogObject);
        }
        if (this.model.allPollutants().size() > 0 && this.model.getLeaves().size() > 0) {
            this.tableModel.setPollutant(this.model.allPollutants().get(0));
        }
        if (this.model.allPollutants() != null && this.model.allPollutants().size() > 0 && ((SorptionCard)this.view).getPolList().getSelectedIndex() == -1) {
            ((SorptionCard)this.view).getPolList().setSelectedIndex(0);
            ((SorptionCard)this.view).getPolList().requestFocusInWindow();
        }
        this.view.setVisible(true);
    }

    @Override
    public boolean writeUserInputToProject() {
        if (((SorptionCard)this.view).getTable().isEditing()) {
            ((SorptionCard)this.view).getTable().getCellEditor().stopCellEditing();
        }
        return true;
    }

    private final class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol1), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol2), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol3), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol4), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol5), MainWindowController.resourceManager.getLangString(ResourceBundleUtils.ResourceKeys.input_card_sorption_tcol6)};
        private Pollutant pollutant;

        public void setPollutant(Pollutant pollutant) {
            this.pollutant = pollutant;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return SorptionController.this.model.allAquiferMaterials() == null || SorptionController.this.model.allAquiferMaterials().size() == 0 || this.pollutant == null ? 0 : SorptionController.this.model.allAquiferMaterials().size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return SorptionController.this.model.allAquiferMaterials().get(n).getBezeichnung();
            }
            if (n2 >= 1 && n2 <= 5) {
                SorptionValue sorptionValue = SorptionController.this.model.getSorptionValueForPollutantAndAquiferMaterial(this.pollutant, SorptionController.this.model.allAquiferMaterials().get(n));
                if (n2 == 1) {
                    return sorptionValue.getEquilibriumFraction();
                }
                if (n2 == 2) {
                    return sorptionValue.getIsothermType().getIndex();
                }
                if (n2 == 3) {
                    return sorptionValue.getParameter1();
                }
                if (n2 == 4) {
                    return sorptionValue.getParameter2();
                }
                if (n2 == 5) {
                    return sorptionValue.getParameter3();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 > 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            SorptionValue sorptionValue = SorptionController.this.model.getSorptionValueForPollutantAndAquiferMaterial(this.pollutant, SorptionController.this.model.allAquiferMaterials().get(n));
            if (n2 == 1) {
                try {
                    double d = (Double)object;
                    sorptionValue.setEquilibriumFraction(d);
                    this.fireTableDataChanged();
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n2 == 2) {
                try {
                    int n3 = (Integer)object;
                    if (n3 == 1 || n3 == 2 || n3 == 3 || n3 == 4) {
                        if (n3 == 1) {
                            sorptionValue.setIsothermType(SorptionValue.IsothermType.HENRY);
                        } else if (n3 == 2) {
                            sorptionValue.setIsothermType(SorptionValue.IsothermType.FREUNDLICH);
                        } else if (n3 == 3) {
                            sorptionValue.setIsothermType(SorptionValue.IsothermType.LANGMUIR);
                        } else if (n3 == 4) {
                            sorptionValue.setIsothermType(SorptionValue.IsothermType.BET);
                        }
                        this.fireTableDataChanged();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (n2 >= 3 && n2 <= 5) {
                try {
                    double d = (Double)object;
                    if (n2 == 3) {
                        sorptionValue.setParameter1(d);
                    }
                    if (n2 == 4) {
                        sorptionValue.setParameter2(d);
                    }
                    if (n2 == 5) {
                        sorptionValue.setParameter3(d);
                    }
                    this.fireTableDataChanged();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            if (n == 2) {
                return Integer.class;
            }
            return Double.class;
        }
    }

    private final class SorptionListSelectionListener
    implements ListSelectionListener {
        private SorptionListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && SorptionController.this.model.allPollutants().size() > 0 && SorptionController.this.model.allAquiferMaterials().size() > 0) {
                if (((SorptionCard)SorptionController.this.view).getTable().isEditing()) {
                    ((SorptionCard)SorptionController.this.view).getTable().getCellEditor().stopCellEditing();
                }
                int n = ((JList)listSelectionEvent.getSource()).getSelectedIndex();
                SorptionController.this.tableModel.setPollutant((Pollutant)SorptionController.this.listModel.getElementAt(n));
            }
        }
    }
}

